/*
 * Decompiled with CFR 0.152.
 */
package cds.vizier;

import cds.aladin.Glu;
import cds.aladin.MyInputStream;
import cds.tools.CDSConstants;
import cds.tools.CDSMethods;
import cds.xml.XMLConsumer;
import cds.xml.XMLParser;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class VizieRQuery
implements XMLConsumer,
CDSConstants {
    static final int KEYWORDS = 0;
    static final int SURVEYS = 1;
    static final int ARCHIVES = 2;
    static final int CATALOGS = 3;
    static final int TD = 4;
    static final int SURVEYMAXCOL = 3;
    static final int ARCHIVEMAXCOL = 3;
    private int section;
    private String currentCat = null;
    private String currentWaveLength = null;
    private String currentDensity = null;
    private String currentDesc = null;
    private String metaError;
    private Vector vKey;
    private boolean inCSV;
    private boolean inTD;
    private boolean inDesc;
    private String headlines;
    private String recsep;
    private String colsep;
    private int column = 0;
    private static Vector vSurveys = null;
    private static Vector vArchives = null;
    private static Hashtable hKey = null;
    private static Vector nameKey = null;
    private StringBuffer currentSurvey = new StringBuffer();
    private StringBuffer currentArchive = new StringBuffer();
    private MyInputStream vizierStream = null;
    private int currentFormat = 0;
    private Vector resultat = null;
    protected Glu glu = null;

    public static void resetKeywords() {
        nameKey = null;
        vArchives = null;
        vSurveys = null;
        hKey = null;
    }

    public boolean metaDataQuery() {
        if (vSurveys != null) {
            return true;
        }
        XMLParser xMLParser = new XMLParser(this);
        this.metaError = null;
        this.section = -1;
        vSurveys = new Vector(30);
        vArchives = new Vector(30);
        hKey = new Hashtable();
        nameKey = new Vector();
        this.vKey = null;
        this.inCSV = false;
        URL uRL = null;
        try {
            uRL = this.glu != null ? this.glu.getURL("VizieR.Meta", "", false, false) : new URL("http://vizier.u-strasbg.fr/viz-bin/nph-metaladin");
            InputStream inputStream = this.glu.aladin.getCache().get(uRL);
            MyInputStream myInputStream = new MyInputStream(inputStream);
            boolean bl = xMLParser.parse(myInputStream);
            return bl && this.metaError == null;
        }
        catch (Exception exception) {
            this.metaError = "" + exception;
            System.err.println("metaDataQuery : " + exception);
            exception.printStackTrace();
            return false;
        }
    }

    public boolean catalogsDataQuery(String string, int n, Vector vector) {
        XMLParser xMLParser = new XMLParser(this);
        this.metaError = null;
        this.section = 3;
        this.inDesc = false;
        this.currentCat = null;
        this.currentWaveLength = null;
        this.currentDensity = null;
        this.currentDesc = null;
        this.resultat = vector;
        URL uRL = null;
        try {
            uRL = this.glu != null ? this.glu.getURL("VizieR.MetaCat", string, true) : new URL("http://vizier.u-strasbg.fr/cgi-bin/votable?-meta&" + string);
            if (n == 1) {
                this.resultat.clear();
                MyInputStream myInputStream = new MyInputStream(uRL.openStream());
                boolean bl = xMLParser.parse(myInputStream);
                return bl;
            }
            this.vizierStream = new MyInputStream(uRL.openStream());
            return this.vizierStream != null;
        }
        catch (Exception exception) {
            this.metaError = "" + exception;
            System.err.println("catalogsDataQuery : " + exception);
            return false;
        }
    }

    @Override
    public void startElement(String string, Hashtable hashtable) {
        if (string.equals("VOTABLE")) {
            this.currentFormat = 1;
        }
        if (string.equals("ASTRO")) {
            this.currentFormat = 0;
        }
        if (this.section == 3) {
            String string2;
            if (string.equals("DESCRIPTION")) {
                this.inDesc = true;
            } else if (string.equals("RESOURCE")) {
                if (this.currentFormat == 1) {
                    this.currentCat = (String)hashtable.get("name");
                } else if (this.currentFormat == 0) {
                    this.currentCat = (String)hashtable.get("ID");
                }
            } else if (string.equals("INFO") && (string2 = (String)hashtable.get("name")) != null) {
                if (string2.equals("-kw.Wavelength")) {
                    this.currentWaveLength = (String)hashtable.get("value");
                }
                if (string2.equals("-density")) {
                    this.currentDensity = (String)hashtable.get("value");
                }
            }
            return;
        }
        if (string.equals("RESOURCE")) {
            String string3 = (String)hashtable.get("ID");
            if (string3 != null && string3.equals("VizieR")) {
                this.section = 0;
            }
        } else if (string.equals("TABLE")) {
            String string4 = (String)hashtable.get("ID");
            if (string4 != null && string4.equals("AladinSurveys")) {
                this.section = 1;
            } else if (string4 != null && string4.equals("AladinArchives")) {
                this.section = 2;
            }
        } else if (this.section == 0 && string.equals("PARAM") && this.currentFormat == 1) {
            String string5 = (String)hashtable.get("name");
            if (string5.startsWith("-kw.")) {
                this.vKey = new Vector(30);
                nameKey.addElement(string5);
                hKey.put(string5, this.vKey);
            }
        } else if (this.section == 0 && string.equals("FIELD") && this.currentFormat == 0) {
            String string6 = (String)hashtable.get("name");
            if (string6.startsWith("-kw.")) {
                this.vKey = new Vector(30);
                nameKey.addElement(string6);
                hKey.put(string6, this.vKey);
            }
        } else if (this.vKey != null && string.equals("OPTION")) {
            String string7 = (String)hashtable.get("value");
            if (string7 != null) {
                this.vKey.addElement(string7);
            }
        } else if ((this.section == 1 || this.section == 2) && string.equals("CSV")) {
            this.inCSV = true;
            this.headlines = (String)hashtable.get("headlines");
            this.recsep = (String)hashtable.get("recsep");
            this.colsep = (String)hashtable.get("colsep");
        } else if ((this.section == 1 || this.section == 2) && string.equals("TD")) {
            this.inTD = true;
            ++this.column;
        } else if (string.equals("TR")) {
            this.currentSurvey = new StringBuffer();
            this.currentArchive = new StringBuffer();
            this.column = 0;
        }
    }

    @Override
    public void endElement(String string) {
        if (this.vKey != null && string.equals("FIELD")) {
            this.vKey = null;
        } else if (this.section == 3 && string.equals("DESCRIPTION")) {
            this.inDesc = false;
        } else if (string.equals("CSV")) {
            this.inCSV = false;
        } else if (string.equals("RESOURCE") && this.currentCat != null) {
            this.addItem(this.currentCat + "\t" + this.currentWaveLength + "\t" + this.currentDensity + "\t" + this.currentDesc);
            this.currentCat = null;
            this.currentDesc = "";
            this.currentDensity = "";
            this.currentWaveLength = "";
        }
    }

    private int getField(StringBuffer stringBuffer, char[] cArray, int n, int n2, char c, char c2) {
        int n3 = n;
        while (n < n2 && cArray[n] != c2 && cArray[n] != c) {
            ++n;
        }
        String string = new String(cArray, n3, n - n3).trim();
        if (string.length() != 0) {
            if (stringBuffer.length() != 0) {
                stringBuffer.append("\t");
            }
            stringBuffer.append(string);
        }
        return cArray[n] == c2 ? n + 1 : n;
    }

    private int getRec(StringBuffer stringBuffer, char[] cArray, int n, int n2, char c, char c2) {
        while (n < n2 && cArray[n] != c) {
            n = this.getField(stringBuffer, cArray, n, n2, c, c2);
        }
        return n;
    }

    @Override
    public void characters(char[] cArray, int n, int n2) {
        char c = '\n';
        char c2 = '\t';
        int n3 = n;
        int n4 = n + n2;
        int n5 = 0;
        if (this.section == 3) {
            if (this.inDesc) {
                this.currentDesc = new String(cArray, n, n2);
            }
            return;
        }
        if (this.inCSV) {
            StringBuffer stringBuffer;
            if (this.recsep != null) {
                c = this.recsep.charAt(0);
            }
            if (this.colsep != null) {
                c2 = this.colsep.charAt(0);
            }
            int n6 = this.headlines == null ? 0 : Integer.parseInt(this.headlines);
            n5 = 0;
            for (n5 = 0; n3 < n4 && n5 < n6; ++n3, ++n5) {
                stringBuffer = new StringBuffer();
                n3 = this.getRec(stringBuffer, cArray, n3, n4, c, c2);
            }
            while (n3 < n4) {
                stringBuffer = new StringBuffer();
                n3 = this.getRec(stringBuffer, cArray, n3, n4, c, c2);
                switch (this.section) {
                    case 1: {
                        vSurveys.addElement(stringBuffer.toString());
                        break;
                    }
                    case 2: {
                        vArchives.addElement(stringBuffer.toString());
                    }
                }
                ++n3;
            }
            return;
        }
        if (this.inTD) {
            String string = new String(cArray, n, n2);
            switch (this.section) {
                case 1: {
                    if (this.column < 3) {
                        if (this.column != 1) {
                            this.currentSurvey.append("\t");
                        }
                        this.currentSurvey.append(string);
                    } else {
                        this.currentSurvey.append("\t");
                        this.currentSurvey.append(string);
                        vSurveys.addElement(this.currentSurvey.toString());
                    }
                    this.inTD = false;
                    break;
                }
                case 2: {
                    if (this.column < 3) {
                        if (this.column != 1) {
                            this.currentArchive.append("\t");
                        }
                        this.currentArchive.append(string);
                    } else {
                        this.currentArchive.append("\t");
                        this.currentArchive.append(string);
                        vArchives.addElement(this.currentArchive.toString());
                    }
                    this.inTD = false;
                }
            }
            return;
        }
    }

    public String getMetaError() {
        return this.metaError;
    }

    public Vector getvArchives() {
        return vArchives;
    }

    public Vector getvSurveys() {
        return vSurveys;
    }

    public Hashtable gethKey() {
        return hKey;
    }

    public Vector getNameKey() {
        return nameKey;
    }

    public void setGLU(Glu glu) {
        this.glu = glu;
    }

    protected void addItem(String string) {
        if (this.resultat != null) {
            this.resultat.addElement(string);
        }
    }

    public MyInputStream getResultStream() {
        return this.vizierStream;
    }

    public boolean submit(String string, String string2, String string3, String string4, String string5, String string6, int n, Vector vector) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string == null) {
            stringBuffer.append("-pos");
        } else {
            CDSMethods.append(stringBuffer, "-c", string);
            if (string2 != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
                if (stringTokenizer.hasMoreTokens()) {
                    CDSMethods.append(stringBuffer, "-c.r", stringTokenizer.nextToken());
                }
                if (stringTokenizer.hasMoreTokens()) {
                    String string7 = stringTokenizer.nextToken();
                    if (string7.compareTo("deg") == 0 || string7.compareTo("degree") == 0) {
                        CDSMethods.append(stringBuffer, "-c.u", "degree");
                    } else {
                        CDSMethods.append(stringBuffer, "-c.u", string7);
                    }
                } else {
                    CDSMethods.append(stringBuffer, "-c.u", "arcmin");
                }
            }
        }
        if (string4 != null && string4.compareTo("") != 0) {
            CDSMethods.append(stringBuffer, "-c.eq", string4);
        }
        if (string5 != null && string5.compareTo("") != 0) {
            CDSMethods.append(stringBuffer, "-words", string5);
        }
        if (string6 != null) {
            stringBuffer.append('&' + string6);
        }
        return this.callVizieR(stringBuffer.toString(), n, vector);
    }

    public boolean submit(String string, String string2, String string3, String string4, String string5, int n, Vector vector) {
        return this.submit(string, string2, string3, null, string4, string5, n, vector);
    }

    protected boolean callVizieR(String string, int n, Vector vector) {
        if (string == null) {
            System.out.println("param null");
        }
        if (vector == null) {
            System.out.println("resultat null");
        }
        boolean bl = this.catalogsDataQuery(string, n, vector);
        if (n == 1) {
            return bl && vector != null && vector.size() > 0;
        }
        return bl;
    }

    public void query() {
    }
}

