/*
 * Decompiled with CFR 0.152.
 */
package cds.vizier;

import cds.tools.TwoColorJTable;
import cds.tools.Util;
import cds.vizier.VizieRCatalog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

public final class VizieRTable
extends TwoColorJTable {
    public static final int SURVEY_MODE = 0;
    public static final int SEARCH_MODE = 1;
    protected JTextField catalog;
    protected JButton getReadMe;
    protected JButton getMoc;
    protected Vector vCats;
    protected Vector v;
    private final int mode;
    static final boolean LSCREEN = Toolkit.getDefaultToolkit().getScreenSize().width > 1000;
    protected static final int SIZE = LSCREEN ? 12 : 10;
    protected static Font COURIER = new Font("Monospaced", 0, SIZE);
    private int colIdx = -1;
    boolean ascending = true;
    private Vector selectedCats;

    public VizieRTable(JTextField jTextField, JButton jButton, JButton jButton2, Vector vector) {
        this(jTextField, jButton, jButton2, vector, 20, 0);
    }

    public VizieRTable(JTextField jTextField, JButton jButton, JButton jButton2, Vector vector, int n, int n2) {
        this.mode = n2;
        this.v = vector;
        this.vCats = this.createObjectsFromRows(vector);
        this.catalog = jTextField;
        this.getReadMe = jButton;
        this.getMoc = jButton2;
        this.setGridColor(Color.lightGray);
        this.setModel(new VizieRTableModel());
        this.getTableHeader().setReorderingAllowed(false);
        this.getTableHeader().addMouseListener(new VizieRTableHeaderListener());
        if (n2 == 1) {
            this.addMouseListener(new VizieRTableMouseListener());
        }
        if (n2 == 0) {
            this.getColumnModel().getColumn(0).setPreferredWidth(80);
            this.getColumnModel().getColumn(1).setPreferredWidth(300);
            this.getColumnModel().getColumn(2).setPreferredWidth(100);
        } else {
            this.getColumnModel().getColumn(0).setPreferredWidth(20);
            this.getColumnModel().getColumn(1).setPreferredWidth(90);
            this.getColumnModel().getColumn(2).setPreferredWidth(70);
            this.getColumnModel().getColumn(3).setPreferredWidth(60);
            this.getColumnModel().getColumn(4).setPreferredWidth(330);
        }
        this.setVisibleRowCount(n);
        this.getTableHeader().setDefaultRenderer(new VizieRTableHeaderRenderer(this.getTableHeader().getDefaultRenderer()));
        this.setFont(COURIER);
        this.getSelectionModel().addListSelectionListener(new VizieRTableSelectionListener());
    }

    public VizieRTable(Vector vector) {
        this(null, null, null, vector, 20, 0);
    }

    private void setVisibleRowCount(int n) {
        int n2 = this.getRowHeight() * n;
        this.setPreferredScrollableViewportSize(new Dimension(560, n2));
    }

    private Vector createObjectsFromRows(Vector vector) {
        int n;
        Vector<VizieRCatalog> vector2 = new Vector<VizieRCatalog>();
        Enumeration enumeration = vector.elements();
        int n2 = n = this.mode == 0 ? 3 : 4;
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = null;
            String string3 = null;
            int n3 = -1;
            String string4 = null;
            int n4 = -1;
            String[] stringArray = string.split("\t", -1);
            if (stringArray.length < n) continue;
            if (this.mode == 0) {
                string2 = stringArray[0];
                string3 = stringArray[1];
                try {
                    n3 = Integer.parseInt(stringArray[2]);
                }
                catch (NumberFormatException numberFormatException) {
                    n3 = 0;
                }
            } else {
                string2 = stringArray[0];
                string4 = stringArray[1];
                try {
                    n4 = Integer.parseInt(stringArray[2]);
                }
                catch (NumberFormatException numberFormatException) {
                    n4 = 0;
                }
                string3 = stringArray[3];
            }
            vector2.add(new VizieRCatalog(string2, string3, string4, n4, n3));
        }
        return vector2;
    }

    public void selectCatalog(String string) {
        Enumeration enumeration = this.vCats.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            if (((VizieRCatalog)enumeration.nextElement()).getName().equals(string)) {
                this.setRowSelectionInterval(n, n);
            }
            ++n;
        }
    }

    public JTextField getCatalogField() {
        return this.catalog;
    }

    public JTextField getCatalogTextField() {
        return this.catalog;
    }

    public Vector getList() {
        return this.v;
    }

    public void resetList() {
        if (this.mode == 1) {
            this.colIdx = -1;
            this.getTableHeader().repaint();
        }
        this.clearSelection();
        this.selectedCats = null;
        ((AbstractTableModel)this.getModel()).fireTableRowsUpdated(0, this.vCats.size() - 1);
    }

    protected void preSelection(Vector vector) {
        this.v = vector;
        this.vCats = this.createObjectsFromRows(vector);
        this.selectedCats = null;
        ((AbstractTableModel)this.getModel()).fireTableDataChanged();
    }

    public void setReadMeButton(JButton jButton) {
        this.getReadMe = jButton;
    }

    public void setCatalogTextField(JTextField jTextField) {
        this.catalog = jTextField;
    }

    public JButton getReadMeButton() {
        return this.getReadMe;
    }

    private void sort(Vector vector, boolean bl, Comparator comparator) {
        List<Object> list = Arrays.asList(vector.toArray());
        Collections.sort(list, comparator);
        if (!bl) {
            Collections.reverse(list);
        }
        this.vCats = new Vector<Object>(list);
        ((AbstractTableModel)this.getModel()).fireTableRowsUpdated(0, this.vCats.size() - 1);
        this.getTableHeader().repaint();
    }

    private boolean isSelected(int n) {
        int[] nArray = this.getSelectedRows();
        for (int i = 0; i < nArray.length; ++i) {
            if (n != nArray[i]) continue;
            return true;
        }
        return false;
    }

    private Vector getSelectedCats() {
        int[] nArray = this.getSelectedRows();
        Vector vector = new Vector();
        for (int i = 0; i < nArray.length; ++i) {
            vector.add(this.vCats.get(nArray[i]));
        }
        return vector;
    }

    class VizieRTableMouseListener
    extends MouseAdapter {
        VizieRTableMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            super.mousePressed(mouseEvent);
            int n = VizieRTable.this.rowAtPoint(mouseEvent.getPoint());
            int n2 = VizieRTable.this.columnAtPoint(mouseEvent.getPoint());
            if (n2 == 0) {
                VizieRCatalog vizieRCatalog = (VizieRCatalog)VizieRTable.this.vCats.get(n);
                if (VizieRTable.this.selectedCats != null) {
                    for (int i = 0; i < VizieRTable.this.vCats.size(); ++i) {
                        VizieRCatalog vizieRCatalog2 = (VizieRCatalog)VizieRTable.this.vCats.get(i);
                        if (!VizieRTable.this.selectedCats.contains(vizieRCatalog2)) continue;
                        if (vizieRCatalog2 == vizieRCatalog) {
                            VizieRTable.this.removeRowSelectionInterval(i, i);
                            continue;
                        }
                        VizieRTable.this.addRowSelectionInterval(i, i);
                    }
                }
            }
            VizieRTable.this.selectedCats = VizieRTable.this.getSelectedCats();
        }
    }

    class VizieRTableHeaderRenderer
    extends DefaultTableCellRenderer {
        TableCellRenderer renderer;

        public VizieRTableHeaderRenderer(TableCellRenderer tableCellRenderer) {
            this.renderer = tableCellRenderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = this.renderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (component instanceof JLabel) {
                if (n2 == VizieRTable.this.colIdx) {
                    ImageIcon imageIcon = VizieRTable.this.ascending ? Util.getAscSortIcon() : Util.getDescSortIcon();
                    ((JLabel)component).setIcon(imageIcon);
                    ((JLabel)component).setHorizontalTextPosition(10);
                } else {
                    ((JLabel)component).setIcon(null);
                }
            }
            return component;
        }
    }

    class VizieRTableHeaderListener
    extends MouseAdapter {
        VizieRTableHeaderListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            TableColumnModel tableColumnModel = VizieRTable.this.getColumnModel();
            int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
            final int n2 = VizieRTable.this.convertColumnIndexToModel(n);
            VizieRTable.this.colIdx = n2;
            if (VizieRTable.this.mode == 1 && n2 == 0) {
                return;
            }
            if (mouseEvent.getClickCount() == 1 && n2 != -1) {
                Comparator comparator = new Comparator(){

                    public final int compare(Object object, Object object2) {
                        Object object3 = null;
                        Object object4 = null;
                        if (VizieRTable.this.mode == 0) {
                            switch (n2) {
                                case 0: {
                                    object4 = ((VizieRCatalog)object).getName();
                                    object3 = ((VizieRCatalog)object2).getName();
                                    break;
                                }
                                case 1: {
                                    object4 = ((VizieRCatalog)object).getDesc();
                                    object3 = ((VizieRCatalog)object2).getDesc();
                                    break;
                                }
                                case 2: {
                                    object4 = new Integer(((VizieRCatalog)object).getNbKRow());
                                    object3 = new Integer(((VizieRCatalog)object2).getNbKRow());
                                }
                            }
                        } else {
                            switch (n2) {
                                case 1: {
                                    object4 = ((VizieRCatalog)object).getName();
                                    object3 = ((VizieRCatalog)object2).getName();
                                    break;
                                }
                                case 2: {
                                    object4 = ((VizieRCatalog)object).getCategory();
                                    object3 = ((VizieRCatalog)object2).getCategory();
                                    break;
                                }
                                case 3: {
                                    object4 = new Integer(((VizieRCatalog)object).getDensity());
                                    object3 = new Integer(((VizieRCatalog)object2).getDensity());
                                    break;
                                }
                                case 4: {
                                    object4 = ((VizieRCatalog)object).getDesc();
                                    object3 = ((VizieRCatalog)object2).getDesc();
                                }
                            }
                        }
                        return ((Comparable)object4).compareTo(object3);
                    }
                };
                final Vector vector = VizieRTable.this.getSelectedCats();
                VizieRTable.this.sort(VizieRTable.this.vCats, VizieRTable.this.ascending, comparator);
                VizieRTable.this.ascending = !VizieRTable.this.ascending;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        VizieRTable.this.clearSelection();
                        for (int i = 0; i < VizieRTable.this.vCats.size(); ++i) {
                            VizieRCatalog vizieRCatalog = (VizieRCatalog)VizieRTable.this.vCats.get(i);
                            if (!vector.contains(vizieRCatalog)) continue;
                            VizieRTable.this.addRowSelectionInterval(i, i);
                        }
                    }
                });
            }
        }
    }

    class VizieRTableModel
    extends AbstractTableModel {
        VizieRTableModel() {
        }

        @Override
        public String getColumnName(int n) {
            if (VizieRTable.this.mode == 0) {
                switch (n) {
                    case 0: {
                        return "Name";
                    }
                    case 1: {
                        return "Description";
                    }
                    case 2: {
                        return "Nb of KRows";
                    }
                }
                return "";
            }
            switch (n) {
                case 0: {
                    return "";
                }
                case 1: {
                    return "Name";
                }
                case 2: {
                    return "Category";
                }
                case 3: {
                    return "Density";
                }
                case 4: {
                    return "Description";
                }
            }
            return "";
        }

        @Override
        public int getRowCount() {
            return VizieRTable.this.vCats == null ? 0 : VizieRTable.this.vCats.size();
        }

        @Override
        public int getColumnCount() {
            return VizieRTable.this.mode == 0 ? 3 : 5;
        }

        public Class getColumnClass(int n) {
            if (VizieRTable.this.mode == 1 && n == 0) {
                return Boolean.class;
            }
            return String.class;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (VizieRTable.this.mode == 0) {
                switch (n2) {
                    case 0: {
                        return ((VizieRCatalog)VizieRTable.this.vCats.get(n)).getName();
                    }
                    case 1: {
                        return ((VizieRCatalog)VizieRTable.this.vCats.get(n)).getDesc();
                    }
                    case 2: {
                        return new Integer(((VizieRCatalog)VizieRTable.this.vCats.get(n)).getNbKRow());
                    }
                }
                return "";
            }
            switch (n2) {
                case 0: {
                    return VizieRTable.this.isSelected(n) ? Boolean.TRUE : Boolean.FALSE;
                }
                case 1: {
                    return ((VizieRCatalog)VizieRTable.this.vCats.get(n)).getName();
                }
                case 2: {
                    return ((VizieRCatalog)VizieRTable.this.vCats.get(n)).getCategory();
                }
                case 3: {
                    return new Integer(((VizieRCatalog)VizieRTable.this.vCats.get(n)).getDensity());
                }
                case 4: {
                    return ((VizieRCatalog)VizieRTable.this.vCats.get(n)).getDesc();
                }
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return VizieRTable.this.mode == 1 && n2 == 0;
        }
    }

    class VizieRTableSelectionListener
    implements ListSelectionListener {
        VizieRTableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n;
            String string = "";
            int[] nArray = VizieRTable.this.getSelectedRows();
            VizieRCatalog[] vizieRCatalogArray = new VizieRCatalog[nArray.length];
            for (n = 0; n < nArray.length; ++n) {
                vizieRCatalogArray[n] = (VizieRCatalog)VizieRTable.this.vCats.get(nArray[n]);
            }
            for (n = 0; n < vizieRCatalogArray.length; ++n) {
                String string2 = vizieRCatalogArray[n].getName();
                string = !string.equals("") ? string + "," + string2 : string2;
            }
            if (VizieRTable.this.catalog != null) {
                VizieRTable.this.catalog.setText(string);
            }
            if (VizieRTable.this.getReadMe != null) {
                VizieRTable.this.getReadMe.setEnabled(n == 1);
            }
            if (VizieRTable.this.getMoc != null) {
                VizieRTable.this.getMoc.setEnabled(n == 1);
            }
        }
    }
}

