/*
 * Decompiled with CFR 0.152.
 */
package cds.xml;

import cds.tools.Util;
import java.util.Hashtable;

public final class Field {
    private static String NUMDATATYPE = "JKEFGDI";
    public String ID;
    public String name;
    public String description;
    public String title;
    public String type;
    public String unit;
    public String ucd;
    public String datatype;
    public String width;
    public String utype;
    public String arraysize;
    public String precision;
    public String href;
    public String gref;
    public String refText;
    public String refValue;
    public String nullValue;
    public int columnSize = 10;
    public static final int RA = 1;
    public static final int DE = 2;
    public static final int PMRA = 3;
    public static final int PMDE = 4;
    public static final int X = 5;
    public static final int Y = 6;
    public static final String[] COOSIGN = new String[]{"", "RA", "DE", "PMRA", "PMDE", "X", "Y"};
    public int coo;
    public static final int FREQ = 1;
    public static final int FLUX = 2;
    public static final int FLUXERR = 3;
    public static final int SEDID = 4;
    public static final String[] SEDLABEL = new String[]{"", "SED_FREQ", "SED_FLUX", "SED_FLUXERR", "SED_SEDID"};
    public int sed;
    public String ref;
    public int sort;
    public boolean visible = true;
    public String hpxFinderPattern;
    public static final int UNSORT = 0;
    public static final int SORT_ASCENDING = 1;
    public static final int SORT_DESCENDING = 2;

    public Field(Hashtable hashtable) {
        this.ID = (String)hashtable.get("ID");
        this.name = (String)hashtable.get("name");
        this.unit = (String)hashtable.get("unit");
        this.ucd = (String)hashtable.get("UCD");
        if (this.ucd == null) {
            this.ucd = (String)hashtable.get("ucd");
        }
        this.utype = (String)hashtable.get("utype");
        this.datatype = Field.typeVOTable2Fits((String)hashtable.get("datatype"));
        this.width = (String)hashtable.get("width");
        this.nullValue = (String)hashtable.get("nullValue");
        this.precision = (String)hashtable.get("precision");
        this.type = (String)hashtable.get("type");
        this.arraysize = (String)hashtable.get("arraysize");
        this.ref = (String)hashtable.get("ref");
        this.sort = 0;
        this.computeColumnSize();
    }

    public Field(Field field) {
        this.description = field.description;
        this.ID = field.ID;
        this.name = field.name;
        this.unit = field.unit;
        this.ucd = field.ucd;
        this.utype = field.utype;
        this.datatype = field.datatype;
        this.width = field.width;
        this.precision = field.precision;
        this.type = field.type;
        this.arraysize = field.arraysize;
        this.href = field.href;
        this.gref = field.gref;
        this.refText = field.refText;
        this.refValue = field.refValue;
        this.ref = field.ref;
        this.coo = field.coo;
        this.title = field.title;
        this.sort = 0;
        this.visible = field.visible;
        this.columnSize = field.columnSize;
        this.nullValue = field.nullValue;
    }

    public void computeColumnSize() {
        int n = 0;
        if (this.width != null) {
            try {
                n = Integer.parseInt(this.width);
            }
            catch (Exception exception) {
                n = 0;
            }
        }
        if (n == 0 && this.arraysize != null) {
            try {
                n = !this.arraysize.endsWith("*") ? Integer.parseInt(this.arraysize) : Integer.parseInt(this.arraysize.substring(0, this.arraysize.length() - 1));
                if (n > 20) {
                    n = 0;
                }
            }
            catch (Exception exception) {
                n = 0;
            }
        }
        if (n == 0) {
            n = 10;
        }
        this.columnSize = n;
    }

    public boolean equals(Field field) {
        if (this == field) {
            return true;
        }
        if (this.utype != null && this.utype.equals(field.utype)) {
            return true;
        }
        if (this.name != null && !this.name.equals(field.name)) {
            return false;
        }
        if (this.unit != null && !this.unit.equals(field.unit)) {
            return false;
        }
        return this.ucd == null || this.ucd.equals(field.ucd);
    }

    public int getFieldSignature() {
        return this.coo;
    }

    public boolean isRa() {
        return this.coo == 1;
    }

    public boolean isDe() {
        return this.coo == 2;
    }

    public boolean isPmRa() {
        return this.coo == 3;
    }

    public boolean isPmDe() {
        return this.coo == 4;
    }

    public boolean isX() {
        return this.coo == 5;
    }

    public boolean isY() {
        return this.coo == 6;
    }

    public String getCooSignature() {
        return COOSIGN[this.coo];
    }

    public Field(String string) {
        this.name = string;
    }

    public void addInfo(String string, String string2) {
        if (string.equals("DESCRIPTION")) {
            this.description = (this.description == null ? "" : this.description) + string2;
        } else if (string.equals("TITLE")) {
            this.title = (this.title == null ? "" : this.title) + string2;
        } else if (string.equals("href")) {
            this.href = string2;
        } else if (string.equals("gref")) {
            this.gref = string2;
        } else if (string.equals("refText")) {
            this.refText = string2;
        } else if (string.equals("refValue")) {
            this.refValue = string2;
        } else if (string.equals("sed")) {
            this.setSEDtag(string2);
        } else {
            return;
        }
    }

    public boolean isNumDataType() {
        return this.datatype != null && NUMDATATYPE.indexOf(this.datatype) >= 0;
    }

    public String getSEDtag() {
        if (this.sed == 0 || this.sed >= SEDLABEL.length) {
            return null;
        }
        return SEDLABEL[this.sed];
    }

    private void setSEDtag(String string) {
        int n = Util.indexInArrayOf(string, SEDLABEL, true);
        if (n == -1) {
            n = 0;
        }
        this.sed = n;
    }

    public static String typeFits2VOTable(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() > 1) {
            return string;
        }
        if (string.equals("J")) {
            return "int";
        }
        if (string.equals("K")) {
            return "long";
        }
        if (string.equals("A")) {
            return "char";
        }
        if (string.equals("E")) {
            return "float";
        }
        if (string.equals("D")) {
            return "double";
        }
        if (string.equals("F")) {
            return "double";
        }
        if (string.equals("G")) {
            return "double";
        }
        if (string.equals("L")) {
            return "boolean";
        }
        if (string.equals("I")) {
            return "short";
        }
        if (string.equals("X")) {
            return "bit";
        }
        if (string.equals("B")) {
            return "unsignedByte";
        }
        if (string.equals("C")) {
            return "floatComplex";
        }
        if (string.equals("M")) {
            return "doubleComplex";
        }
        if (string.equals("U")) {
            return "unicodeChar";
        }
        return "char";
    }

    public static String typeVOTable2Fits(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() < 2) {
            return string;
        }
        if (string.startsWith("int")) {
            return "J";
        }
        if (string.equals("long")) {
            return "K";
        }
        if (string.startsWith("char")) {
            return "A";
        }
        if (string.equals("string")) {
            return "A";
        }
        if (string.equals("float")) {
            return "E";
        }
        if (string.equals("double")) {
            return "D";
        }
        if (string.equals("boolean")) {
            return "L";
        }
        if (string.equals("short")) {
            return "I";
        }
        if (string.equals("bit")) {
            return "X";
        }
        if (string.equals("unsignedByte")) {
            return "B";
        }
        if (string.equals("floatComplex")) {
            return "C";
        }
        if (string.equals("doubleComplex")) {
            return "M";
        }
        if (string.equals("unicodeChar")) {
            return "U";
        }
        return "A";
    }

    public String toString() {
        return (this.ID == null ? "" : " ID=" + this.ID) + (this.name == null ? "" : " name=" + this.name) + (this.unit == null ? "" : " unit=" + this.unit) + (this.ucd == null ? "" : " ucd=" + this.ucd) + (this.utype == null ? "" : " utype=" + this.utype) + (this.datatype == null ? "" : " datatype=" + this.datatype) + (this.precision == null ? "" : " precision=" + this.precision) + (this.type == null ? "" : " type=" + this.type) + " coo=" + this.getCooSignature() + (this.arraysize == null ? "" : " arraysize=" + this.arraysize) + (this.nullValue == null ? "" : " nullValue=" + this.nullValue);
    }
}

