/*
 * Decompiled with CFR 0.152.
 */
package cds.xml;

import cds.aladin.Aladin;
import cds.aladin.MyInputStream;
import cds.aladin.Save;
import cds.astro.Astrocoo;
import cds.astro.Astroframe;
import cds.astro.Astropos;
import cds.astro.Astrotime;
import cds.astro.Ecliptic;
import cds.astro.FK4;
import cds.astro.FK5;
import cds.astro.Galactic;
import cds.astro.ICRS;
import cds.astro.Supergal;
import cds.astro.Unit;
import cds.fits.HeaderFits;
import cds.tools.Util;
import cds.xml.Field;
import cds.xml.TableParserConsumer;
import cds.xml.XMLConsumer;
import cds.xml.XMLParser;
import java.io.EOFException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public final class TableParser
implements XMLConsumer {
    static final Astroframe AF_FK4 = new FK4();
    static final Astroframe AF_FK5 = new FK5();
    static final Astroframe AF_GAL = new Galactic();
    static final Astroframe AF_SGAL = new Supergal();
    static final Astroframe AF_ICRS = new ICRS();
    static final Astroframe AF_ECLI = new Ecliptic();
    public static final int FMT_UNKNOWN = 0;
    public static final int FMT_DECIMAL = 1;
    public static final int FMT_SEXAGESIMAL = 2;
    private TableParserConsumer consumer;
    private XMLParser xmlparser;
    private int nField;
    private int nRecord;
    private int nRA;
    private int nDEC;
    private int nPMRA;
    private int nPMDEC;
    private int nX;
    private int nY;
    private String sFreq;
    private String sFlux;
    private String sFluxErr;
    private String sSedId;
    private int nFreq;
    private int nFlux;
    private int nFluxErr;
    private int nSedId;
    private int qualRA;
    private int qualDEC;
    private int qualPMRA;
    private int qualPMDEC;
    private int qualX;
    private int qualY;
    private Field f;
    private Vector<Field> memoField;
    private Field[] tsvField;
    private String fieldSub = null;
    private String tableSub = null;
    private String resourceSub = null;
    private boolean inCSV = false;
    private boolean flagTSV;
    private boolean inError;
    private boolean inLinkField = false;
    private boolean inFieldDesc = false;
    private boolean inEncode64 = false;
    private boolean inBinary = false;
    private boolean inBinary2 = false;
    private boolean inFits = false;
    private boolean inGroup = false;
    private int fitsExtNum;
    private boolean inTD;
    private boolean valueInTD;
    private int ngroup;
    private String colsep;
    private String recsep;
    private String headlines;
    private String error;
    private String filename;
    private int format;
    private boolean flagXY;
    private String[] record;
    private Vector<String> vRecord;
    private int row;
    private boolean flagNewTable;
    private boolean flagSkip;
    private long typeFmt;
    private Hashtable<String, String> coosys;
    private Hashtable<String, String> cooepoch;
    private Hashtable<String, String> cooequinox;
    private Hashtable<String, String> cooFieldref;
    private boolean inAstroCoords;
    private String astroCoordsID;
    private Astroframe srcAstroFrame = null;
    private Astroframe trgAstroFrame = AF_ICRS;
    private Astropos c = new Astropos();
    private String filter;
    private boolean inSEDGroup;
    private HeaderFits headerFits;
    private Aladin aladin;
    private char[] type = null;
    private int[] pos = null;
    private int[] len = null;
    private int[] prec = null;
    private int sizeRecord = 0;
    private int nbField = 0;
    private byte[] memoB = null;
    private byte[] nullMask = null;
    private boolean maskRead = false;
    static final int[] MASK = new int[]{128, 64, 32, 16, 8, 4, 2, 1};
    static final char BLC = ' ';
    static final char TABC = '\t';
    static final byte BLB = 32;
    static final byte TABB = 9;
    private static int ASTROID = 1;
    private boolean flagPosChooser = false;
    private static final String DEFAULT = "Default";
    private Astroframe lastCoordSys = null;

    public TableParser(Aladin aladin, TableParserConsumer tableParserConsumer, long l) {
        this.aladin = aladin;
        this.consumer = tableParserConsumer;
        this.typeFmt = l;
    }

    public TableParser(Aladin aladin, TableParserConsumer tableParserConsumer, HeaderFits headerFits, boolean bl) {
        this.aladin = aladin;
        this.consumer = tableParserConsumer;
        this.headerFits = headerFits;
        this.flagSkip = bl;
    }

    public void setFileName(String string) {
        this.filename = string;
    }

    private void hrefCall(String string) throws Exception {
        MyInputStream myInputStream = this.aladin.glu.getMyInputStream(string, false);
        if (this.inBinary || this.inBinary2) {
            this.consumer.tableParserInfo("\nParsing VOTable data from an external" + (this.inBinary2 ? " BINARY2" : " BINARY") + " stream:\n => " + string);
            byte[] byArray = myInputStream.readFully();
            this.parseBin(byArray, 0, byArray.length, this.inBinary2);
        } else if (this.inFits) {
            this.aladin.calque.seekFitsExt(myInputStream, this.fitsExtNum);
            this.consumer.tableParserInfo("\nParsing VOTable data from a FITS stream:\n => " + string + (this.fitsExtNum > 0 ? " (ext=" + this.fitsExtNum + ")" : ""));
            myInputStream.resetType();
            myInputStream.getType();
            this.headerFits = new HeaderFits(myInputStream);
            this.parseFits(myInputStream, true);
        }
        myInputStream.close();
    }

    private void parseBase64(char[] cArray, int n, int n2, boolean bl) throws Exception {
        if (this.memoField != null) {
            this.consumer.tableParserInfo("\nParsing VOTable data from a" + (bl ? " BINARY2" : " BINARY") + " base64 stream");
        }
        byte[] byArray = new byte[n2];
        int n3 = 0;
        if (this.memoB != null) {
            byArray = new byte[n2 + this.memoB.length];
            n3 = this.memoB.length;
            System.arraycopy(this.memoB, 0, byArray, 0, n3);
            this.memoB = null;
        } else {
            byArray = new byte[n2];
        }
        int n4 = Save.get64(byArray, n3, cArray, n, n2);
        this.parseBin(byArray, 0, n4, bl);
    }

    private boolean parseBin(byte[] byArray, int n, int n2, boolean bl) throws Exception {
        int n3;
        int n4;
        if (this.memoField != null) {
            this.nbField = this.memoField.size();
            this.type = new char[this.nbField];
            this.pos = new int[this.nbField];
            this.len = new int[this.nbField];
            this.prec = new int[this.nbField];
            if (bl) {
                this.nullMask = new byte[(this.nbField + 7) / 8];
            }
            this.nRecord = 0;
            this.nField = 0;
            n4 = 0;
            for (n3 = 0; n3 < this.nbField; ++n3) {
                Field field = this.memoField.elementAt(n3);
                String string = Field.typeVOTable2Fits(field.datatype);
                if (string == null) {
                    throw new Exception("Missing definition for field " + n3 + ". Parsing aborted");
                }
                this.type[n3] = string.charAt(0);
                this.len[n3] = 1;
                if (field.arraysize != null && field.arraysize.equals("*")) {
                    this.len[n3] = -1;
                    this.sizeRecord = -1;
                    n4 = 1;
                } else {
                    try {
                        this.len[n3] = Integer.parseInt(field.arraysize);
                    }
                    catch (Exception exception) {
                        this.len[n3] = 1;
                    }
                }
                if (n4 == 0) {
                    if (n3 < this.nbField - 1) {
                        this.pos[n3 + 1] = this.pos[n3] + this.binSizeOf(this.type[n3], this.len[n3]);
                    } else {
                        this.sizeRecord = this.pos[n3] + this.binSizeOf(this.type[n3], this.len[n3]);
                    }
                } else {
                    this.pos[n3] = -1;
                }
                this.prec[n3] = 6;
                try {
                    this.prec[n3] = Integer.parseInt(field.precision);
                    continue;
                }
                catch (Exception exception) {
                    this.prec[n3] = 6;
                }
            }
            this.pos[0] = 0;
            this.memoField = null;
        }
        n4 = n;
        while (n4 < n2) {
            int n5;
            if (this.nField == this.nbField) {
                this.nField = 0;
            }
            if (bl && this.nField == 0 && !this.maskRead) {
                n3 = n2 - n4;
                if (n3 < this.nullMask.length) {
                    this.memoB = new byte[n3];
                    System.arraycopy(byArray, n4, this.memoB, 0, n3);
                    return true;
                }
                n4 += this.nullMask.length;
                this.maskRead = true;
            } else {
                this.maskRead = false;
            }
            int n6 = n3 = this.len[this.nField] == -1 ? -1 : this.binSizeOf(this.type[this.nField], this.len[this.nField]);
            if (n3 == -1) {
                n5 = n2 - n4;
                if (n5 < 4) {
                    this.memoB = new byte[n5];
                    System.arraycopy(byArray, n4, this.memoB, 0, n5);
                    return true;
                }
                n3 = this.getInt(byArray, n4);
                n4 += 4;
            } else if (n3 == 0) {
                return true;
            }
            n5 = n4 + n3;
            if (n5 > n2) {
                if (this.len[this.nField] == -1) {
                    n4 -= 4;
                }
                int n7 = n2 - n4;
                this.memoB = new byte[n7];
                System.arraycopy(byArray, n4, this.memoB, 0, n7);
                return true;
            }
            this.record[this.nField] = bl && this.isNull(this.nullMask, this.nField) ? "null" : this.getBinField(byArray, n4, this.len[this.nField] == -1 ? n3 : this.len[this.nField], this.type[this.nField], this.prec[this.nField], 0.0, 1.0, false, 0);
            n4 = n5;
            ++this.nField;
            if (this.nField != this.nbField) continue;
            this.consumeRecord(this.record, this.nRecord++);
        }
        return true;
    }

    private boolean isNull(byte[] byArray, int n) {
        int n2 = n / 8;
        int n3 = n % 8;
        return (0xFF & byArray[n2] & MASK[n3]) != 0;
    }

    private boolean parseFits(MyInputStream myInputStream, boolean bl) {
        block73: {
            this.error = null;
            if (!bl) {
                this.initTable();
                this.coosys = new Hashtable(10);
                this.cooepoch = new Hashtable(10);
                this.cooequinox = new Hashtable(10);
                this.cooFieldref = new Hashtable(10);
            }
            try {
                int n;
                int n2;
                String string;
                boolean bl2;
                boolean bl3 = bl2 = (myInputStream.getType() & 0x1000000L) != 0L;
                if (!bl) {
                    this.consumer.tableParserInfo("FITS " + (bl2 ? "BINTABLE" : "TABLE") + " format");
                    this.consumer.startResource("RESOURCE-FITS");
                    try {
                        string = this.headerFits.getStringFromHeader("EXTNAME");
                        this.consumer.setResourceInfo("NAME", string);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.consumer.startTable("TABLE-FITS");
                int n3 = this.headerFits.getIntFromHeader("NAXIS2");
                int n4 = this.headerFits.getIntFromHeader("NAXIS1");
                this.nField = this.headerFits.getIntFromHeader("TFIELDS");
                char[] cArray = null;
                int[] nArray = new int[this.nField];
                int[] nArray2 = new int[this.nField];
                boolean bl4 = false;
                double[] dArray = new double[this.nField];
                double[] dArray2 = new double[this.nField];
                String[] stringArray = new String[this.nField];
                int[] nArray3 = new int[this.nField];
                int[] nArray4 = new int[this.nField];
                for (n2 = 0; n2 < this.nField; ++n2) {
                    nArray4[n2] = -1;
                }
                for (n2 = 0; n2 < this.nField; ++n2) {
                    dArray2[n2] = 1.0;
                }
                if (bl2) {
                    cArray = new char[this.nField];
                }
                for (n2 = 0; n2 < this.nField; ++n2) {
                    string = null;
                    try {
                        string = this.headerFits.getStringFromHeader("TTYPE" + (n2 + 1));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (string == null) {
                        string = "Col-" + (n2 + 1);
                    }
                    Field field = new Field(string);
                    string = null;
                    try {
                        string = this.headerFits.getStringFromHeader("TUNIT" + (n2 + 1));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (string != null) {
                        field.unit = string;
                    }
                    string = null;
                    try {
                        string = this.headerFits.getStringFromHeader("TCOMM" + (n2 + 1));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (string != null) {
                        field.description = string;
                    }
                    double d = 0.0;
                    try {
                        d = this.headerFits.getDoubleFromHeader("TZERO" + (n2 + 1));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (d != 0.0) {
                        dArray[n2] = d;
                        bl4 = true;
                    }
                    d = 0.0;
                    try {
                        d = this.headerFits.getDoubleFromHeader("TSCAL" + (n2 + 1));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (d != 0.0) {
                        dArray2[n2] = d;
                        bl4 = true;
                    }
                    string = null;
                    try {
                        string = this.headerFits.getStringFromHeader("TNULL" + (n2 + 1));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (string != null) {
                        stringArray[n2] = string.trim();
                        if (bl2) {
                            try {
                                nArray3[n2] = this.headerFits.getIntFromHeader("TNULL" + (n2 + 1));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    string = null;
                    try {
                        string = this.headerFits.getStringFromHeader("TUCD" + (n2 + 1));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (string != null) {
                        field.ucd = string;
                    }
                    string = null;
                    try {
                        string = this.headerFits.getStringFromHeader("TFORM" + (n2 + 1));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (string != null) {
                        if (!bl2) {
                            char c = string.charAt(0);
                            if (c == 'E' || c == 'F') {
                                c = 'D';
                            }
                            field.datatype = c + "";
                            int n5 = string.indexOf(46);
                            if (n5 < 0) {
                                n5 = string.length();
                            }
                            if (n5 > 1) {
                                field.width = string.substring(1, n5);
                                field.computeColumnSize();
                            }
                            if ((n5 = string.indexOf(46)) > 0) {
                                nArray4[n2] = 0;
                                ++n5;
                                while (n5 < string.length() && Character.isDigit(string.charAt(n5))) {
                                    nArray4[n2] = nArray4[n2] * 10 + (string.charAt(n5) - 48);
                                    ++n5;
                                }
                            }
                        } else {
                            int n6;
                            nArray2[n2] = 0;
                            for (n6 = 0; n6 < string.length() && Character.isDigit(string.charAt(n6)); ++n6) {
                                nArray2[n2] = nArray2[n2] * 10 + (string.charAt(n6) - 48);
                            }
                            if (n6 == 0) {
                                nArray2[n2] = 1;
                            } else {
                                field.arraysize = nArray2[n2] + "";
                            }
                            cArray[n2] = string.charAt(n6);
                            int n7 = nArray[n2] = n2 == 0 ? 0 : nArray[n2 - 1] + this.binSizeOf(cArray[n2 - 1], nArray2[n2 - 1]);
                        }
                    }
                    if (bl2 && field.datatype == null) {
                        field.datatype = cArray[n2] + "";
                    }
                    string = null;
                    try {
                        string = this.headerFits.getStringFromHeader("TDISP" + (n2 + 1));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (string != null) {
                        int n8 = string.indexOf(46);
                        if (n8 < 0) {
                            n8 = string.length();
                        }
                        if (n8 > 1) {
                            field.width = string.substring(1, n8);
                            field.computeColumnSize();
                        }
                        if ((n8 = string.indexOf(46)) > 0) {
                            nArray4[n2] = 0;
                            ++n8;
                            while (n8 < string.length() && Character.isDigit(string.charAt(n8))) {
                                nArray4[n2] = nArray4[n2] * 10 + (string.charAt(n8) - 48);
                                ++n8;
                            }
                        }
                    }
                    if (!bl2) {
                        nArray[n2] = this.headerFits.getIntFromHeader("TBCOL" + (n2 + 1));
                        int n9 = n4;
                        try {
                            n9 = this.headerFits.getIntFromHeader("TBCOL" + (n2 + 2));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        nArray2[n2] = n9 - nArray[n2];
                        int n10 = n2;
                        nArray[n10] = nArray[n10] - 1;
                        field.width = nArray2[n2] + "";
                    }
                    this.detectPosField(field, n2);
                    if (bl) continue;
                    this.consumer.setField(field);
                }
                if (!bl) {
                    this.posChooser();
                }
                if (this.flagSkip) {
                    myInputStream.skip(n3 * n4);
                } else {
                    byte[] byArray = new byte[(n3 < 1000 ? n3 : 1000) * n4];
                    this.record = new String[this.nField];
                    n = byArray.length;
                    int n11 = 0;
                    while (n11 < n3) {
                        if (n == byArray.length) {
                            try {
                                myInputStream.readFully(byArray);
                            }
                            catch (EOFException eOFException) {
                                // empty catch block
                            }
                            n = 0;
                        }
                        for (int i = 0; i < this.nField; ++i) {
                            if (!bl2) {
                                this.record[i] = TableParser.getStringTrim(byArray, n + nArray[i], nArray2[i]);
                                if (stringArray[i] != null && this.record[i].equals(stringArray[i])) {
                                    this.record[i] = "";
                                    continue;
                                }
                                if (!bl4 && nArray4[i] < 0) continue;
                                try {
                                    this.record[i] = this.fmt(Double.valueOf(this.record[i]), nArray4[i], dArray[i], dArray2[i]);
                                }
                                catch (Exception exception) {
                                    this.record[i] = "[?X?]";
                                }
                                continue;
                            }
                            this.record[i] = this.getBinField(byArray, n + nArray[i], nArray2[i], cArray[i], nArray4[i], bl4 ? dArray[i] : 0.0, bl4 ? dArray2[i] : 1.0, stringArray[i] != null, nArray3[i]);
                        }
                        this.consumeRecord(this.record, n11);
                        ++n11;
                        n += n4;
                    }
                }
                if (bl) break block73;
                this.consumer.endTable();
                this.consumer.endResource();
                try {
                    n = this.headerFits.getIntFromHeader("PCOUNT");
                    if (n != 0) {
                        myInputStream.skip(n);
                    }
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.error = exception.getMessage();
            }
        }
        return this.error == null;
    }

    protected final int binSizeOf(char c, int n) {
        int n2;
        if (c == 'X') {
            return n / 8 + (n % 8 > 0 ? 1 : 0);
        }
        int n3 = c == 'L' ? 1 : (c == 'B' ? 1 : (c == 'I' ? 2 : (c == 'J' ? 4 : (c == 'K' ? 8 : (c == 'A' ? 1 : (c == 'E' ? 4 : (c == 'D' ? 8 : (c == 'C' ? 8 : (c == 'M' ? 16 : (n2 = c == 'P' ? 8 : 0))))))))));
        if (n2 == 0) {
            System.out.println("Probl\u00e8me s\u00e9rieux pour [" + c + "]");
        }
        return n2 * n;
    }

    private final String getBinField(byte[] byArray, int n, int n2, char c, int n3, double d, double d2, boolean bl, int n4) {
        if (n2 == 0) {
            return "";
        }
        if (c == 'A') {
            return TableParser.getStringTrim(byArray, n, n2);
        }
        if (n2 == 1) {
            return this.getBinField(byArray, n, c, n3, d, d2, bl, n4);
        }
        StringBuffer stringBuffer = null;
        for (int i = 0; i < n2; ++i) {
            if (i == 0) {
                stringBuffer = new StringBuffer();
            } else {
                stringBuffer.append(' ');
            }
            stringBuffer.append(this.getBinField(byArray, n + this.binSizeOf(c, i), c, n3, d, d2, bl, n4));
        }
        return stringBuffer + "";
    }

    private final String getBinField(byte[] byArray, int n, char c, int n2, double d, double d2, boolean bl, int n3) {
        String string = this.getBinField1(byArray, n, c, n2, d, d2, bl, n3);
        return string;
    }

    private final String getBinField1(byte[] byArray, int n, char c, int n2, double d, double d2, boolean bl, int n3) {
        switch (c) {
            case 'L': {
                return byArray[n] != 0 ? "T" : "F";
            }
            case 'B': {
                return this.fmtInt(byArray[n] & 0xFF, n2, d, d2, bl, n3);
            }
            case 'I': {
                return this.fmtInt(this.getShort(byArray, n), n2, d, d2, bl, n3);
            }
            case 'J': {
                return this.fmtInt(this.getInt(byArray, n), n2, d, d2, bl, n3);
            }
            case 'K': {
                long l = (long)this.getInt(byArray, n) << 32 | (long)this.getInt(byArray, n + 4) & 0xFFFFFFFFL;
                return this.fmtLong(l, n2, d, d2, bl, n3);
            }
            case 'E': {
                return this.fmt(Float.intBitsToFloat(this.getInt(byArray, n)), n2, d, d2);
            }
            case 'D': {
                long l = (long)this.getInt(byArray, n) << 32 | (long)this.getInt(byArray, n + 4) & 0xFFFFFFFFL;
                return this.fmt(Double.longBitsToDouble(l), n2, d, d2);
            }
            case 'C': {
                int n4 = this.getInt(byArray, n + 4);
                return this.fmt(Float.intBitsToFloat(this.getInt(byArray, n)), n2, d, d2) + (n4 >= 0 ? "+" : "-") + this.fmt(Float.intBitsToFloat(n4), n2, d, d2) + "i";
            }
            case 'M': {
                long l = (long)this.getInt(byArray, n) << 32 | (long)this.getInt(byArray, n + 4) & 0xFFFFFFFFL;
                long l2 = (long)this.getInt(byArray, n + 8) << 32 | (long)this.getInt(byArray, n + 12) & 0xFFFFFFFFL;
                return this.fmt(Double.longBitsToDouble(l), n2, d, d2) + (l2 >= 0L ? "+" : "-") + this.fmt(Double.longBitsToDouble(l2), n2, d, d2) + "i";
            }
            case 'A': {
                return "" + (char)byArray[n];
            }
        }
        return "[???]";
    }

    private final String fmtInt(long l, int n, double d, double d2, boolean bl, int n2) {
        if (bl && (long)n2 == l) {
            return "";
        }
        double d3 = l;
        if (d2 != 1.0) {
            d3 *= d2;
        }
        if (d != 0.0) {
            d3 += d;
        }
        if (n >= 0) {
            d3 = Util.round(d3, n);
        }
        if (d3 != (double)l) {
            return d3 + "";
        }
        return l + "";
    }

    private final String fmtLong(long l, int n, double d, double d2, boolean bl, int n2) {
        if (bl && (long)n2 == l) {
            return "";
        }
        if (d2 == 1.0 && d == 0.0) {
            return l + "";
        }
        if ((double)((long)d2) == d2 && (double)((long)d) == d) {
            long l2 = l;
            if (d2 != 1.0) {
                l2 *= (long)d2;
            }
            if (d != 0.0) {
                l2 += (long)d;
            }
            return l2 + "";
        }
        double d3 = l;
        if (d2 != 1.0) {
            d3 *= d2;
        }
        if (d != 0.0) {
            d3 += d;
        }
        if (n >= 0) {
            d3 = Util.round(d3, n);
        }
        if (d3 != (double)l) {
            return d3 + "";
        }
        return l + "";
    }

    private final String fmt(double d, int n, double d2, double d3) {
        if (Double.isNaN(d)) {
            return "";
        }
        if (d3 != 1.0) {
            d *= d3;
        }
        if (d2 != 0.0) {
            d += d2;
        }
        if (n >= 0) {
            d = Util.round(d, n);
        }
        return d + "";
    }

    private final int getInt(byte[] byArray, int n) {
        return byArray[n] << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
    }

    private final int getShort(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF;
    }

    public static final String getStringTrim(byte[] byArray, int n, int n2) {
        if (n2 < 0 || n + n2 > byArray.length) {
            System.err.println("problem s.length=" + byArray.length + " offset=" + n + " len=" + n2 + " !!");
            return new String(byArray, n, byArray.length - n);
        }
        return new String(byArray, n, n2).trim();
    }

    public static final String getStringTrim(char[] cArray, int n, int n2) {
        return new String(cArray, n, n2).trim();
    }

    public TableParser(Aladin aladin, TableParserConsumer tableParserConsumer) {
        this(aladin, tableParserConsumer, null);
    }

    public TableParser(Aladin aladin, TableParserConsumer tableParserConsumer, String string) {
        this.aladin = aladin;
        this.consumer = tableParserConsumer;
        if (string != null) {
            this.colsep = string;
        }
        this.xmlparser = new XMLParser(this);
    }

    public boolean parse(MyInputStream myInputStream) throws Exception {
        if (this.headerFits != null) {
            return this.parseFits(myInputStream, false);
        }
        return this.parse(myInputStream, null);
    }

    public boolean parse(MyInputStream myInputStream, String string) throws Exception {
        this.initTable();
        this.error = null;
        this.flagTSV = true;
        this.inError = false;
        this.ngroup = 0;
        this.coosys = new Hashtable(10);
        this.cooepoch = new Hashtable(10);
        this.cooequinox = new Hashtable(10);
        this.cooFieldref = new Hashtable(10);
        return this.xmlparser.parse(myInputStream, string) && this.error == null;
    }

    public byte[] getUnreadBuffer() {
        return this.xmlparser.getUnreadBuffer();
    }

    private void initTable() {
        this.nY = -1;
        this.nX = -1;
        this.nPMDEC = -1;
        this.nPMRA = -1;
        this.nDEC = -1;
        this.nRA = -1;
        this.qualY = 1000;
        this.qualX = 1000;
        this.qualDEC = 1000;
        this.qualRA = 1000;
        this.qualDEC = 1000;
        this.qualRA = 1000;
        this.format = 0;
        this.nField = 0;
        this.record = null;
        this.vRecord = null;
        this.flagNewTable = true;
        this.astroCoordsID = null;
        this.inAstroCoords = false;
        this.inSEDGroup = false;
    }

    public String getError() {
        return this.error != null ? this.error : this.xmlparser.getError();
    }

    private void memoStartGroup(String string, Hashtable hashtable) {
        StringBuffer stringBuffer = new StringBuffer("<" + string);
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            stringBuffer.append(" " + string2 + "=\"" + hashtable.get(string2) + "\"");
        }
        stringBuffer.append(">\n");
        this.consumer.setTableInfo("GROUP", stringBuffer.toString());
    }

    private void memoEndGroup(String string) {
        this.consumer.setTableInfo("GROUP", "</" + string + ">\n");
    }

    private void memoInGroup(char[] cArray, int n, int n2) {
        this.consumer.setTableInfo("GROUP", new String(cArray, n, n2));
    }

    private void resetGroup() {
        System.err.println("TableParser.resetGroupe => FIELD GROUP not yet supported => remove all GROUP definition !");
        this.consumer.setTableInfo("GROUP", null);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void startElement(String var1_1, Hashtable var2_2) {
        var6_3 = this.xmlparser.getDepth();
        if (this.inGroup) {
            this.memoStartGroup(var1_1, var2_2);
        }
        if (var1_1.charAt(0) == 'G' && var6_3 >= 1 && var1_1.equalsIgnoreCase("GROUP")) {
            ++this.ngroup;
            if (!this.inGroup) {
                this.memoStartGroup(var1_1, var2_2);
            }
            this.inGroup = true;
            var3_4 = (String)var2_2.get("utype");
            var4_6 = (String)var2_2.get("ID");
            if (var3_4 != null && (var3_4.equalsIgnoreCase("stc:AstroCoords") || var3_4.equalsIgnoreCase("stc:AstroCoordSystem") || var3_4.equalsIgnoreCase("stc:CatalogEntryLocation"))) {
                this.inAstroCoords = true;
                this.astroCoordsID = (String)var2_2.get("ID");
                var5_8 = (String)var2_2.get("ref");
                if (var5_8 != null && this.astroCoordsID != null) {
                    this.coosys.put(this.astroCoordsID, var5_8);
                }
            } else if (var3_4 != null && var3_4.equalsIgnoreCase("spec:PhotometryPoint") || var4_6 != null && var4_6.equals("gsed")) {
                this.inSEDGroup = true;
            }
            return;
        }
        var6_3 -= this.ngroup;
        if (this.inSEDGroup && var1_1.equalsIgnoreCase("FIELDref") && (var3_5 = (String)var2_2.get("utype")) != null) {
            if (var3_5.equalsIgnoreCase("photdm:PhotometryFilter.SpectralAxis.Coverage.Location.Value")) {
                this.sFreq = (String)var2_2.get("ref");
            } else if (var3_5.equalsIgnoreCase("spec:PhotometryPoint")) {
                this.sFlux = (String)var2_2.get("ref");
            } else if (var3_5.equalsIgnoreCase("spec:PhotoMetryPointError")) {
                this.sFluxErr = (String)var2_2.get("ref");
            } else if (var3_5.equalsIgnoreCase("photdm:PhotometryFilter.identifier")) {
                this.sSedId = (String)var2_2.get("ref");
            }
        }
        if (this.inAstroCoords) {
            if (this.astroCoordsID == null) {
                this.astroCoordsID = "_DEFAULTID_" + TableParser.ASTROID++;
            }
            if (var1_1.equalsIgnoreCase("PARAM")) {
                var3_5 = (String)var2_2.get("utype");
                if (var3_5 != null && (var3_5.equalsIgnoreCase("stc:AstroCoords.coord_sys_id") || var3_5.equalsIgnoreCase("stc:AstroCoords.coord_system_id") || var3_5.equalsIgnoreCase("stc:AstroCoordSystem.href") || var3_5.equalsIgnoreCase("stc:AstroCoordSystem.SpaceFrame.CoordRefFrame"))) {
                    var5_9 = (String)var2_2.get("value");
                    if (var5_9 != null) {
                        this.coosys.put(this.astroCoordsID, var5_9);
                    }
                } else if (var3_5 != null && (Util.matchMaskIgnoreCase("stc:Astrocoords.Position?D.Epoch", var3_5) || var3_5.equalsIgnoreCase("stc:AstroCoords.SpaceFrame.Epoch"))) {
                    var5_10 = (String)var2_2.get("value");
                    if (var5_10 != null) {
                        if (!Character.isDigit(var5_10.charAt(0)) && (var7_15 = this.cooepoch.get(this.astroCoordsID)) != null && var7_15.length() == 1) {
                            var5_10 = var7_15 + var5_10;
                        }
                        this.cooepoch.put(this.astroCoordsID, var5_10);
                    }
                } else if (var3_5 != null && Util.matchMaskIgnoreCase("stc:Astrocoords.Position?D.Epoch.yearDef", var3_5)) {
                    var5_11 = (String)var2_2.get("value");
                    if (var5_11 != null) {
                        var7_15 = this.cooepoch.get(this.astroCoordsID);
                        if (var7_15 != null && Character.isDigit(var7_15.charAt(0))) {
                            var5_11 = var5_11 + var7_15;
                        }
                        this.cooepoch.put(this.astroCoordsID, var5_11);
                    }
                } else if (var3_5 != null && var3_5.equalsIgnoreCase("stc:AstroCoordSystem.SpaceFrame.CoordRefFrame.Equinox")) {
                    var5_12 = (String)var2_2.get("value");
                    if (var5_12 != null) {
                        if (!Character.isDigit(var5_12.charAt(0)) && (var7_15 = this.cooequinox.get(this.astroCoordsID)) != null && var7_15.length() == 1) {
                            var5_12 = var7_15 + var5_12;
                        }
                        this.cooequinox.put(this.astroCoordsID, var5_12);
                    }
                } else if (var3_5 != null && var3_5.equalsIgnoreCase("stc:AstroCoordSystem.SpaceFrame.CoordRefFrame.Equinox.yearDef")) {
                    var5_13 = (String)var2_2.get("value");
                    if (var5_13 != null) {
                        var7_15 = this.cooequinox.get(this.astroCoordsID);
                        if (var7_15 != null && Character.isDigit(var7_15.charAt(0))) {
                            var5_13 = var5_13 + var7_15;
                        }
                        this.cooequinox.put(this.astroCoordsID, var5_13);
                    }
                } else if (var3_5 != null) {
                    this.consumer.tableParserInfo("      *** AstroCoord PARAM utype unknown => ignored: [" + var3_5 + "]");
                }
            } else if (var1_1.equalsIgnoreCase("FIELDref")) {
                var3_5 = (String)var2_2.get("utype");
                if (var3_5 != null && Util.matchMaskIgnoreCase("stc:Astrocoords.Position?D.Value*", var3_5)) {
                    var5_14 = (String)var2_2.get("ref");
                    if (var5_14 != null) {
                        this.cooFieldref.put(var5_14, this.astroCoordsID);
                    }
                } else if (var3_5 != null) {
                    this.consumer.tableParserInfo("      *** AstroCoord FIELDref utype unknown => ignored: [" + var3_5 + "]");
                }
            }
        }
        if (var6_3 < 4) {
            if (var1_1.equals("INFO")) {
                var3_5 = (String)var2_2.get("name");
                if (var3_5 != null && var3_5.equals("AladinFilter")) {
                    this.filter = "";
                    var3_5 = (String)var2_2.get("value");
                    if (var3_5 != null) {
                        this.filter = "#" + var3_5 + "\n";
                    }
                    if ((var3_5 = (String)var2_2.get("ID")) != null) {
                        this.filter = this.filter + "filter " + var3_5 + " {\n";
                    }
                } else if (var3_5 != null && var3_5.equals("QUERY_STATUS")) {
                    var3_5 = (String)var2_2.get("value");
                    if (var3_5.equals("OVERFLOW")) {
                        this.consumer.tableParserWarning("!!! Truncated result (server OVERFLOW)");
                    } else if (var3_5.equals("ERROR")) {
                        this.consumer.tableParserWarning("!!! Result error (server ERROR)");
                    }
                }
            } else if (var1_1.equalsIgnoreCase("COOSYS") && (var4_7 = (String)var2_2.get("ID")) != null) {
                var3_5 = (String)var2_2.get("system");
                if (var3_5 != null) {
                    this.coosys.put(var4_7, var3_5);
                }
                if ((var3_5 = (String)var2_2.get("epoch")) != null) {
                    this.cooepoch.put(var4_7, var3_5);
                }
                if ((var3_5 = (String)var2_2.get("equinox")) != null) {
                    this.cooequinox.put(var4_7, var3_5);
                }
            }
        }
        switch (var6_3) {
            case 6: {
                if (var1_1.equalsIgnoreCase("TR")) {
                    this.row = 0;
                    break;
                }
                if (!var1_1.equalsIgnoreCase("STREAM")) break;
                var3_5 = (String)var2_2.get("encoding");
                if (var3_5 != null && var3_5.equalsIgnoreCase("base64")) {
                    this.inEncode64 = true;
                    break;
                }
                var3_5 = (String)var2_2.get("href");
                try {
                    this.hrefCall(var3_5);
                    break;
                }
                catch (Exception var7_16) {
                    this.inError = true;
                    this.error = "VOTable external reference error [" + var3_5 + "]";
                    if (Aladin.levelTrace >= 3) {
                        var7_16.printStackTrace();
                    }
                    return;
                }
            }
            case 7: {
                if (!var1_1.equalsIgnoreCase("TD")) break;
                this.inTD = true;
                break;
            }
            case 1: {
                if (!var1_1.equalsIgnoreCase("ASTRO")) ** GOTO lbl152
                this.consumer.tableParserInfo("Astrores format");
                this.flagTSV = false;
                ** GOTO lbl155
lbl152:
                // 1 sources

                if (var1_1.equalsIgnoreCase("VOTABLE")) {
                    this.consumer.tableParserInfo("VOTable format");
                    this.flagTSV = false;
                }
            }
lbl155:
            // 5 sources

            case 2: {
                if (var1_1.equalsIgnoreCase("INFO")) {
                    var3_5 = (String)var2_2.get("name");
                    if (var3_5 != null && (var3_5.equalsIgnoreCase("ERRORS") || var3_5.equalsIgnoreCase("ERROR"))) {
                        var3_5 = (String)var2_2.get("value");
                        this.error = var3_5 == null ? "Unknown VOTable error" : var3_5;
                        return;
                    }
                    var3_5 = (String)var2_2.get("ID");
                    if (var3_5 == null || !var3_5.equals("Target") || (var3_5 = (String)var2_2.get("value")) == null) break;
                    this.consumer.setTarget(var3_5);
                    break;
                }
                if (!var1_1.equalsIgnoreCase("RESOURCE")) break;
                var3_5 = (String)var2_2.get("ID");
                if (var3_5 != null) {
                    this.consumer.startResource(var3_5);
                    break;
                }
                this.consumer.startResource((String)var2_2.get("name"));
                break;
            }
            case 3: {
                if (var1_1.equalsIgnoreCase("INFO")) {
                    var3_5 = (String)var2_2.get("name");
                    if (var3_5 == null || !var3_5.equals("QUERY_STATUS") || (var3_5 = (String)var2_2.get("value")) == null || !var3_5.equalsIgnoreCase("ERROR")) break;
                    this.error = "je me suis plant\u00e9";
                    this.inError = true;
                    return;
                }
                if (!var1_1.equalsIgnoreCase("TABLE")) break;
                this.initTable();
                var3_5 = (String)var2_2.get("name");
                if (var3_5 != null) {
                    this.consumer.startTable(var3_5);
                } else {
                    var3_5 = (String)var2_2.get("ID");
                    this.consumer.startTable(var3_5);
                }
                this.consumer.tableParserInfo(".Table " + var3_5);
                var3_5 = (String)var2_2.get("name");
                if (var3_5 == null) break;
                this.consumer.setTableInfo("name", var3_5);
                break;
            }
            case 4: {
                if (var1_1.equalsIgnoreCase("FIELD")) {
                    if (this.inGroup) {
                        this.resetGroup();
                        this.inGroup = false;
                    }
                    this.f = new Field(var2_2);
                    break;
                }
                if (var1_1.equalsIgnoreCase("PARAM")) {
                    this.f = new Field(var2_2);
                    break;
                }
                if (!var1_1.equalsIgnoreCase("DATA")) break;
                this.record = new String[this.nField];
                this.posChooser();
                break;
            }
            case 5: {
                if (var1_1.equalsIgnoreCase("LINK")) {
                    this.f.addInfo("href", (String)var2_2.get("href"));
                    this.f.addInfo("gref", (String)var2_2.get("gref"));
                    this.f.addInfo("refValue", (String)var2_2.get("content-type"));
                    this.f.addInfo("refText", (String)var2_2.get("title"));
                    this.inLinkField = true;
                    break;
                }
                if (var1_1.equalsIgnoreCase("VALUES")) {
                    this.f.nullValue = (String)var2_2.get("null");
                    break;
                }
                if (var1_1.equalsIgnoreCase("DESCRIPTION")) {
                    this.inFieldDesc = true;
                    break;
                }
                if (var1_1.equalsIgnoreCase("CSV")) {
                    this.inCSV = true;
                    this.colsep = (String)var2_2.get("colsep");
                    this.recsep = (String)var2_2.get("recsep");
                    this.headlines = (String)var2_2.get("headlines");
                    break;
                }
                if (var1_1.equalsIgnoreCase("BINARY")) {
                    this.inBinary = true;
                    break;
                }
                if (var1_1.equalsIgnoreCase("BINARY2")) {
                    this.inBinary2 = true;
                    break;
                }
                if (!var1_1.equalsIgnoreCase("FITS")) break;
                this.inFits = true;
                var3_5 = (String)var2_2.get("extnum");
                this.fitsExtNum = var3_5 != null ? Integer.parseInt(var3_5) : 1;
            }
        }
        if (var6_3 > 4) {
            this.fieldSub = var1_1;
        } else if (var6_3 > 3) {
            this.tableSub = var1_1;
        } else if (var6_3 > 2) {
            this.resourceSub = var1_1;
        }
    }

    private void posChooser() {
        block23: {
            this.flagPosChooser = true;
            this.inAstroCoords = false;
            if (this.inSEDGroup) {
                this.consumer.tableParserInfo("   -SED system found:");
                if (this.sFreq != null) {
                    this.consumer.tableParserInfo("      .frequence col #" + this.nFreq + 1);
                }
                if (this.sFlux != null) {
                    this.consumer.tableParserInfo("      .flux col      #" + this.nFlux + 1);
                }
                if (this.sFluxErr != null) {
                    this.consumer.tableParserInfo("      .fluxError col #" + this.nFluxErr + 1);
                }
                if (this.sSedId != null) {
                    this.consumer.tableParserInfo("      .SEDid col     #" + this.nSedId + 1);
                }
                this.inSEDGroup = false;
            }
            this.srcAstroFrame = null;
            if (this.nRA < 0) {
                this.flagXY = this.nX >= 0 && this.nY >= 0;
                if (!this.flagXY) {
                    this.nRA = 0;
                    this.nDEC = 1;
                } else {
                    this.consumer.setTableInfo("__XYPOS", "true");
                }
            }
            this.consumer.setTableRaDecXYIndex(this.nRA, this.nDEC, this.nPMRA, this.nPMDEC, this.nX, this.nY, !(this.qualRA != 1000 && this.qualDEC != 1000 || this.nX != 1000 && this.nY != 1000));
            if (this.flagXY) {
                this.consumer.tableParserInfo("   -assuming XY positions (column " + (this.nX + 1) + " for X and " + (this.nY + 1) + " for Y)");
            } else if (this.nRA >= 0) {
                this.consumer.tableParserInfo("   -assuming RADEC" + (this.format == 0 ? " " : (this.format == 2 ? " in sexagesimal" : " in degrees")) + " (column " + (this.nRA + 1) + " for RA and " + (this.nDEC + 1) + " for DEC)");
                if (this.nPMRA >= 0) {
                    this.consumer.tableParserInfo("   -Proper motion fields found (column " + (this.nPMRA + 1) + " for PMRA and " + (this.nPMDEC + 1) + " for PMDEC)");
                }
            }
            this.consumer.tableParserInfo("      [RA=" + this.nRA + " (" + this.qualRA + ") DE=" + this.nDEC + " (" + this.qualDEC + ") PMRA=" + this.nPMRA + " (" + this.qualPMRA + ") PMDEC=" + this.nPMDEC + " (" + this.qualPMDEC + ") X=" + this.nX + " (" + this.qualX + ") Y=" + this.nY + " (" + this.qualY + ")]");
            if (this.coosys != null && this.coosys.size() > 0) {
                String string;
                Object object;
                this.consumer.tableParserInfo("   -Coordinate system references found:");
                Enumeration<String> enumeration = this.coosys.keys();
                while (enumeration.hasMoreElements()) {
                    object = enumeration.nextElement();
                    string = this.cooepoch.get(object);
                    String string2 = this.cooequinox.get(object);
                    String string3 = "      ID=\"" + (String)object + "\" => " + this.coosys.get(object) + (string2 == null ? "" : " Eq=" + string2) + (string == null ? "" : " Ep=" + string);
                    this.consumer.tableParserInfo(string3);
                }
                try {
                    object = this.memoField.elementAt(this.nRA);
                    if (((Field)object).ref != null) {
                        this.setSourceAstroFrame(((Field)object).ref, null, null, 0);
                    } else {
                        string = this.cooFieldref.get(((Field)object).ID);
                        if (string != null) {
                            this.setSourceAstroFrame(string, null, null, 0);
                        }
                    }
                }
                catch (Exception exception) {
                    if (this.coosys.size() == 1) {
                        try {
                            this.setSourceAstroFrame(this.coosys.keys().nextElement(), null, null, 0);
                        }
                        catch (Exception exception2) {}
                        break block23;
                    }
                    this.consumer.tableParserInfo("!!! Coordinate system assignation error... assuming ICRS");
                }
            } else {
                this.consumer.tableParserInfo("   -No coordinate system reference found... assuming ICRS");
            }
        }
    }

    private void setSourceAstroFrame(String string, String string2, String string3, int n) throws Exception {
        if (n > 4) {
            throw new Exception();
        }
        String string4 = this.coosys.get(string);
        if (string3 == null) {
            string3 = this.cooepoch.get(string);
        }
        if (string2 == null) {
            string2 = this.cooequinox.get(string);
        }
        if (string4.indexOf("FK4") >= 0) {
            this.srcAstroFrame = string2 == null ? AF_FK4 : new FK4(new Astrotime(string2).getByr());
            if (string3 != null) {
                this.srcAstroFrame.setFrameEpoch(new Astrotime(string3).getByr());
            }
        } else if (string4.indexOf("B1950") >= 0) {
            this.srcAstroFrame = AF_FK4;
        } else if (string4.indexOf("FK5") >= 0) {
            this.srcAstroFrame = string2 == null ? AF_FK5 : new FK5(new Astrotime(string2).getJyr());
            if (string3 != null) {
                this.srcAstroFrame.setFrameEpoch(new Astrotime(string3).getJyr());
            }
        } else if (string4.indexOf("J2000") >= 0) {
            this.srcAstroFrame = AF_FK5;
        } else if (string4.indexOf("ECLIPTIC") >= 0 || string4.indexOf("ECL") >= 0) {
            this.srcAstroFrame = string2 == null ? AF_ECLI : new Ecliptic(new Astrotime(string2).getJyr());
            if (string3 != null) {
                this.srcAstroFrame.setFrameEpoch(new Astrotime(string3).getJyr());
            }
        } else if (string4.indexOf("SUPER_GALACTIC") >= 0 || string4.indexOf("SGAL") >= 0) {
            this.srcAstroFrame = AF_SGAL;
        } else if (string4.indexOf("GALACTIC") >= 0 || string4.indexOf("GAL") >= 0) {
            this.srcAstroFrame = AF_GAL;
        } else if (string4.indexOf("ICRS") >= 0 && string3 != null) {
            this.srcAstroFrame = new ICRS(new Astrotime(string3).getJyr());
        } else if (string4.indexOf("ICRS") < 0) {
            String string5 = this.coosys.get(string4);
            if (string5 != null) {
                this.setSourceAstroFrame(string4, string2, string3, n + 1);
                return;
            }
            this.consumer.tableParserInfo("      !!! Coordinate system unknown... assuming ICRS");
        }
        if (this.srcAstroFrame == AF_FK5 || (this.srcAstroFrame + "").equals("ICRS") || (this.srcAstroFrame + "").equals("FK5(J2000.0)")) {
            this.srcAstroFrame = null;
        }
        if (string == null) {
            string = "null";
        }
        if (this.srcAstroFrame != null) {
            this.c = new Astropos(this.srcAstroFrame);
            this.consumer.tableParserInfo("      => RA/DEC coordinate conversion: ref=\"" + string + "\" => " + this.srcAstroFrame + " to " + this.trgAstroFrame);
        } else {
            this.consumer.tableParserInfo("      => RA/DEC coordinate system used: ref=\"" + string + "\" => " + this.trgAstroFrame);
        }
    }

    private void setDefaultField() {
        this.tsvField = new Field[this.nField];
        for (int i = 0; i < this.nField; ++i) {
            Field field = this.tsvField[i] = new Field("C" + (i + 1));
            field.datatype = "D";
            this.consumer.setField(field);
        }
    }

    public static int getRaDec(Astrocoo astrocoo, String string, String string2, int n) throws Exception {
        block10: {
            char c;
            block9: {
                if (n == 0) {
                    try {
                        c = string2.charAt(0);
                        n = TableParser.isSexa(string + (c != '-' && c != '+' ? " +" : " ") + string2) ? 2 : 1;
                    }
                    catch (Exception exception) {
                        if (Aladin.levelTrace <= 3) break block9;
                        exception.printStackTrace();
                    }
                }
            }
            if (n == 2) {
                try {
                    c = string2.charAt(0);
                    String string3 = c == '-' || c == '+' ? string + " " + string2 : string + " +" + string2;
                    astrocoo.set(string3);
                }
                catch (Exception exception) {
                    if (Aladin.levelTrace > 3) {
                        exception.printStackTrace();
                    }
                    break block10;
                }
            }
            try {
                astrocoo.set(Double.parseDouble(string), Double.parseDouble(string2));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n;
    }

    private static boolean isSexa(String string) {
        int n = string.length();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == ':' || c == ' ' || c == '\t') {
                ++n2;
            }
            if (n2 <= 1) continue;
            return true;
        }
        return false;
    }

    private int raName(String string) {
        if (string.equalsIgnoreCase("_RAJ2000")) {
            this.setEq();
            return 0;
        }
        if (string.equalsIgnoreCase("RAJ2000")) {
            this.setEq();
            return 1;
        }
        if (string.equalsIgnoreCase("_RA")) {
            this.setEq();
            return 2;
        }
        if (string.equalsIgnoreCase("RA(ICRS)")) {
            this.setEq();
            return 3;
        }
        if (string.equalsIgnoreCase("RA")) {
            this.setEq();
            return 4;
        }
        if (string.equalsIgnoreCase("ALPHA_J2000")) {
            this.setEq();
            return 5;
        }
        if (string.equalsIgnoreCase("GLON")) {
            this.setGal();
            return 6;
        }
        if (string.equalsIgnoreCase("SGLON")) {
            this.setSGal();
            return 6;
        }
        if (string.equalsIgnoreCase("SLON")) {
            this.setSGal();
            return 6;
        }
        if (string.equalsIgnoreCase("ELON")) {
            this.setEcl();
            return 6;
        }
        return -1;
    }

    private int raSubName(String string) {
        if ((string = string.toLowerCase()).indexOf("radius") >= 0) {
            this.setEq();
            return -1;
        }
        if (string.startsWith("_ra")) {
            this.setEq();
            return 0;
        }
        if (string.startsWith("ra")) {
            this.setEq();
            return 1;
        }
        if (string.startsWith("alpha")) {
            this.setEq();
            return 2;
        }
        if (string.startsWith("GLON")) {
            this.setGal();
            return 0;
        }
        if (string.startsWith("SGLON")) {
            this.setSGal();
            return 0;
        }
        if (string.startsWith("SLON")) {
            this.setSGal();
            return 0;
        }
        if (string.startsWith("ELON")) {
            this.setEcl();
            return 0;
        }
        return -1;
    }

    private int deName(String string) {
        if (string.equalsIgnoreCase("_DEJ2000")) {
            this.setEq();
            return 0;
        }
        if (string.equalsIgnoreCase("_DECJ2000")) {
            this.setEq();
            return 1;
        }
        if (string.equalsIgnoreCase("DEJ2000")) {
            this.setEq();
            return 2;
        }
        if (string.equalsIgnoreCase("DECJ2000")) {
            this.setEq();
            return 3;
        }
        if (string.equalsIgnoreCase("_DE")) {
            this.setEq();
            return 4;
        }
        if (string.equalsIgnoreCase("_DEC")) {
            this.setEq();
            return 5;
        }
        if (string.equalsIgnoreCase("DE(ICRS)")) {
            this.setEq();
            return 6;
        }
        if (string.equalsIgnoreCase("DEC(ICRS)")) {
            this.setEq();
            return 6;
        }
        if (string.equalsIgnoreCase("DEC")) {
            this.setEq();
            return 7;
        }
        if (string.equalsIgnoreCase("DE")) {
            this.setEq();
            return 8;
        }
        if (string.equalsIgnoreCase("DELTA_J2000")) {
            this.setEq();
            return 8;
        }
        if (string.equalsIgnoreCase("GLAT")) {
            this.setGal();
            return 9;
        }
        if (string.equalsIgnoreCase("SGLAT")) {
            this.setSGal();
            return 9;
        }
        if (string.equalsIgnoreCase("SLAT")) {
            this.setSGal();
            return 9;
        }
        if (string.equalsIgnoreCase("ELAT")) {
            this.setEcl();
            return 9;
        }
        return -1;
    }

    private int deSubName(String string) {
        if ((string = string.toLowerCase()).startsWith("_dec")) {
            this.setEq();
            return 0;
        }
        if (string.startsWith("_de")) {
            this.setEq();
            return 1;
        }
        if (string.startsWith("dec")) {
            this.setEq();
            return 2;
        }
        if (string.startsWith("de")) {
            this.setEq();
            return 3;
        }
        if (string.indexOf("de") > 0) {
            this.setEq();
            return 4;
        }
        if (string.startsWith("delta")) {
            this.setEq();
            return 5;
        }
        if (string.startsWith("GLAT")) {
            this.setGal();
            return 0;
        }
        if (string.startsWith("SGLAT")) {
            this.setSGal();
            return 0;
        }
        if (string.startsWith("SLAT")) {
            this.setSGal();
            return 0;
        }
        if (string.startsWith("ELAT")) {
            this.setEcl();
            return 0;
        }
        return -1;
    }

    private void validLastCoordSys() {
        this.srcAstroFrame = this.lastCoordSys;
        if (this.srcAstroFrame == AF_GAL) {
            this.coosys.put(DEFAULT, "GAL");
        } else if (this.srcAstroFrame == AF_SGAL) {
            this.coosys.put(DEFAULT, "SGAL");
        } else if (this.srcAstroFrame == AF_SGAL) {
            this.coosys.put(DEFAULT, "ECL");
        } else {
            this.coosys.remove(DEFAULT);
        }
    }

    private void setGal() {
        this.lastCoordSys = AF_GAL;
    }

    private void setSGal() {
        this.lastCoordSys = AF_SGAL;
    }

    private void setEcl() {
        this.lastCoordSys = AF_ECLI;
    }

    private void setEq() {
        this.lastCoordSys = null;
    }

    private int pmraName(String string) {
        if (string.equalsIgnoreCase("PMRA")) {
            return 0;
        }
        return -1;
    }

    private int pmraSubName(String string) {
        if ((string = string.toLowerCase()).startsWith("pmra")) {
            return 0;
        }
        return -1;
    }

    private int pmdecName(String string) {
        if (string.equalsIgnoreCase("PMDE")) {
            return 0;
        }
        if (string.equalsIgnoreCase("PMDEC")) {
            return 1;
        }
        return -1;
    }

    private int pmdecSubName(String string) {
        if ((string = string.toLowerCase()).startsWith("pmde")) {
            return 0;
        }
        return -1;
    }

    private int xName(String string) {
        if (string.equalsIgnoreCase("XPOS")) {
            return 0;
        }
        if (string.equalsIgnoreCase("XPIX")) {
            return 1;
        }
        if (string.equalsIgnoreCase("X")) {
            return 2;
        }
        if (string.equalsIgnoreCase("POSX")) {
            return 3;
        }
        if (string.equalsIgnoreCase("X_IMAGE")) {
            return 4;
        }
        return -1;
    }

    private int xSubName(String string) {
        if (string.startsWith("XPOS") || string.startsWith("Xpos")) {
            return 0;
        }
        if (string.startsWith("XPIX") || string.startsWith("Xpix")) {
            return 1;
        }
        if (string.indexOf("XPOS") >= 0 || string.indexOf("Xpos") >= 0 || string.indexOf("XPIX") >= 0 || string.indexOf("Xpix") >= 0) {
            return 2;
        }
        if ((string.startsWith("X") || string.startsWith("x")) && !Character.isLetterOrDigit(string.charAt(1))) {
            return 3;
        }
        return -1;
    }

    private int yName(String string) {
        if (string.equalsIgnoreCase("YPOS")) {
            return 0;
        }
        if (string.equalsIgnoreCase("YPIX")) {
            return 1;
        }
        if (string.equalsIgnoreCase("Y")) {
            return 2;
        }
        if (string.equalsIgnoreCase("POSY")) {
            return 3;
        }
        if (string.equalsIgnoreCase("Y_IMAGE")) {
            return 4;
        }
        return -1;
    }

    private int ySubName(String string) {
        if (string.startsWith("YPOS") || string.startsWith("Ypos")) {
            return 0;
        }
        if (string.startsWith("YPIX") || string.startsWith("Ypix")) {
            return 1;
        }
        if (string.indexOf("YPOS") >= 0 || string.indexOf("Ypos") >= 0 || string.indexOf("YPIX") >= 0 || string.indexOf("Ypix") >= 0) {
            return 2;
        }
        if ((string.startsWith("Y") || string.startsWith("y")) && !Character.isLetterOrDigit(string.charAt(1))) {
            return 3;
        }
        return -1;
    }

    private void detectSEDField(Field field, int n) {
        String string;
        String string2 = string = field.ID != null ? field.ID : field.name;
        if (string == null) {
            return;
        }
        if (this.sFreq != null && string.equals(this.sFreq)) {
            field.sed = 1;
            this.nFreq = n;
        } else if (this.sFlux != null && string.equals(this.sFlux)) {
            field.sed = 2;
            this.nFlux = n;
        } else if (this.sFluxErr != null && string.equals(this.sFluxErr)) {
            field.sed = 3;
            this.nFluxErr = n;
        } else if (this.sSedId != null && string.equals(this.sSedId)) {
            field.sed = 4;
            this.nSedId = n;
        } else {
            return;
        }
    }

    private void detectPosField(Field field, int n) {
        int n2;
        String string = field.name == null ? "" : field.name;
        String string2 = field.ucd == null ? "" : field.ucd;
        String string3 = field.unit == null ? "" : field.unit;
        boolean bl = field.isNumDataType();
        if (this.memoField == null) {
            this.memoField = new Vector();
        }
        this.memoField.addElement(field);
        if (string2.equals("pos.eq") || string2.equals("pos.eq;meta.main")) {
            this.nRA = this.nDEC = n;
            this.format = string3.length() == 0 ? 0 : (string3.indexOf("h") >= 0 && string3.indexOf("m") >= 0 && string3.indexOf("s") >= 0 ? 2 : 1);
            this.validLastCoordSys();
            this.qualDEC = 0;
            this.qualRA = 0;
            return;
        }
        int n3 = -1;
        if (string2.equals("POS_EQ_RA_MAIN") || string2.equals("pos.eq.ra;meta.main")) {
            n3 = 0;
        } else if (string2.startsWith("POS_EQ_RA") || string2.startsWith("pos.eq.ra")) {
            n3 = 100;
        } else {
            n2 = this.raName(string);
            if (n2 >= 0) {
                n3 = string3.indexOf("h:m:s") >= 0 ? 200 + n2 : (string3.indexOf("deg") >= 0 ? 200 + n2 : (bl ? 200 + n2 : 400 + n2));
            } else {
                n2 = this.raSubName(string);
                if (n2 >= 0) {
                    n3 = string3.indexOf("h:m:s") >= 0 ? 300 + n2 : (string3.indexOf("deg") >= 0 ? 300 + n2 : (bl ? 300 + n2 : 450 + n2));
                }
            }
        }
        if (n3 >= 0 && this.qualRA > n3) {
            this.nRA = n;
            this.qualRA = n3;
            this.format = string3.length() == 0 ? 0 : (string3.indexOf("h") >= 0 && string3.indexOf("m") >= 0 && string3.indexOf("s") >= 0 ? 2 : 1);
            this.validLastCoordSys();
        }
        n3 = -1;
        if (string2.equals("POS_EQ_DEC_MAIN") || string2.equals("pos.eq.dec;meta.main")) {
            n3 = 0;
        } else if (string2.startsWith("POS_EQ_DEC") || string2.startsWith("pos.eq.dec")) {
            n3 = 100;
        } else {
            n2 = this.deName(string);
            if (n2 >= 0) {
                n3 = string3.indexOf("d:m:s") >= 0 ? 200 + n2 : (string3.startsWith("deg") ? 200 + n2 : (bl ? 200 + n2 : 400 + n2));
            } else {
                n2 = this.deSubName(string);
                if (n2 >= 0) {
                    n3 = string3.indexOf("d:m:s") >= 0 ? 300 + n2 : (string3.startsWith("deg") ? 300 + n2 : (bl ? 300 + n2 : 450 + n2));
                }
            }
        }
        if (n3 > 0 && this.nRA == n - 1 && this.nRA >= 0) {
            --n3;
        }
        if (n3 >= 0 && this.qualDEC > n3) {
            this.nDEC = n;
            this.qualDEC = n3;
        }
        n3 = -1;
        if (string2.equals("POS_PMRA") || string2.equals("pos.pm;pos.eq.ra")) {
            try {
                new Unit(string3).convertTo(new Unit("mas/yr"));
                n3 = 0;
            }
            catch (Exception exception) {
                n3 = 1;
            }
        } else {
            n2 = this.pmraName(string);
            if (n2 >= 0) {
                if (string2.startsWith("pos.pm")) {
                    n3 = 200 + n2;
                } else {
                    try {
                        new Unit(string3).convertTo(new Unit("mas/yr"));
                        n3 = 300 + n2;
                    }
                    catch (Exception exception) {
                        n3 = 600 + n2;
                    }
                }
            } else {
                n2 = this.pmraSubName(string);
                if (n2 >= 0) {
                    if (string2.startsWith("pos.pm")) {
                        n3 = 400 + n2;
                    } else {
                        try {
                            new Unit(string3).convertTo(new Unit("mas/yr"));
                            n3 = 500 + n2;
                        }
                        catch (Exception exception) {
                            n3 = 700 + n2;
                        }
                    }
                }
            }
        }
        if (n3 >= 0 && this.qualX > n3) {
            this.nPMRA = n;
            this.qualPMRA = n3;
        }
        n3 = -1;
        if (string2.equals("POS_PMDE") || string2.equals("pos.pm;pos.eq.dec")) {
            n3 = 0;
        } else {
            n2 = this.pmdecName(string);
            if (n2 >= 0) {
                if (string2.startsWith("pos.pm")) {
                    n3 = 200 + n2;
                }
                try {
                    new Unit(string3).convertTo(new Unit("mas/yr"));
                    n3 = 300 + n2;
                }
                catch (Exception exception) {
                    n3 = 600 + n2;
                }
            } else {
                n2 = this.pmdecSubName(string);
                if (n2 >= 0) {
                    if (string2.startsWith("pos.pm")) {
                        n3 = 400 + n2;
                    } else {
                        try {
                            new Unit(string3).convertTo(new Unit("mas/yr"));
                            n3 = 500 + n2;
                        }
                        catch (Exception exception) {
                            n3 = 700 + n2;
                        }
                    }
                }
            }
        }
        if (n3 >= 0 && this.qualX > n3) {
            this.nPMDEC = n;
            this.qualPMDEC = n3;
        }
        n3 = -1;
        if (string2.equals("POS_CCD_X") || string2.equals("pos.cartesian.x;instr.det")) {
            n3 = 0;
        } else if (string2.startsWith("pos.cartesian.x")) {
            n3 = 100;
        } else {
            n2 = this.xName(string);
            if (n2 >= 0) {
                n3 = string2.startsWith("pos.det") ? 200 + n2 : (string3.equals("pix") || string3.equals("mm") ? 300 + n2 : 600 + n2);
            } else {
                n2 = this.xSubName(string);
                if (n2 >= 0) {
                    n3 = string2.startsWith("pos.det") ? 400 + n2 : (string3.equals("pix") || string3.equals("mm") ? 500 + n2 : 700 + n2);
                }
            }
        }
        if (n3 >= 0 && this.qualX > n3) {
            this.nX = n;
            this.qualX = n3;
        }
        n3 = -1;
        if (string2.equals("POS_CCD_Y") || string2.equals("pos.cartesian.y;instr.det")) {
            n3 = 0;
        } else if (string2.startsWith("pos.cartesian.y")) {
            n3 = 100;
        } else {
            n2 = this.yName(string);
            if (n2 >= 0) {
                n3 = string2.startsWith("pos.det") ? 200 + n2 : (string3.equals("pix") || string3.equals("mm") ? 300 + n2 : 600 + n2);
            } else {
                n2 = this.ySubName(string);
                if (n2 >= 0) {
                    n3 = string2.startsWith("pos.det") ? 400 + n2 : (string3.equals("pix") || string3.equals("mm") ? 500 + n2 : 700 + n2);
                }
            }
        }
        if (n3 >= 0 && this.qualY > n3) {
            this.nY = n;
            this.qualY = n3;
        }
    }

    @Override
    public void endElement(String string) {
        if (this.inError) {
            this.inError = false;
        }
        int n = this.xmlparser.getDepth() + 1;
        if (this.inGroup) {
            this.memoEndGroup(string);
        }
        if (string.charAt(0) == 'G' && n >= 1 && string.equalsIgnoreCase("GROUP")) {
            --this.ngroup;
            this.inGroup = false;
            return;
        }
        if ((n -= this.ngroup) == 7 && string.equalsIgnoreCase("TD")) {
            this.inTD = false;
            if (!this.valueInTD) {
                this.record[this.row] = null;
            }
            this.valueInTD = false;
            ++this.row;
        } else if (n == 6 && string.equalsIgnoreCase("TR")) {
            this.consumeRecord(this.record, -1);
        } else if (n == 6 && string.equalsIgnoreCase("STREAM")) {
            this.inEncode64 = false;
        } else if (n == 3 && string.equalsIgnoreCase("TABLE")) {
            if (!this.flagPosChooser) {
                this.posChooser();
            }
            this.tableSub = null;
            this.fieldSub = null;
            this.consumer.endTable();
        } else if (n == 2 && string.equalsIgnoreCase("RESOURCE")) {
            this.resourceSub = null;
            this.tableSub = null;
            this.fieldSub = null;
            this.consumer.endResource();
        } else if (string.equalsIgnoreCase("DESCRIPTION")) {
            this.inFieldDesc = false;
        } else if (n == 5 && string.equalsIgnoreCase("LINK")) {
            this.inLinkField = false;
        } else if (n == 5 && string.equalsIgnoreCase("CSV")) {
            this.inCSV = false;
        } else if (n == 5 && string.equalsIgnoreCase("BINARY")) {
            this.inBinary = false;
        } else if (n == 5 && string.equalsIgnoreCase("BINARY2")) {
            this.inBinary2 = false;
        } else if (n == 5 && string.equalsIgnoreCase("FITS")) {
            this.inFits = false;
        } else if (n == 4 && string.equalsIgnoreCase("FIELD")) {
            this.fieldSub = null;
            if (this.f.name == null) {
                this.f.name = this.f.ID;
            }
            this.detectPosField(this.f, this.nField);
            this.detectSEDField(this.f, this.nField);
            ++this.nField;
            this.consumer.setField(this.f);
        } else if (n != 4 || string.equalsIgnoreCase("PARAM")) {
            // empty if block
        }
    }

    private boolean isEmpty(char[] cArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            if (Character.isSpace(cArray[i + n])) continue;
            return false;
        }
        return true;
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws Exception {
        try {
            if (this.inGroup) {
                this.memoInGroup(cArray, n, n2);
                return;
            }
            if (this.inEncode64) {
                this.parseBase64(cArray, n, n2, this.inBinary2);
                return;
            }
            if (this.isEmpty(cArray, n, n2)) {
                return;
            }
            if (this.inLinkField) {
                if (this.f.refText == null) {
                    this.f.addInfo("refText", TableParser.getStringTrim(cArray, n, n2));
                }
            } else if (this.inFieldDesc) {
                if (this.f != null) {
                    this.f.addInfo("DESCRIPTION", TableParser.getStringTrim(cArray, n, n2));
                }
            } else if (this.inCSV || this.flagTSV) {
                this.dataParse(cArray, n, n2);
            } else if (this.inTD) {
                this.record[this.row] = TableParser.getStringTrim(cArray, n, n2);
                this.valueInTD = n2 > 0;
            } else if (this.inError) {
                this.error = TableParser.getStringTrim(cArray, n, n2);
            } else if (this.f != null && this.fieldSub != null) {
                this.f.addInfo(this.fieldSub, TableParser.getStringTrim(cArray, n, n2));
            } else if (this.filter != null) {
                this.consumeFilter(TableParser.getStringTrim(cArray, n, n2));
            } else if (this.tableSub != null) {
                this.consumer.setTableInfo(this.tableSub, TableParser.getStringTrim(cArray, n, n2));
            } else if (this.resourceSub != null) {
                this.consumer.setResourceInfo(this.resourceSub, TableParser.getStringTrim(cArray, n, n2));
            }
        }
        catch (Exception exception) {
            if (Aladin.levelTrace == 4) {
                System.err.println("TableParser.character() exception: table line " + this.xmlparser.getCurrentLine());
            }
            throw exception;
        }
    }

    private void consumeFilter(String string) {
        this.consumer.setFilter(this.filter + string + (this.filter.length() > 0 ? "\n}\n" : ""));
        this.filter = null;
    }

    private void consumeRecord(String[] stringArray, int n) {
        try {
            if (this.flagXY) {
                double d = Double.parseDouble(stringArray[this.nX]);
                double d2 = Double.parseDouble(stringArray[this.nY]);
                this.consumer.setRecord(d, d2, stringArray);
            } else {
                String string;
                String string2;
                if (this.nRA != this.nDEC) {
                    string2 = stringArray[this.nRA];
                    string = stringArray[this.nDEC];
                } else {
                    String string3 = stringArray[this.nRA];
                    int n2 = string3.indexOf(43);
                    if (n2 < 0) {
                        n2 = string3.indexOf(45);
                    }
                    if (n2 < 0 && (n2 = string3.indexOf(44)) > 0) {
                        ++n2;
                    }
                    if (n2 < 0) {
                        n2 = string3.indexOf(32);
                    }
                    if (n2 < 0) {
                        throw new Exception("Unsupported syntax for coordinates expressed as an unique field");
                    }
                    string2 = string3.substring(0, n2).trim();
                    string = string3.substring(n2).trim();
                }
                this.format = TableParser.getRaDec(this.c, string2, string, this.format);
                if (this.srcAstroFrame != null) {
                    this.c.convertTo(this.trgAstroFrame);
                    this.consumer.setRecord(this.c.getLon(), this.c.getLat(), stringArray);
                    this.c = new Astropos(this.srcAstroFrame);
                } else {
                    this.consumer.setRecord(this.c.getLon(), this.c.getLat(), stringArray);
                }
            }
        }
        catch (Exception exception) {
            System.err.println("Table parser error " + (n != -1 ? "(record " + (n + 1) + ")" : "") + ": " + exception);
            exception.printStackTrace();
        }
    }

    private static final char isColSep(char c, char[] cArray) {
        for (int i = 0; i < cArray.length; ++i) {
            if (c != cArray[i]) continue;
            return c;
        }
        return '\u0000';
    }

    public static int countColumn(String string, char[] cArray) {
        char[] cArray2 = string.toCharArray();
        int n = 0;
        int n2 = cArray2.length;
        int n3 = 0;
        int n4 = 0;
        while (n < n2) {
            while (n < n2) {
                char c = TableParser.isColSep(cArray2[n], cArray);
                n3 = c;
                if (c != '\u0000') break;
                ++n;
            }
            ++n4;
            if (n3 == 32) {
                while (n < n2 && cArray2[n] == ' ') {
                    ++n;
                }
                continue;
            }
            ++n;
        }
        return n4;
    }

    private int getField(char[] cArray, int n, int n2, char c, char[] cArray2, int n3) throws Exception {
        String string;
        int n4;
        boolean bl;
        int n5 = n;
        char c2 = '\u0000';
        boolean bl2 = bl = cArray2.length > 0 && cArray2[0] == ',';
        if (bl) {
            n4 = 0;
            while (n < n2) {
                if (cArray[n] == '\"') {
                    int n6 = n4 = n4 == 0 ? 1 : 0;
                }
                if (n4 == 0 && ((c2 = TableParser.isColSep(cArray[n], cArray2)) != '\u0000' || cArray[n] == c)) break;
                ++n;
            }
            if (n4 != 0) {
                throw new Exception("Bad CSV: Excel quote delimiters not balanced (record " + (n3 + 1) + " field[" + this.row + "]=[" + TableParser.getStringTrim(cArray, n5, n - n5) + "])");
            }
        } else {
            while (n < n2 && (c2 = TableParser.isColSep(cArray[n], cArray2)) == '\u0000' && cArray[n] != c) {
                ++n;
            }
        }
        n4 = 0;
        if (n == n2 && n > 0 && cArray[n - 1] != c) {
            n4 = 1;
        }
        if (bl) {
            string = n - n5 > 1 && cArray[n5] == '\"' && cArray[n - 1] == '\"' ? TableParser.getStringTrim(cArray, n5 + 1, n - n5 - 2) : TableParser.getStringTrim(cArray, n5, n - n5 + n4);
        } else {
            if (c2 == ' ') {
                ++n;
                while (n < n2 && cArray[n] == ' ' && cArray[n] != c) {
                    ++n;
                }
                --n;
            }
            string = TableParser.getStringTrim(cArray, n5, n - n5 + n4);
        }
        if (c2 == ' ' && this.row == 0 && string.length() == 0) {
            return n;
        }
        if (this.record != null) {
            if (this.row >= this.record.length) {
                String string2 = "Not aligned CSV catalog (record=" + (n3 + 1) + " extra row value=\"" + string + "\") => ignored\n";
                this.aladin.command.printConsole(string2);
            } else {
                this.record[this.row] = string;
            }
        } else {
            if (this.vRecord == null) {
                this.vRecord = new Vector();
            }
            this.vRecord.addElement(string);
        }
        ++this.row;
        return n;
    }

    private int getRecord(char[] cArray, int n, int n2, char c, char[] cArray2, int n3) throws Exception {
        this.row = 0;
        int n4 = 0;
        while (n < n2 && cArray[n] != c) {
            n = this.getField(cArray, n + n4, n2, c, cArray2, n3);
            n4 = 1;
        }
        if (this.record != null && this.row == this.record.length - 1 && n == n2 && n > 0 && cArray[n - 1] != c) {
            System.out.println("dernier champ vide avec absence de retour \u00e0 la ligne");
            this.record[this.row++] = "";
        }
        if (!(this.record == null || this.row >= this.record.length || this.row == 1 && this.record[0].equals("[EOD]"))) {
            String string = "Not aligned CSV catalog (record=" + (n3 + 1) + " missing rows nbRow=" + this.row + "/" + this.record.length + ") => ignored" + (this.filename != null ? this.filename : "");
            this.aladin.command.printConsole(string);
        }
        return n;
    }

    protected static int skipRecSep(char[] cArray, int n, char c) {
        if (cArray[n] == c) {
            n = c == '\n' && n < cArray.length - 1 && cArray[n + 1] == '\r' ? (n += 2) : ++n;
        }
        return n;
    }

    protected static int skipRec(char[] cArray, int n, char c) {
        while (cArray[n] != c && n < cArray.length - 1) {
            ++n;
        }
        return TableParser.skipRecSep(cArray, n, c);
    }

    private boolean vide(char[] cArray, int n, int n2, char c) {
        if (cArray[n] == '#') {
            return true;
        }
        while (n < n2 && (cArray[n] == ' ' || cArray[n] == '\t' || cArray[n] == '\r')) {
            ++n;
        }
        return cArray[n] == c;
    }

    private boolean isSimpleDahsLine(char[] cArray, int n, int n2, char c) {
        while (n < n2 && cArray[n] == '-') {
            ++n;
        }
        return cArray[n] == c;
    }

    private String colSepInfo(char[] cArray) {
        String string = null;
        for (int i = 0; i < cArray.length; ++i) {
            String string2;
            switch (cArray[i]) {
                case '\t': {
                    string2 = "Tab";
                    break;
                }
                case '|': {
                    string2 = "Pipe (|)";
                    break;
                }
                case ';': {
                    string2 = "Semi-column (;)";
                    break;
                }
                case ',': {
                    string2 = "Comma (,)";
                    break;
                }
                case ' ': {
                    string2 = "One or several spaces";
                    break;
                }
                default: {
                    string2 = cArray[i] + "";
                }
            }
            string = i == 0 ? string2 : string + ", " + string2;
        }
        return string;
    }

    private void dataParse(char[] cArray, int n, int n2) throws Exception {
        int n3;
        char c = '\n';
        char[] cArray2 = "\t".toCharArray();
        int n4 = n;
        int n5 = n + n2;
        int n6 = 0;
        int n7 = 0;
        if (this.recsep != null) {
            c = this.recsep.charAt(0);
        }
        if (this.colsep != null) {
            cArray2 = this.colsep.toCharArray();
        }
        int n8 = this.headlines == null ? 0 : Integer.parseInt(this.headlines);
        this.headlines = null;
        n6 = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.flagNewTable) {
            if (this.flagTSV) {
                this.consumer.tableParserInfo("CSV format [" + this.colSepInfo(cArray2) + "]");
            } else {
                this.consumer.tableParserInfo("   -found CSV DATA (field sep=" + this.colSepInfo(cArray2) + " record sep=" + (c == '\n' ? "\\n" : "[" + (byte)c + "]") + ")");
                if (n8 == 0) {
                    this.consumer.tableParserInfo("   -No CSV header");
                }
            }
            this.flagNewTable = false;
        }
        for (n6 = 0; n4 < n5 && (this.flagTSV || n6 < n8); ++n6) {
            int n9;
            Object object;
            if (this.vide(cArray, n4, n5, c) || n6 == 1 && this.isSimpleDahsLine(cArray, n4, n5, c)) {
                --n6;
                n4 = TableParser.skipRec(cArray, n4, c);
                continue;
            }
            n4 = this.getRecord(cArray, n4, n5, c, cArray2, n7);
            if (this.record == null) {
                this.nField = this.vRecord.size();
                this.consumer.tableParserInfo("   -found CSV DATA (" + this.nField + " fields)");
                this.record = new String[this.nField];
                object = this.vRecord.elements();
                for (n3 = 0; n3 < this.nField; ++n3) {
                    this.record[n3] = (String)object.nextElement();
                }
            }
            bl2 = true;
            for (n3 = 0; n3 < this.nField && bl2; ++n3) {
                object = this.record[n3].toCharArray();
                for (n9 = 0; n9 < ((char[])object).length && object[n9] == '-'; ++n9) {
                }
                if (n9 >= ((char[])object).length) continue;
                bl2 = false;
                break;
            }
            if (bl2) {
                this.consumer.tableParserInfo("   -Found " + (n6 + 1) + " lines CVS header with dash separator");
                n4 = TableParser.skipRecSep(cArray, n4, c);
                break;
            }
            if (!this.flagTSV) continue;
            if (n6 == 0 || n6 == 1 && (this.qualRA < 500 && this.qualDEC < 500 || this.qualX < 700 && this.qualY < 700)) {
                int n10 = 0;
                int n11 = 1;
                if (n6 == 1) {
                    if (this.qualRA < 500) {
                        n10 = this.nRA;
                        n11 = this.nDEC;
                    } else {
                        n10 = this.nX;
                        n11 = this.nY;
                    }
                }
                bl = false;
                for (n3 = 0; n3 < 2; ++n3) {
                    char c2;
                    int n12;
                    int n13 = n12 = n3 == 0 ? n10 : n11;
                    if (n12 >= this.nField) {
                        bl = true;
                        break;
                    }
                    char[] cArray3 = this.record[n12].toCharArray();
                    for (n9 = 0; n9 < cArray3.length && ((c2 = cArray3[n9]) >= '0' && c2 <= '9' || c2 == '.' || c2 == '+' || c2 == 'e' || c2 == 'E' || c2 == '-' || c2 == ':' || c2 == ' '); ++n9) {
                    }
                    if (n9 != 0 && n9 >= cArray3.length) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    bl3 = true;
                    if (n6 == 0) {
                        this.consumer.tableParserInfo("   -No CSV header found!");
                        this.setDefaultField();
                    } else {
                        this.consumer.tableParserInfo("   -Found one line CVS header");
                    }
                    this.posChooser();
                    break;
                }
            }
            if (bl && n6 == 0 && (this.nRA < 0 || this.flagTSV)) {
                this.tsvField = new Field[this.nField];
                for (n3 = 0; n3 < this.nField; ++n3) {
                    Field field = this.tsvField[n3] = new Field(this.record[n3]);
                    field.datatype = "D";
                    this.detectPosField(field, n3);
                    if (!this.flagTSV) continue;
                    this.consumer.setField(field);
                }
                this.posChooser();
            }
            n4 = TableParser.skipRecSep(cArray, n4, c);
        }
        while (n4 < n5 || bl3) {
            if (!bl3) {
                if (this.vide(cArray, n4, n5, c)) {
                    n4 = TableParser.skipRec(cArray, n4, c);
                    continue;
                }
                n4 = this.getRecord(cArray, n4, n5, c, cArray2, n7);
            } else {
                bl3 = false;
            }
            ++n7;
            if (this.row == 1 && this.record[0].equals("[EOD]")) {
                this.consumer.tableParserInfo("   -Stop parsing at SkyCat [EOD] tag");
                n4 = n5;
                break;
            }
            while (this.row < this.nField) {
                this.record[this.row++] = "???";
            }
            if (this.tsvField != null) {
                for (n3 = 0; n3 < this.tsvField.length; ++n3) {
                    if (this.tsvField[n3].datatype == null || !this.tsvField[n3].datatype.equals("D")) continue;
                    try {
                        String string = this.record[n3].trim();
                        if (string.length() <= 0 || string.equals("-") || string.equalsIgnoreCase("null")) continue;
                        Double.parseDouble(string);
                        continue;
                    }
                    catch (Exception exception) {
                        this.tsvField[n3].datatype = null;
                    }
                }
            }
            this.consumeRecord(this.record, n7);
            n4 = TableParser.skipRecSep(cArray, n4, c);
        }
        if (n7 == 0) {
            String string = TableParser.getStringTrim(cArray, n, n2 > 200 ? 200 : n2);
            throw new Exception("Data parsing error:\n \n[" + string + "...]");
        }
    }
}

