/*
 * Decompiled with CFR 0.152.
 */
package cds.xml;

import cds.aladin.Aladin;
import cds.aladin.MyInputStream;
import cds.tools.Util;
import cds.xml.XMLConsumer;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;

public final class XMLParser {
    private XMLConsumer ac;
    private MyInputStream dis;
    private Stack stack;
    public int nstack;
    private String name;
    private Hashtable param;
    private char[] ch;
    private int start;
    private int length;
    private int end;
    private byte[] tmp;
    private int offset;
    private int max;
    private String error;
    private boolean beforeXML;
    private String endTag;
    private int line;
    static final int BUFSIZE = 65536;
    static final int MAXBUF = 64512;
    static final String[] mKey = new String[]{"&amp;", "&gt;", "&lt;", "&apos;", "&quot;"};
    static final String[] mValue = new String[]{"&", ">", "<", "'", "\""};
    private static final char EOF = '\u001a';
    private static final char[] COM = new char[]{'!', '-', '-'};
    private boolean flagCOM;
    private static final char[] CDATA = new char[]{'!', '[', 'C', 'D', 'A', 'T', 'A', '['};
    private boolean flagCDATA;
    private boolean flagDoublePoint;
    private StringBuilder curString = new StringBuilder();
    private StringBuilder macro = new StringBuilder();

    public XMLParser(XMLConsumer xMLConsumer) {
        this(xMLConsumer, false);
    }

    public XMLParser(XMLConsumer xMLConsumer, boolean bl) {
        this.ac = xMLConsumer;
        this.stack = bl ? new Stack() : null;
        this.nstack = 0;
        this.param = new Hashtable();
        this.tmp = new byte[65536];
        this.max = 0;
        this.offset = 0;
        this.beforeXML = true;
        this.error = null;
    }

    public int getCurrentLine() {
        return this.line;
    }

    public boolean parse(MyInputStream myInputStream) throws Exception {
        boolean bl;
        this.dis = myInputStream;
        this.endTag = null;
        this.line = 0;
        this.setTestBeforeXML(myInputStream);
        try {
            bl = this.xmlBeforeTag();
        }
        catch (Exception exception) {
            if (Aladin.levelTrace >= 3) {
                System.out.println("XML parse error at line " + this.line);
            }
            throw exception;
        }
        try {
            if (myInputStream != null) {
                myInputStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public boolean parse(MyInputStream myInputStream, String string) throws Exception {
        boolean bl;
        this.dis = myInputStream;
        this.endTag = string;
        this.line = 0;
        this.setTestBeforeXML(myInputStream);
        try {
            bl = this.xmlBeforeTag();
        }
        catch (Exception exception) {
            if (Aladin.levelTrace >= 3) {
                System.out.println("XML parse error at line " + this.line);
            }
            if (Aladin.levelTrace > 3) {
                exception.printStackTrace();
            }
            throw exception;
        }
        return bl;
    }

    private void setTestBeforeXML(MyInputStream myInputStream) throws Exception {
        this.beforeXML = (myInputStream.getType() & 0x100L) == 0L;
    }

    public Stack getStack() throws Exception {
        if (this.stack == null) {
            throw new Exception("No XML stack");
        }
        return this.stack;
    }

    public int getDepth() {
        return this.nstack;
    }

    public boolean in(String string) throws Exception {
        if (this.stack == null) {
            throw new Exception("No XML stack");
        }
        Enumeration enumeration = this.stack.elements();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", /.\t\n\r\f");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            boolean bl = false;
            while (enumeration.hasMoreElements() && !(bl = string2.equals(enumeration.nextElement()))) {
            }
            if (bl) continue;
            return false;
        }
        return !enumeration.hasMoreElements();
    }

    public String getError() {
        return this.error;
    }

    private void setError(String string) {
        this.error = string + "\n";
    }

    public static String XMLEncode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            int n2;
            char c = string.charAt(i);
            for (n2 = 0; n2 < mValue.length && mValue[n2].charAt(0) != c; ++n2) {
            }
            if (n2 < mValue.length) {
                stringBuffer.append(mKey[n2]);
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String XMLDecode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = null;
        int n = 0;
        int n2 = string.length();
        block4: for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            switch (n) {
                case 0: {
                    if (c == '&') {
                        stringBuffer2 = new StringBuffer();
                        stringBuffer2.append(c);
                        n = 1;
                        continue block4;
                    }
                    stringBuffer.append(c);
                    continue block4;
                }
                case 1: {
                    int n3;
                    stringBuffer2.append(c);
                    if (c != ';') continue block4;
                    String string2 = stringBuffer2.toString();
                    for (n3 = 0; n3 < mKey.length && !string2.equals(mKey[n3]); ++n3) {
                    }
                    if (n3 >= mKey.length) {
                        if (Aladin.levelTrace >= 3) {
                            System.err.println("XMlParser.XMLDecode(" + string + ") macro unknown => ignored !");
                        }
                        return string;
                    }
                    stringBuffer.append(mValue[n3]);
                    n = 0;
                }
            }
        }
        if (n == 1) {
            return null;
        }
        return stringBuffer.toString();
    }

    public byte[] getUnreadBuffer() {
        if (this.max == -1) {
            return null;
        }
        byte[] byArray = new byte[this.max - this.offset];
        System.arraycopy(this.tmp, this.offset, byArray, 0, this.max - this.offset);
        return byArray;
    }

    private char xmlGetc() {
        if (this.offset >= this.max) {
            try {
                this.max = this.dis.read(this.tmp);
            }
            catch (IOException iOException) {
                if (Aladin.levelTrace > 3) {
                    iOException.printStackTrace();
                }
                this.setError("Stream error: " + iOException);
                return '\u001a';
            }
            if (this.max == -1) {
                return '\u001a';
            }
            this.offset = 0;
        }
        char c = (char)this.tmp[this.offset++];
        return c;
    }

    private char xmlGetString(int n) throws Exception {
        int n2 = 0;
        int n3 = -1;
        char c = '\u0000';
        char c2 = '\u0000';
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        boolean bl4 = true;
        boolean bl5 = true;
        boolean bl6 = false;
        int n4 = 32;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        boolean bl10 = false;
        boolean bl11 = false;
        boolean bl12 = false;
        boolean bl13 = false;
        boolean bl14 = false;
        boolean bl15 = false;
        boolean bl16 = false;
        boolean bl17 = false;
        this.flagCOM = false;
        this.flagCDATA = false;
        this.flagDoublePoint = false;
        Util.resetString(this.curString);
        Util.resetString(this.macro);
        while (bl3) {
            c2 = c = this.xmlGetc();
            if (c == '\u001a') break;
            if (!(n != 0 && n != 2 || c != '&' && this.macro.length() <= 0)) {
                int n5;
                this.macro.append(c);
                if (c != ';') continue;
                String string = this.macro.toString();
                if (string.charAt(1) == '#') {
                    try {
                        n5 = string.charAt(string.length() - 2) == 'x' ? 1 : 0;
                        int n6 = Integer.parseInt(string.substring(2, string.length() - (n5 != 0 ? 2 : 1)), n5 != 0 ? 16 : 10);
                        c2 = (char)n6;
                    }
                    catch (Exception exception) {
                        if (Aladin.levelTrace >= 3) {
                            System.err.println("XMlParser.xmlGetString(...) unresolved macro [" + string + "] => ignored !");
                        }
                    }
                } else {
                    for (n5 = 0; n5 < mKey.length && !string.equals(mKey[n5]); ++n5) {
                    }
                    if (n5 < mKey.length) {
                        c2 = mValue[n5].charAt(0);
                    } else if (Aladin.levelTrace >= 3) {
                        System.err.println("XMlParser.xmlGetString(...) unknown macro [" + string + "] => ignored !");
                    }
                }
                Util.resetString(this.macro);
            }
            if (bl = Character.isSpace(c)) {
                n4 = c;
            }
            switch (n) {
                case 0: {
                    boolean bl18 = bl3 = !bl && c != '>';
                    if (c == ':') {
                        this.flagDoublePoint = true;
                    }
                    if (bl5) {
                        if (c != COM[n2]) {
                            bl5 = false;
                        } else if (n2 == COM.length - 1) {
                            this.flagCOM = true;
                            return c;
                        }
                    }
                    if (!bl4) break;
                    if (c != CDATA[n2]) {
                        bl4 = false;
                        break;
                    }
                    if (n2 != CDATA.length - 1) break;
                    this.flagCDATA = true;
                    return c;
                }
                case 1: {
                    bl3 = c != '>';
                    break;
                }
                case 2: {
                    boolean bl19 = bl3 = c != '<';
                    if (n2 < 64512 || !bl6) break;
                    this.ch = this.curString.toString().toCharArray();
                    this.ac.characters(this.ch, 0, this.ch.length - 1);
                    Util.resetString(this.curString);
                    n2 = 0;
                    n3 = 0;
                    break;
                }
                case 3: {
                    bl3 = !bl10 || c != '>';
                    bl12 = c == ']';
                    bl10 = bl11 && bl12;
                    bl11 = bl12;
                    if (n2 < 64512 || !bl6) break;
                    this.ch = this.curString.toString().toCharArray();
                    this.ac.characters(this.ch, 0, this.ch.length - 1);
                    Util.resetString(this.curString);
                    n2 = 0;
                    n3 = 0;
                    break;
                }
                case 4: {
                    bl3 = !bl7 || c != '>';
                    bl9 = c == '-';
                    bl7 = bl8 && bl9;
                    bl8 = bl9;
                    break;
                }
                case 5: {
                    bl3 = !bl13 || c != '>';
                    bl13 = bl14 && (c == 'l' || c == 'L') || bl13;
                    bl14 = bl15 && (c == 'm' || c == 'M');
                    bl15 = bl16 && (c == 'x' || c == 'X');
                    bl16 = bl17 && c == '?';
                    boolean bl20 = bl17 = c == '<';
                    if (!bl17) break;
                    n3 = n2;
                }
            }
            if (n == 3 || n == 5 || (!bl || bl && !bl2) && n < 3) {
                if (n != 3 && n != 5 && bl) {
                    c2 = ' ';
                }
                this.curString.append(c2);
                ++n2;
            }
            bl2 = bl;
            boolean bl21 = bl6 = c == '\n' || c == '\r';
            if (c != '\n') continue;
            ++this.line;
        }
        if (n != 4) {
            this.ch = this.curString.toString().toCharArray();
        }
        this.start = 0;
        int n7 = n == 3 ? this.ch.length - 3 : (this.length = n == 5 && bl13 && n3 >= 0 ? n3 : this.ch.length - 1);
        if (this.length < 0) {
            this.length = 0;
        }
        return c2;
    }

    private String getNameParam() {
        while (this.start < this.end && Character.isSpace(this.ch[this.start])) {
            ++this.start;
        }
        int n = this.start;
        boolean bl = false;
        while (this.start < this.end && !Character.isSpace(this.ch[this.start]) && this.ch[this.start] != '=') {
            if (!bl && this.ch[this.start] == '&') {
                bl = true;
            }
            ++this.start;
        }
        if (bl) {
            String string = XMLParser.XMLDecode(new String(this.ch, n, this.start - n));
            if (string == null) {
                this.setError("Macro error");
                return null;
            }
            return string;
        }
        return new String(this.ch, n, this.start - n);
    }

    private String getValueParam() {
        while (this.start < this.end && (Character.isSpace(this.ch[this.start]) || this.ch[this.start] == '=')) {
            ++this.start;
        }
        char c = ' ';
        if (this.start < this.end && (this.ch[this.start] == '\"' || this.ch[this.start] == '\'')) {
            c = this.ch[this.start];
            ++this.start;
        }
        int n = this.start;
        boolean bl = false;
        while (this.start < this.end && (c == ' ' && !Character.isSpace(this.ch[this.start]) || c != ' ' && this.ch[this.start] != c)) {
            if (!bl && this.ch[this.start] == '&') {
                bl = true;
            }
            ++this.start;
        }
        int n2 = this.start++;
        if (c != ' ') {
            // empty if block
        }
        while (this.start < this.end && Character.isSpace(this.ch[this.start])) {
            ++this.start;
        }
        if (bl) {
            String string = XMLParser.XMLDecode(new String(this.ch, n, n2 - n));
            if (string == null) {
                this.setError("Macro error");
                return null;
            }
            return string;
        }
        return new String(this.ch, n, n2 - n);
    }

    private int xmlGetParamTag(int n) throws Exception {
        int n2 = 0;
        char c = this.xmlGetString(n == -1 ? 4 : 1);
        if (this.length > 0 && this.ch[this.start + this.length - 1] == '/') {
            n2 = 3;
            --this.length;
        }
        if (c != '>') {
            this.setError("No end tag (mode=" + n + ")");
            return -1;
        }
        if (n == 1) {
            this.param.clear();
            this.end = this.start + this.length;
            while (this.start < this.end) {
                String string = this.getNameParam();
                String string2 = this.getValueParam();
                if (string2 == null) {
                    return -1;
                }
                this.param.put(string, string2);
                this.param.put(string.toLowerCase(), string2);
            }
        }
        return n2;
    }

    private int xmlGetNameTag() throws Exception {
        int n = 1;
        char c = this.xmlGetString(0);
        if (c == '\u0000') {
            this.setError("stream truncated");
            return -1;
        }
        if (this.flagCDATA) {
            return 4;
        }
        if (this.flagCOM) {
            return 5;
        }
        if (this.length > 0 && this.ch[this.start] == '/') {
            n = 2;
            ++this.start;
            --this.length;
        } else if (this.length > 1 && this.ch[this.start + this.length - 1] == '/') {
            n = 3;
            --this.length;
        }
        if (n == 1 && c != '>') {
            n = 0;
        }
        if (this.flagDoublePoint) {
            int n2 = this.start;
            int n3 = this.length;
            for (int i = this.start; i < this.start + this.length; ++i) {
                if (this.ch[i] != ':') continue;
                n2 = i + 1;
                n3 = this.length - (i - this.start) - 1;
                break;
            }
            this.name = new String(this.ch, n2, n3);
        } else {
            this.name = new String(this.ch, this.start, this.length);
        }
        return n;
    }

    private boolean partialParsing(String string) {
        return this.endTag != null && this.endTag.equals(string);
    }

    private int xmlInTag() throws Exception {
        int n = this.xmlGetNameTag();
        if (n < 0) {
            return 0;
        }
        if (n == 4) {
            int n2;
            char c = this.xmlGetString(3);
            int n3 = n2 = this.ch[this.start] == '\n' ? 1 : 0;
            if (this.length > 1) {
                this.ac.characters(this.ch, this.start + n2, this.length - n2);
            }
            return c != '\u0000' ? 1 : 0;
        }
        if (n == 5) {
            return this.xmlGetParamTag(-1) >= 0 ? 1 : 0;
        }
        char c = this.ch[this.start];
        if (c == '?' || c == '!') {
            return this.xmlGetParamTag(0) >= 0 ? 1 : 0;
        }
        if (n == 0) {
            n = this.xmlGetParamTag(1);
        } else if (n == 1) {
            this.param.clear();
        }
        if (n < 0) {
            return 0;
        }
        if (n == 3) {
            if (this.stack != null) {
                this.stack.push(this.name);
            }
            ++this.nstack;
            this.ac.startElement(this.name, this.param);
            if (this.stack != null) {
                this.stack.pop();
            }
            --this.nstack;
            this.ac.endElement(this.name);
            return this.partialParsing(this.name) ? -1 : 1;
        }
        if (n == 2) {
            String string;
            if (this.nstack == 0) {
                this.setError("Unexpected end tag (</" + this.name + ">)");
                return 0;
            }
            --this.nstack;
            if (this.stack != null && !(string = (String)this.stack.pop()).equals(this.name)) {
                this.setError("Tags unbalanced (<" + string + ">...</" + this.name + ">)");
                return 0;
            }
            this.ac.endElement(this.name);
            return this.partialParsing(this.name) ? -1 : 1;
        }
        if (this.stack != null) {
            this.stack.push(this.name);
        }
        ++this.nstack;
        this.ac.startElement(this.name, this.param);
        return 1;
    }

    private boolean xmlBeforeTag() throws Exception {
        while (true) {
            char c = this.xmlGetString(this.beforeXML ? 5 : 2);
            if (this.length > 0 && (this.length != 1 || this.ch[this.start] != ' ')) {
                this.ac.characters(this.ch, this.start, this.length);
            }
            if (this.beforeXML) {
                this.beforeXML = false;
                continue;
            }
            if (c == '\u001a') {
                return this.error == null;
            }
            switch (this.xmlInTag()) {
                case 0: {
                    return false;
                }
                case -1: {
                    this.xmlGetString(1);
                    return true;
                }
            }
        }
    }
}

