/*
 * Decompiled with CFR 0.152.
 */
package healpix.essentials;

import healpix.essentials.HealpixUtils;
import healpix.essentials.Vec3;

final class CircleFinder {
    private Vec3 center;
    private double cosrad;

    private void getCircle(Vec3[] vec3Array, int n, int n2) {
        this.center = vec3Array[n].add(vec3Array[n2]);
        this.center.normalize();
        this.cosrad = vec3Array[n].dot(this.center);
        for (int i = 0; i < n; ++i) {
            if (!(vec3Array[i].dot(this.center) < this.cosrad)) continue;
            this.center = vec3Array[n].sub(vec3Array[i]).cross(vec3Array[n2].sub(vec3Array[i]));
            this.center.normalize();
            this.cosrad = vec3Array[i].dot(this.center);
            if (!(this.cosrad < 0.0)) continue;
            this.center.flip();
            this.cosrad = -this.cosrad;
        }
    }

    private void getCircle(Vec3[] vec3Array, int n) {
        this.center = vec3Array[0].add(vec3Array[n]);
        this.center.normalize();
        this.cosrad = vec3Array[0].dot(this.center);
        for (int i = 1; i < n; ++i) {
            if (!(vec3Array[i].dot(this.center) < this.cosrad)) continue;
            this.getCircle(vec3Array, i, n);
        }
    }

    public CircleFinder(Vec3[] vec3Array) throws Exception {
        int n = vec3Array.length;
        HealpixUtils.check(n >= 3, "too few points");
        this.center = vec3Array[0].add(vec3Array[1]);
        this.center.normalize();
        this.cosrad = vec3Array[0].dot(this.center);
        for (int i = 2; i < n; ++i) {
            if (!(vec3Array[i].dot(this.center) < this.cosrad)) continue;
            this.getCircle(vec3Array, i);
        }
    }

    public Vec3 getCenter() {
        return new Vec3(this.center);
    }

    public double getCosrad() {
        return this.cosrad;
    }
}

