/*
 * Decompiled with CFR 0.152.
 */
package healpix.essentials;

import healpix.essentials.HealpixUtils;
import java.io.ByteArrayOutputStream;

public class Compressor {
    private static void interpol_encode2(long[] lArray, int n, int n2, obitstream obitstream2, int n3) throws Exception {
        if (n2 - n <= 1) {
            return;
        }
        int n4 = n + (n2 - n) / 2;
        long l = (lArray[n2] - lArray[n] >>> n3) - (long)(n2 - n) + 1L;
        if (l <= 1L) {
            return;
        }
        long l2 = (lArray[n4] >>> n3) - ((lArray[n] >>> n3) + (long)(n4 - n));
        int n5 = 1 + HealpixUtils.ilog2(l - 1L);
        long l3 = (1L << n5) - l;
        if (l2 < l3) {
            obitstream2.put(l2, n5 - 1);
        } else {
            obitstream2.put(l2 + l3, n5);
        }
        Compressor.interpol_encode2(lArray, n, n4, obitstream2, n3);
        Compressor.interpol_encode2(lArray, n4, n2, obitstream2, n3);
    }

    public static byte[] interpol_encode(long[] lArray, int n, int n2) throws Exception {
        int n3;
        obitstream obitstream2 = new obitstream();
        if (n >= n2) {
            obitstream2.put(0L, 8);
            return obitstream2.getData();
        }
        HealpixUtils.check(lArray[n] >= 0L, "numbers must be nonnegative");
        long l = lArray[n];
        for (n3 = n + 1; n3 < n2; ++n3) {
            HealpixUtils.check(lArray[n3 - 1] < lArray[n3], "numbers not strictly increasing");
            l |= lArray[n3];
        }
        n3 = Long.numberOfTrailingZeros(l);
        long l2 = lArray[n2 - 1] >>> n3;
        if ((long)(n2 - n) > l2) {
            l2 = n2 - n;
        }
        int n4 = 1 + HealpixUtils.ilog2(l2);
        obitstream2.put(n4, 8);
        obitstream2.put(n3, 8);
        obitstream2.put(n2 - n, n4);
        obitstream2.put(lArray[n] >>> n3, n4);
        if (n2 - n == 1) {
            return obitstream2.getData();
        }
        obitstream2.put(lArray[n2 - 1] >>> n3, n4);
        Compressor.interpol_encode2(lArray, n, n2 - 1, obitstream2, n3);
        return obitstream2.getData();
    }

    private static void interpol_decode2(long[] lArray, int n, int n2, ibitstream ibitstream2, int n3) throws Exception {
        if (n2 - n <= 1) {
            return;
        }
        int n4 = n + (n2 - n) / 2;
        long l = (lArray[n2] - lArray[n] >>> n3) - (long)(n2 - n) + 1L;
        long l2 = 0L;
        if (l > 1L) {
            int n5 = 1 + HealpixUtils.ilog2(l - 1L);
            long l3 = (1L << n5) - l;
            l2 = ibitstream2.get(n5 - 1);
            if (l2 >= l3) {
                l2 = (l2 << 1) + ibitstream2.get(1) - l3;
            }
        }
        lArray[n4] = lArray[n] + ((long)(n4 - n) + l2 << n3);
        Compressor.interpol_decode2(lArray, n, n4, ibitstream2, n3);
        Compressor.interpol_decode2(lArray, n4, n2, ibitstream2, n3);
    }

    public static long[] interpol_decode(byte[] byArray) throws Exception {
        ibitstream ibitstream2 = new ibitstream(byArray);
        int n = (int)ibitstream2.get(8);
        if (n == 0) {
            return new long[0];
        }
        int n2 = (int)ibitstream2.get(8);
        long[] lArray = new long[(int)ibitstream2.get(n)];
        lArray[0] = ibitstream2.get(n) << n2;
        if (lArray.length == 1) {
            return lArray;
        }
        lArray[lArray.length - 1] = ibitstream2.get(n) << n2;
        Compressor.interpol_decode2(lArray, 0, lArray.length - 1, ibitstream2, n2);
        return lArray;
    }

    private static final class ibitstream {
        private long bitpos;
        private int curval;
        private byte[] data;

        public ibitstream(byte[] byArray) throws Exception {
            HealpixUtils.check(byArray.length > 0, "empty input array");
            this.bitpos = 0L;
            this.data = (byte[])byArray.clone();
        }

        private long get_internal(long l, int n) {
            int n2 = 8 - (int)(this.bitpos & 7L);
            if (n2 == 8) {
                this.curval = this.data[(int)(this.bitpos >>> 3)];
                if (this.curval < 0) {
                    this.curval += 256;
                }
            }
            if (n <= n2) {
                l |= (long)(this.curval >>> n2 - n) & (1L << n) - 1L;
                this.bitpos += (long)n;
            } else {
                l |= ((long)this.curval & (1L << n2) - 1L) << n - n2;
                this.bitpos += (long)n2;
                l = this.get_internal(l, n - n2);
            }
            return l;
        }

        public long get(int n) throws Exception {
            if (n == 0) {
                return 0L;
            }
            HealpixUtils.check(n <= 63, "too many bits");
            HealpixUtils.check(this.bitpos + (long)n <= 8L * (long)this.data.length, "reading past end of stream");
            long l = 0L;
            return this.get_internal(l, n);
        }
    }

    private static final class obitstream {
        private long bitpos = 0L;
        private int curval = 0;
        private ByteArrayOutputStream strm = new ByteArrayOutputStream();

        private void put_internal(long l, int n) {
            int n2 = 8 - (int)(this.bitpos & 7L);
            if (n <= n2) {
                this.curval = (int)((long)this.curval | (l & (1L << n) - 1L) << n2 - n);
                this.bitpos += (long)n;
                if ((this.bitpos & 7L) == 0L) {
                    this.strm.write(this.curval);
                    this.curval = 0;
                }
            } else {
                this.curval = (int)((long)this.curval | l >>> n - n2 & (long)((1 << n2) - 1));
                this.bitpos += (long)n2;
                if ((this.bitpos & 7L) == 0L) {
                    this.strm.write(this.curval);
                    this.curval = 0;
                }
                this.put_internal(l, n - n2);
            }
        }

        public void put(long l, int n) throws Exception {
            if (n == 0) {
                return;
            }
            HealpixUtils.check(n <= 63, "too many bits");
            HealpixUtils.check(l - (l & (1L << n) - 1L) == 0L, "value has too many bits");
            this.put_internal(l, n);
        }

        public byte[] getData() throws Exception {
            if ((this.bitpos & 7L) != 0L) {
                this.strm.write(this.curval);
            }
            return this.strm.toByteArray();
        }
    }
}

