/*
 * Decompiled with CFR 0.152.
 */
package healpix.essentials;

public final class FastMath {
    private static final double PI4_A = 0.7853981554508209;
    private static final double PI4_B = 7.946627356147928E-9;
    private static final double PI4_C = 3.061616997868383E-17;
    private static final double M_1_PI = 0.3183098861837907;

    private static final double mulsign(double d, double d2) {
        return Math.copySign(1.0, d2) * d;
    }

    private static final boolean isnan(double d) {
        return d != d;
    }

    private static final boolean isinf(double d) {
        return Math.abs(d) == Double.POSITIVE_INFINITY;
    }

    private static final double sign(double d) {
        return Math.copySign(1.0, d);
    }

    private static final double atanhelper(double d) {
        double d2 = d * d;
        double d3 = -1.887960084630735E-5;
        d3 = d3 * d2 + 2.0985007664581698E-4;
        d3 = d3 * d2 + -0.0011061183148667248;
        d3 = d3 * d2 + 0.003700267441887131;
        d3 = d3 * d2 + -0.008898961958876555;
        d3 = d3 * d2 + 0.016599329773529202;
        d3 = d3 * d2 + -0.025451762493231264;
        d3 = d3 * d2 + 0.03378525800013531;
        d3 = d3 * d2 + -0.04076291912768365;
        d3 = d3 * d2 + 0.04666671500778406;
        d3 = d3 * d2 + -0.052367485230348246;
        d3 = d3 * d2 + 0.05876663929266736;
        d3 = d3 * d2 + -0.06665735793610805;
        d3 = d3 * d2 + 0.07692195383117696;
        d3 = d3 * d2 + -0.09090899500824501;
        d3 = d3 * d2 + 0.11111110564826142;
        d3 = d3 * d2 + -0.1428571426677133;
        d3 = d3 * d2 + 0.19999999999659127;
        d3 = d3 * d2 + -0.3333333333333111;
        return d3 * d2 * d + d;
    }

    private static final double atan2k(double d, double d2) {
        double d3 = 0.0;
        if (d2 < 0.0) {
            d2 = -d2;
            d3 = -2.0;
        }
        if (d > d2) {
            double d4 = d2;
            d2 = d;
            d = -d4;
            d3 += 1.0;
        }
        return FastMath.atanhelper(d / d2) + d3 * 1.5707963267948966;
    }

    public static final double atan2(double d, double d2) {
        double d3 = FastMath.atan2k(Math.abs(d), d2);
        d3 = FastMath.mulsign(d3, d2);
        if (FastMath.isinf(d2) || d2 == 0.0) {
            d3 = 1.5707963267948966 - (FastMath.isinf(d2) ? FastMath.sign(d2) * 1.5707963267948966 : 0.0);
        }
        if (FastMath.isinf(d)) {
            d3 = 1.5707963267948966 - (FastMath.isinf(d2) ? FastMath.sign(d2) * 0.7853981633974483 : 0.0);
        }
        if (d == 0.0) {
            d3 = FastMath.sign(d2) == -1.0 ? Math.PI : 0.0;
        }
        return FastMath.isnan(d2) || FastMath.isnan(d) ? Double.NaN : FastMath.mulsign(d3, d);
    }

    public static double asin(double d) {
        return FastMath.mulsign(FastMath.atan2k(Math.abs(d), Math.sqrt((1.0 + d) * (1.0 - d))), d);
    }

    public static double acos(double d) {
        return FastMath.mulsign(FastMath.atan2k(Math.sqrt((1.0 + d) * (1.0 - d)), Math.abs(d)), d) + (d < 0.0 ? Math.PI : 0.0);
    }

    public static final double atan(double d) {
        int n = 0;
        if (d < 0.0) {
            d = -d;
            n = 2;
        }
        if (d > 1.0) {
            d = 1.0 / d;
            n |= 1;
        }
        double d2 = FastMath.atanhelper(d);
        if ((n & 1) != 0) {
            d2 = 1.5707963267948966 - d2;
        }
        if ((n & 2) != 0) {
            d2 = -d2;
        }
        return d2;
    }

    private static final double sincoshelper(double d) {
        double d2 = d * d;
        double d3 = -7.972559550090379E-18;
        d3 = d3 * d2 + 2.810099727108632E-15;
        d3 = d3 * d2 - 7.647122191181588E-13;
        d3 = d3 * d2 + 1.605904306056645E-10;
        d3 = d3 * d2 - 2.5052108376350205E-8;
        d3 = d3 * d2 + 2.7557319223919875E-6;
        d3 = d3 * d2 - 1.9841269841269616E-4;
        d3 = d3 * d2 + 0.00833333333333333;
        d3 = d3 * d2 - 0.16666666666666666;
        return d2 * d3 * d + d;
    }

    public static final double sin(double d) {
        double d2 = d * 0.3183098861837907;
        long l = (long)(d2 < 0.0 ? d2 - 0.5 : d2 + 0.5);
        double d3 = 4.0 * (double)l;
        d -= d3 * 0.7853981554508209;
        d -= d3 * 7.946627356147928E-9;
        d -= d3 * 3.061616997868383E-17;
        if ((l & 1L) != 0L) {
            d = -d;
        }
        return FastMath.sincoshelper(d);
    }

    public static final double cos(double d) {
        double d2 = d * 0.3183098861837907 - 0.5;
        long l = 1L + 2L * (long)(d2 < 0.0 ? d2 - 0.5 : d2 + 0.5);
        double d3 = 2.0 * (double)l;
        d -= d3 * 0.7853981554508209;
        d -= d3 * 7.946627356147928E-9;
        d -= d3 * 3.061616997868383E-17;
        if ((l & 2L) == 0L) {
            d = -d;
        }
        return FastMath.sincoshelper(d);
    }
}

