/*
 * Decompiled with CFR 0.152.
 */
package healpix.essentials;

import healpix.essentials.HealpixTables;
import healpix.essentials.HealpixUtils;
import healpix.essentials.Hploc;
import healpix.essentials.Vec3;

public final class Fxyf
extends HealpixTables {
    public double fx;
    public double fy;
    public int face;

    public Fxyf(double d, double d2, int n) {
        this.fx = d;
        this.fy = d2;
        this.face = n;
    }

    protected Fxyf(Hploc hploc) {
        double d = hploc.z;
        double d2 = hploc.phi;
        double d3 = Math.abs(d);
        double d4 = HealpixUtils.fmodulo(d2 * 0.6366197723675814, 4.0);
        if (d3 <= 0.6666666666666666) {
            double d5 = 0.5 + d4;
            double d6 = d * 0.75;
            double d7 = d5 - d6;
            long l = (long)d7;
            double d8 = d5 + d6;
            long l2 = (long)d8;
            long l3 = l == l2 ? l | 4L : (l < l2 ? l : l2 + 8L);
            this.fx = HealpixUtils.fmodulo(d8, 1.0);
            this.fy = 1.0 - HealpixUtils.fmodulo(d7, 1.0);
            this.face = (int)l3;
        } else {
            int n = Math.min(3, (int)d4);
            double d9 = d4 - (double)n;
            double d10 = d3 < 0.99 || !hploc.have_sth ? Math.sqrt(3.0 * (1.0 - d3)) : hploc.sth / Math.sqrt((1.0 + d3) / 3.0);
            double d11 = d9 * d10;
            double d12 = (1.0 - d9) * d10;
            if (d11 >= 1.0) {
                d11 = 1.0;
            }
            if (d12 >= 1.0) {
                d12 = 1.0;
            }
            if (d >= 0.0) {
                this.fx = 1.0 - d12;
                this.fy = 1.0 - d11;
                this.face = n;
            } else {
                this.fx = d11;
                this.fy = d12;
                this.face = n + 8;
            }
        }
    }

    public Fxyf(Vec3 vec3) {
        this(new Hploc(vec3));
    }

    protected Hploc toHploc() {
        double d;
        double d2;
        Hploc hploc = new Hploc();
        double d3 = (double)jrll[this.face] - this.fx - this.fy;
        if (d3 < 1.0) {
            d2 = d3;
            d = d2 * d2 / 3.0;
            hploc.z = 1.0 - d;
            if (hploc.z > 0.99) {
                hploc.sth = Math.sqrt(d * (2.0 - d));
                hploc.have_sth = true;
            }
        } else if (d3 > 3.0) {
            d2 = 4.0 - d3;
            d = d2 * d2 / 3.0;
            hploc.z = d - 1.0;
            if (hploc.z < -0.99) {
                hploc.sth = Math.sqrt(d * (2.0 - d));
                hploc.have_sth = true;
            }
        } else {
            d2 = 1.0;
            hploc.z = (2.0 - d3) * 2.0 / 3.0;
        }
        d = (double)jpll[this.face] * d2 + this.fx - this.fy;
        if (d < 0.0) {
            d += 8.0;
        }
        if (d >= 8.0) {
            d -= 8.0;
        }
        hploc.phi = d2 < 1.0E-15 ? 0.0 : 0.7853981633974483 * d / d2;
        return hploc;
    }

    public Vec3 toVec3() {
        return this.toHploc().toVec3();
    }
}

