/*
 * Decompiled with CFR 0.152.
 */
package healpix.essentials;

import healpix.essentials.CircleFinder;
import healpix.essentials.FastMath;
import healpix.essentials.Fxyf;
import healpix.essentials.HealpixProc;
import healpix.essentials.HealpixTables;
import healpix.essentials.HealpixUtils;
import healpix.essentials.Hploc;
import healpix.essentials.Pointing;
import healpix.essentials.RangeSet;
import healpix.essentials.Scheme;
import healpix.essentials.Vec3;
import healpix.essentials.Zphi;
import java.util.Arrays;

public class HealpixBase
extends HealpixTables {
    public static final int order_max = 29;
    public static final long ns_max = 0x20000000L;
    protected int order;
    protected long nside;
    protected long nl2;
    protected long nl3;
    protected long nl4;
    protected long npface;
    protected long npix;
    protected long ncap;
    protected double fact1;
    protected double fact2;
    protected Scheme scheme;

    private static long spread_bits(int n) {
        return (long)utab[n & 0xFF] | (long)utab[n >>> 8 & 0xFF] << 16 | (long)utab[n >>> 16 & 0xFF] << 32 | (long)utab[n >>> 24 & 0xFF] << 48;
    }

    private static int compress_bits(long l) {
        long l2 = l & 0x5555555555555555L;
        l2 |= l2 >>> 15;
        int n = (int)(l2 & 0xFFFFL);
        int n2 = (int)(l2 >>> 32 & 0xFFFFL);
        return ctab[n & 0xFF] | ctab[n >>> 8] << 4 | ctab[n2 & 0xFF] << 16 | ctab[n2 >>> 8] << 20;
    }

    private Xyf nest2xyf(long l) {
        long l2 = l & this.npface - 1L;
        return new Xyf(HealpixBase.compress_bits(l2), HealpixBase.compress_bits(l2 >>> 1), (int)(l >>> 2 * this.order));
    }

    private long xyf2nest(int n, int n2, int n3) {
        return ((long)n3 << 2 * this.order) + HealpixBase.spread_bits(n) + (HealpixBase.spread_bits(n2) << 1);
    }

    private long xyf2ring(int n, int n2, int n3) {
        long l = (long)jrll[n3] * this.nside - (long)n - (long)n2 - 1L;
        RingInfoSmall ringInfoSmall = this.get_ring_info_small(l);
        long l2 = ringInfoSmall.ringpix >>> 2;
        long l3 = ringInfoSmall.shifted ? 0L : 1L;
        long l4 = ((long)jpll[n3] * l2 + (long)n - (long)n2 + 1L + l3) / 2L;
        if (l4 > this.nl4) {
            l4 -= this.nl4;
        } else if (l4 < 1L) {
            l4 += this.nl4;
        }
        return ringInfoSmall.startpix + l4 - 1L;
    }

    protected Xyf ring2xyf(long l) {
        long l2;
        long l3;
        long l4;
        long l5;
        long l6;
        long l7;
        Xyf xyf = new Xyf();
        if (l < this.ncap) {
            l7 = 1 + HealpixUtils.isqrt(1L + 2L * l) >>> 1;
            l6 = l + 1L - 2L * l7 * (l7 - 1L);
            l5 = 0L;
            l4 = l7;
            xyf.face = (int)((l6 - 1L) / l4);
        } else if (l < this.npix - this.ncap) {
            l3 = l - this.ncap;
            l2 = this.order >= 0 ? l3 >>> this.order + 2 : l3 / this.nl4;
            l7 = l2 + this.nside;
            l6 = l3 - l2 * this.nl4 + 1L;
            l5 = l7 + this.nside & 1L;
            l4 = this.nside;
            long l8 = l7 - this.nside + 1L;
            long l9 = this.nl2 + 2L - l8;
            long l10 = l6 - (l8 >>> 1) + this.nside - 1L;
            long l11 = l6 - (l9 >>> 1) + this.nside - 1L;
            if (this.order >= 0) {
                l10 >>>= this.order;
                l11 >>>= this.order;
            } else {
                l10 /= this.nside;
                l11 /= this.nside;
            }
            xyf.face = (int)(l11 == l10 ? l11 | 4L : (l11 < l10 ? l11 : l10 + 8L));
        } else {
            l3 = this.npix - l;
            l7 = 1 + HealpixUtils.isqrt(2L * l3 - 1L) >>> 1;
            l6 = 4L * l7 + 1L - (l3 - 2L * l7 * (l7 - 1L));
            l5 = 0L;
            l4 = l7;
            l7 = 2L * this.nl2 - l7;
            xyf.face = 8 + (int)((l6 - 1L) / l4);
        }
        l3 = l7 - (long)jrll[xyf.face] * this.nside + 1L;
        l2 = 2L * l6 - (long)jpll[xyf.face] * l4 - l5 - 1L;
        if (l2 >= this.nl2) {
            l2 -= 8L * this.nside;
        }
        xyf.ix = (int)(l2 - l3 >>> 1);
        xyf.iy = (int)(-l2 - l3 >>> 1);
        return xyf;
    }

    protected Xyf pix2xyf(long l) {
        return this.scheme == Scheme.RING ? this.ring2xyf(l) : this.nest2xyf(l);
    }

    protected long xyf2pix(int n, int n2, int n3) {
        return this.scheme == Scheme.RING ? this.xyf2ring(n, n2, n3) : this.xyf2nest(n, n2, n3);
    }

    protected long xyf2pix(Xyf xyf) {
        return this.scheme == Scheme.RING ? this.xyf2ring(xyf.ix, xyf.iy, xyf.face) : this.xyf2nest(xyf.ix, xyf.iy, xyf.face);
    }

    public static int nside2order(long l) throws Exception {
        HealpixUtils.check(l > 0L, "nside must be positive");
        return (l & l - 1L) != 0L ? -1 : HealpixUtils.ilog2(l);
    }

    public static long npix2Nside(long l) throws Exception {
        HealpixUtils.check(l > 0L, "npix must be positive");
        long l2 = HealpixUtils.isqrt(l / 12L);
        HealpixUtils.check(12L * l2 * l2 == l, "npix is not 12*nside*nside");
        HealpixUtils.check(l2 <= 0x20000000L, "nside is too large");
        return l2;
    }

    public static long nside2Npix(long l) throws Exception {
        HealpixUtils.check(l > 0L, "nside must be positive");
        HealpixUtils.check(l <= 0x20000000L, "nside is too large");
        return 12L * l * l;
    }

    public static long order2Npix(int n) throws Exception {
        HealpixUtils.check(n >= 0, "order must be nonnegative");
        HealpixUtils.check(n <= 29, "order is too large");
        return 12L * (1L << 2 * n);
    }

    public void setNside(long l) throws Exception {
        if (this.nside == l) {
            return;
        }
        this.nside = l;
        HealpixUtils.check(this.nside <= 0x20000000L && this.nside > 0L, "Nside must be between 1 and 536870912");
        this.order = HealpixBase.nside2order(this.nside);
        if (this.scheme == Scheme.NESTED && this.order < 0) {
            throw new Exception("Nside must be a power of 2 for NESTED scheme");
        }
        this.nl2 = 2L * this.nside;
        this.nl3 = 3L * this.nside;
        this.nl4 = 4L * this.nside;
        this.npface = this.nside * this.nside;
        this.ncap = 2L * this.nside * (this.nside - 1L);
        this.npix = 12L * this.npface;
        this.fact2 = 4.0 / (double)this.npix;
        this.fact1 = (double)(this.nside << 1) * this.fact2;
    }

    public void setNsideAndScheme(long l, Scheme scheme) throws Exception {
        if (this.scheme == scheme && this.nside == l) {
            return;
        }
        HealpixUtils.check((l & l - 1L) == 0L || scheme == Scheme.RING, "Nside must be a power of 2 for NESTED scheme");
        this.scheme = scheme;
        this.setNside(l);
    }

    public HealpixBase() {
        try {
            this.nside = 0L;
            this.setNsideAndScheme(1L, Scheme.NESTED);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public HealpixBase(long l, Scheme scheme) throws Exception {
        this.nside = l - 1L;
        this.setNsideAndScheme(l, scheme);
    }

    public Scheme getScheme() {
        return this.scheme;
    }

    public int getNside() {
        return (int)this.nside;
    }

    public long getNpix() {
        return this.npix;
    }

    public void setScheme(Scheme scheme) throws Exception {
        if (scheme == Scheme.NESTED && this.order < 0) {
            throw new Exception("Nside must be a power of 2 for NESTED scheme");
        }
        this.scheme = scheme;
    }

    public int getOrder() {
        return this.order;
    }

    public long ang2pix(Pointing pointing) throws Exception {
        return this.loc2pix(new Hploc(pointing));
    }

    public Pointing pix2ang(long l) throws Exception {
        return this.pix2loc(l).toPointing();
    }

    public long vec2pix(Vec3 vec3) throws Exception {
        return this.loc2pix(new Hploc(vec3));
    }

    public Vec3 pix2vec(long l) throws Exception {
        return this.pix2loc(l).toVec3();
    }

    public long ring2nest(long l) throws Exception {
        Xyf xyf = this.ring2xyf(l);
        return this.xyf2nest(xyf.ix, xyf.iy, xyf.face);
    }

    public long nest2ring(long l) throws Exception {
        Xyf xyf = this.nest2xyf(l);
        return this.xyf2ring(xyf.ix, xyf.iy, xyf.face);
    }

    protected long loc2pix(Hploc hploc) {
        double d = hploc.z;
        double d2 = hploc.phi;
        double d3 = Math.abs(d);
        double d4 = HealpixUtils.fmodulo(d2 * 0.6366197723675814, 4.0);
        if (this.scheme == Scheme.RING) {
            if (d3 <= 0.6666666666666666) {
                double d5 = (double)this.nside * (0.5 + d4);
                double d6 = (double)this.nside * d * 0.75;
                long l = (long)(d5 - d6);
                long l2 = (long)(d5 + d6);
                long l3 = this.nside + 1L + l - l2;
                long l4 = 1L - (l3 & 1L);
                long l5 = l + l2 - this.nside + l4 + 1L + this.nl4 + this.nl4;
                long l6 = this.order > 0 ? l5 >>> 1 & this.nl4 - 1L : (l5 >>> 1) % this.nl4;
                return this.ncap + (l3 - 1L) * this.nl4 + l6;
            }
            double d7 = d4 - (double)((long)d4);
            double d8 = d3 < 0.99 || !hploc.have_sth ? (double)this.nside * Math.sqrt(3.0 * (1.0 - d3)) : (double)this.nside * hploc.sth / Math.sqrt((1.0 + d3) / 3.0);
            long l = (long)(d7 * d8);
            long l7 = (long)((1.0 - d7) * d8);
            long l8 = l + l7 + 1L;
            long l9 = (long)(d4 * (double)l8);
            assert (l9 >= 0L && l9 < 4L * l8);
            return d > 0.0 ? 2L * l8 * (l8 - 1L) + l9 : this.npix - 2L * l8 * (l8 + 1L) + l9;
        }
        if (d3 <= 0.6666666666666666) {
            double d9 = (double)this.nside * (0.5 + d4);
            double d10 = (double)this.nside * (d * 0.75);
            long l = (long)(d9 - d10);
            long l10 = l >>> this.order;
            long l11 = (long)(d9 + d10);
            long l12 = l11 >>> this.order;
            long l13 = l10 == l12 ? l10 | 4L : (l10 < l12 ? l10 : l12 + 8L);
            long l14 = l11 & this.nside - 1L;
            long l15 = this.nside - (l & this.nside - 1L) - 1L;
            return this.xyf2nest((int)l14, (int)l15, (int)l13);
        }
        int n = Math.min(3, (int)d4);
        double d11 = d4 - (double)n;
        double d12 = d3 < 0.99 || !hploc.have_sth ? (double)this.nside * Math.sqrt(3.0 * (1.0 - d3)) : (double)this.nside * hploc.sth / Math.sqrt((1.0 + d3) / 3.0);
        long l = (long)(d11 * d12);
        long l16 = (long)((1.0 - d11) * d12);
        if (l >= this.nside) {
            l = this.nside - 1L;
        }
        if (l16 >= this.nside) {
            l16 = this.nside - 1L;
        }
        return d >= 0.0 ? this.xyf2nest((int)(this.nside - l16 - 1L), (int)(this.nside - l - 1L), n) : this.xyf2nest((int)l, (int)l16, n + 8);
    }

    public long zphi2pix(Zphi zphi) {
        return this.loc2pix(new Hploc(zphi));
    }

    protected Hploc pix2loc(long l) {
        Hploc hploc = new Hploc();
        if (this.scheme == Scheme.RING) {
            if (l < this.ncap) {
                long l2 = 1 + HealpixUtils.isqrt(1L + 2L * l) >>> 1;
                long l3 = l + 1L - 2L * l2 * (l2 - 1L);
                double d = (double)(l2 * l2) * this.fact2;
                hploc.z = 1.0 - d;
                if (hploc.z > 0.99) {
                    hploc.sth = Math.sqrt(d * (2.0 - d));
                    hploc.have_sth = true;
                }
                hploc.phi = ((double)l3 - 0.5) * 1.5707963267948966 / (double)l2;
            } else if (l < this.npix - this.ncap) {
                long l4 = l - this.ncap;
                long l5 = this.order >= 0 ? l4 >>> this.order + 2 : l4 / this.nl4;
                long l6 = l5 + this.nside;
                long l7 = l4 - this.nl4 * l5 + 1L;
                double d = (l6 + this.nside & 1L) != 0L ? 1.0 : 0.5;
                hploc.z = (double)(this.nl2 - l6) * this.fact1;
                hploc.phi = ((double)l7 - d) * Math.PI * 0.75 * this.fact1;
            } else {
                long l8 = this.npix - l;
                long l9 = 1 + HealpixUtils.isqrt(2L * l8 - 1L) >>> 1;
                long l10 = 4L * l9 + 1L - (l8 - 2L * l9 * (l9 - 1L));
                double d = (double)(l9 * l9) * this.fact2;
                hploc.z = d - 1.0;
                if (hploc.z < -0.99) {
                    hploc.sth = Math.sqrt(d * (2.0 - d));
                    hploc.have_sth = true;
                }
                hploc.phi = ((double)l10 - 0.5) * 1.5707963267948966 / (double)l9;
            }
        } else {
            double d;
            long l11;
            Xyf xyf = this.nest2xyf(l);
            long l12 = ((long)jrll[xyf.face] << this.order) - (long)xyf.ix - (long)xyf.iy - 1L;
            if (l12 < this.nside) {
                l11 = l12;
                d = (double)(l11 * l11) * this.fact2;
                hploc.z = 1.0 - d;
                if (hploc.z > 0.99) {
                    hploc.sth = Math.sqrt(d * (2.0 - d));
                    hploc.have_sth = true;
                }
            } else if (l12 > this.nl3) {
                l11 = this.nl4 - l12;
                d = (double)(l11 * l11) * this.fact2;
                hploc.z = d - 1.0;
                if (hploc.z < -0.99) {
                    hploc.sth = Math.sqrt(d * (2.0 - d));
                    hploc.have_sth = true;
                }
            } else {
                l11 = this.nside;
                hploc.z = (double)(this.nl2 - l12) * this.fact1;
            }
            long l13 = (long)jpll[xyf.face] * l11 + (long)xyf.ix - (long)xyf.iy;
            assert (l13 < 8L * l11);
            if (l13 < 0L) {
                l13 += 8L * l11;
            }
            hploc.phi = l11 == this.nside ? 1.1780972450961724 * (double)l13 * this.fact1 : 0.7853981633974483 * (double)l13 / (double)l11;
        }
        return hploc;
    }

    public Zphi pix2zphi(long l) {
        return this.pix2loc(l).toZphi();
    }

    public long[] neighbours(long l) throws Exception {
        long[] lArray = new long[8];
        Xyf xyf = this.scheme == Scheme.NESTED ? this.nest2xyf(l) : this.ring2xyf(l);
        int n = xyf.ix;
        int n2 = xyf.iy;
        int n3 = xyf.face;
        long l2 = this.nside - 1L;
        if (n > 0 && (long)n < l2 && n2 > 0 && (long)n2 < l2) {
            if (this.scheme == Scheme.RING) {
                for (int i = 0; i < 8; ++i) {
                    lArray[i] = this.xyf2ring(n + xoffset[i], n2 + yoffset[i], n3);
                }
            } else {
                long l3 = (long)n3 << 2 * this.order;
                long l4 = HealpixBase.spread_bits(n);
                long l5 = HealpixBase.spread_bits(n2) << 1;
                long l6 = HealpixBase.spread_bits(n + 1);
                long l7 = HealpixBase.spread_bits(n2 + 1) << 1;
                long l8 = HealpixBase.spread_bits(n - 1);
                long l9 = HealpixBase.spread_bits(n2 - 1) << 1;
                lArray[0] = l3 + l8 + l5;
                lArray[1] = l3 + l8 + l7;
                lArray[2] = l3 + l4 + l7;
                lArray[3] = l3 + l6 + l7;
                lArray[4] = l3 + l6 + l5;
                lArray[5] = l3 + l6 + l9;
                lArray[6] = l3 + l4 + l9;
                lArray[7] = l3 + l8 + l9;
            }
        } else {
            for (int i = 0; i < 8; ++i) {
                int n4 = n + xoffset[i];
                int n5 = n2 + yoffset[i];
                int n6 = 4;
                if (n4 < 0) {
                    n4 = (int)((long)n4 + this.nside);
                    --n6;
                } else if ((long)n4 >= this.nside) {
                    n4 = (int)((long)n4 - this.nside);
                    ++n6;
                }
                if (n5 < 0) {
                    n5 = (int)((long)n5 + this.nside);
                    n6 -= 3;
                } else if ((long)n5 >= this.nside) {
                    n5 = (int)((long)n5 - this.nside);
                    n6 += 3;
                }
                short s = facearray[n6][n3];
                if (s >= 0) {
                    byte by = swaparray[n6][n3 >>> 2];
                    if ((by & 1) > 0) {
                        n4 = (int)(this.nside - (long)n4 - 1L);
                    }
                    if ((by & 2) > 0) {
                        n5 = (int)(this.nside - (long)n5 - 1L);
                    }
                    if ((by & 4) > 0) {
                        int n7 = n4;
                        n4 = n5;
                        n5 = n7;
                    }
                    lArray[i] = this.scheme == Scheme.NESTED ? this.xyf2nest(n4, n5, s) : this.xyf2ring(n4, n5, s);
                    continue;
                }
                lArray[i] = -1L;
            }
        }
        return lArray;
    }

    public double maxPixrad() {
        Vec3 vec3 = new Vec3(new Zphi(0.6666666666666666, Math.PI / (double)this.nl4));
        double d = 1.0 - 1.0 / (double)this.nside;
        d *= d;
        Vec3 vec32 = new Vec3(new Zphi(1.0 - d / 3.0, 0.0));
        return vec3.angle(vec32);
    }

    private RingInfoSmall get_ring_info_small(long l) {
        RingInfoSmall ringInfoSmall = new RingInfoSmall();
        if (l < this.nside) {
            ringInfoSmall.shifted = true;
            ringInfoSmall.ringpix = 4L * l;
            ringInfoSmall.startpix = 2L * l * (l - 1L);
        } else if (l < this.nl3) {
            ringInfoSmall.shifted = (l - this.nside & 1L) == 0L;
            ringInfoSmall.ringpix = this.nl4;
            ringInfoSmall.startpix = this.ncap + (l - this.nside) * this.nl4;
        } else {
            ringInfoSmall.shifted = true;
            long l2 = this.nl4 - l;
            ringInfoSmall.ringpix = 4L * l2;
            ringInfoSmall.startpix = this.npix - 2L * l2 * (l2 + 1L);
        }
        return ringInfoSmall;
    }

    private long ringAbove(double d) {
        double d2 = Math.abs(d);
        if (d2 > 0.6666666666666666) {
            long l = (long)((double)this.nside * Math.sqrt(3.0 * (1.0 - d2)));
            return d > 0.0 ? l : this.nl4 - l - 1L;
        }
        return (long)((double)this.nside * (2.0 - 1.5 * d));
    }

    public double ring2z(long l) {
        if (l < this.nside) {
            return 1.0 - (double)(l * l) * this.fact2;
        }
        if (l <= this.nl3) {
            return (double)(this.nl2 - l) * this.fact1;
        }
        l = this.nl4 - l;
        return (double)(l * l) * this.fact2 - 1.0;
    }

    public double ring2theta(long l) {
        if (l < this.nside) {
            double d = (double)(l * l) * this.fact2;
            return FastMath.atan2(Math.sqrt(d * (2.0 - d)), 1.0 - d);
        }
        if (l <= this.nl3) {
            double d = (double)(this.nl2 - l) * this.fact1;
            return FastMath.atan2(Math.sqrt(1.0 - d * d), d);
        }
        l = this.nl4 - l;
        double d = (double)(l * l) * this.fact2;
        return FastMath.atan2(Math.sqrt(d * (2.0 - d)), d - 1.0);
    }

    private RangeSet queryStripInternal(double d, double d2, boolean bl) throws Exception {
        RangeSet rangeSet = new RangeSet(1);
        if (this.scheme == Scheme.RING) {
            long l = Math.max(1L, 1L + this.ringAbove(FastMath.cos(d)));
            long l2 = Math.min(4L * this.nside - 1L, this.ringAbove(FastMath.cos(d2)));
            if (bl) {
                l = Math.max(1L, l - 1L);
                l2 = Math.min(4L * this.nside - 1L, l2 + 1L);
            }
            RingInfoSmall ringInfoSmall = this.get_ring_info_small(l);
            RingInfoSmall ringInfoSmall2 = this.get_ring_info_small(l2);
            long l3 = ringInfoSmall.startpix;
            long l4 = ringInfoSmall2.startpix + ringInfoSmall2.ringpix;
            if (l3 < l4) {
                rangeSet.append(l3, l4);
            }
        } else {
            HealpixUtils.check(false, "queryStrip not yet implemented for NESTED");
        }
        return rangeSet;
    }

    public RangeSet queryStrip(double d, double d2, boolean bl) throws Exception {
        if (d < d2) {
            return this.queryStripInternal(d, d2, bl);
        }
        RangeSet rangeSet = this.queryStripInternal(0.0, d2, bl);
        return rangeSet.union(this.queryStripInternal(d, Math.PI, bl));
    }

    private boolean checkPixelRing(HealpixBase healpixBase, long l, long l2, long l3, int n, Zphi zphi, double d, long l4) {
        if (l >= l2) {
            l -= l2;
        }
        if (l < 0L) {
            l += l2;
        }
        if ((l += l3) == l4) {
            return false;
        }
        Xyf xyf = this.pix2xyf(l);
        for (int i = 0; i < n - 1; ++i) {
            int n2 = n * xyf.ix;
            int n3 = n * xyf.iy;
            Xyf xyf2 = new Xyf(n2, n3, xyf.face);
            xyf2.ix = n2 + i;
            xyf2.iy = n3;
            if (HealpixUtils.cosdist_zphi(zphi, healpixBase.pix2zphi(healpixBase.xyf2pix(xyf2))) > d) {
                return false;
            }
            xyf2.ix = n2 + n - 1;
            xyf2.iy = n3 + i;
            if (HealpixUtils.cosdist_zphi(zphi, healpixBase.pix2zphi(healpixBase.xyf2pix(xyf2))) > d) {
                return false;
            }
            xyf2.ix = n2 + n - 1 - i;
            xyf2.iy = n3 + n - 1;
            if (HealpixUtils.cosdist_zphi(zphi, healpixBase.pix2zphi(healpixBase.xyf2pix(xyf2))) > d) {
                return false;
            }
            xyf2.ix = n2;
            xyf2.iy = n3 + n - 1 - i;
            if (!(HealpixUtils.cosdist_zphi(zphi, healpixBase.pix2zphi(healpixBase.xyf2pix(xyf2))) > d)) continue;
            return false;
        }
        return true;
    }

    private RangeSet queryDiscInternal(Pointing pointing, double d, int n) throws Exception {
        boolean bl = n != 0;
        RangeSet rangeSet = new RangeSet();
        if (this.scheme == Scheme.RING) {
            double d2;
            double d3;
            int n2 = 1;
            if (bl) {
                HealpixUtils.check(0x20000000L / this.nside >= (long)n, "invalid oversampling factor");
                n2 = n;
            }
            HealpixBase healpixBase = null;
            if (n2 > 1) {
                healpixBase = new HealpixBase((long)n2 * this.nside, Scheme.RING);
                d3 = d + healpixBase.maxPixrad();
                d2 = d + this.maxPixrad();
            } else {
                d2 = bl ? d + this.maxPixrad() : d;
                d3 = d2;
            }
            if (d3 >= Math.PI) {
                rangeSet.append(0L, this.npix);
                return rangeSet;
            }
            d2 = Math.min(Math.PI, d2);
            double d4 = FastMath.cos(d3);
            double d5 = FastMath.cos(d2);
            double d6 = FastMath.cos(pointing.theta);
            double d7 = 1.0 / Math.sqrt((1.0 - d6) * (1.0 + d6));
            Zphi zphi = new Zphi(d6, pointing.phi);
            long l = this.zphi2pix(zphi);
            double d8 = pointing.theta - d3;
            double d9 = FastMath.cos(d8);
            long l2 = this.ringAbove(d9) + 1L;
            if (d8 <= 0.0 && l2 > 1L) {
                RingInfoSmall ringInfoSmall = this.get_ring_info_small(l2 - 1L);
                rangeSet.append(0L, ringInfoSmall.startpix + ringInfoSmall.ringpix);
            }
            if (n2 > 1 && d8 > 0.0) {
                l2 = Math.max(1L, l2 - 1L);
            }
            double d10 = pointing.theta + d3;
            double d11 = FastMath.cos(d10);
            long l3 = this.ringAbove(d11);
            if (n2 > 1 && d10 < Math.PI) {
                l3 = Math.min(this.nl4 - 1L, l3 + 1L);
            }
            for (long i = l2; i <= l3; ++i) {
                long l4;
                double d12 = this.ring2z(i);
                double d13 = (d5 - d12 * d6) * d7;
                double d14 = 1.0 - d12 * d12 - d13 * d13;
                double d15 = -1.0;
                d15 = d14 <= 0.0 ? (n2 == 1 ? 0.0 : 3.1415926535897922) : FastMath.atan2(Math.sqrt(d14), d13);
                if (!(d15 > 0.0)) continue;
                RingInfoSmall ringInfoSmall = this.get_ring_info_small(i);
                long l5 = ringInfoSmall.startpix;
                long l6 = ringInfoSmall.ringpix;
                long l7 = l5 + l6 - 1L;
                double d16 = ringInfoSmall.shifted ? 0.5 : 0.0;
                long l8 = (long)Math.floor((double)l6 * 0.15915494309189535 * (pointing.phi + d15) - d16);
                if (n2 > 1) {
                    for (l4 = (long)Math.floor((double)l6 * 0.15915494309189535 * (pointing.phi - d15) - d16) + 1L; l4 <= l8 && this.checkPixelRing(healpixBase, l4, l6, l5, n2, zphi, d4, l); ++l4) {
                    }
                    while (l8 > l4 && this.checkPixelRing(healpixBase, l8, l6, l5, n2, zphi, d4, l)) {
                        --l8;
                    }
                }
                if (l4 > l8) continue;
                if (l8 >= l6) {
                    l4 -= l6;
                    l8 -= l6;
                }
                if (l4 < 0L) {
                    rangeSet.append(l5, l5 + l8 + 1L);
                    rangeSet.append(l5 + l4 + l6, l7 + 1L);
                    continue;
                }
                rangeSet.append(l5 + l4, l5 + l8 + 1L);
            }
            if (d10 >= Math.PI && l3 + 1L < this.nl4) {
                RingInfoSmall ringInfoSmall = this.get_ring_info_small(l3 + 1L);
                rangeSet.append(ringInfoSmall.startpix, this.npix);
            }
        } else {
            double d17;
            if (d >= Math.PI) {
                rangeSet.append(0L, this.npix);
                return rangeSet;
            }
            int n3 = 0;
            if (bl) {
                HealpixUtils.check(0x20000000L >= (long)n, "invalid oversampling factor");
                HealpixUtils.check((n & n - 1) == 0, "oversampling factor must be a power of 2");
                n3 = HealpixUtils.ilog2(n);
            }
            int n4 = Math.min(29, this.order + n3);
            Vec3 vec3 = new Vec3(pointing);
            double[] dArray = new double[n4 + 1];
            double[] dArray2 = new double[n4 + 1];
            double d18 = FastMath.cos(d);
            double d19 = FastMath.sin(d);
            for (int i = 0; i <= n4; ++i) {
                double d20 = HealpixProc.mpr[i];
                double d21 = HealpixProc.cmpr[i];
                d17 = HealpixProc.smpr[i];
                dArray[i] = d + d20 > Math.PI ? -1.0 : d18 * d21 - d19 * d17;
                dArray2[i] = d - d20 < 0.0 ? 1.0 : d18 * d21 + d19 * d17;
            }
            pstack pstack2 = new pstack(12 + 3 * n4);
            for (int i = 0; i < 12; ++i) {
                pstack2.push(11 - i, 0);
            }
            while (pstack2.size() > 0) {
                long l = pstack2.ptop();
                int n5 = pstack2.otop();
                pstack2.pop();
                Zphi zphi = HealpixProc.bn[n5].pix2zphi(l);
                d17 = HealpixUtils.cosdist_zphi(vec3.z, pointing.phi, zphi.z, zphi.phi);
                if (!(d17 > dArray[n5])) continue;
                int n6 = d17 < d18 ? 1 : (d17 <= dArray2[n5] ? 2 : 3);
                this.check_pixel(n5, n4, n6, rangeSet, l, pstack2, bl);
            }
        }
        return rangeSet;
    }

    public RangeSet queryDisc(Pointing pointing, double d) throws Exception {
        return this.queryDiscInternal(pointing, d, 0);
    }

    public RangeSet queryDiscInclusive(Pointing pointing, double d, int n) throws Exception {
        return this.queryDiscInternal(pointing, d, n);
    }

    private RangeSet queryMultiDisc(Vec3[] vec3Array, double[] dArray, int n) throws Exception {
        boolean bl = n != 0;
        int n2 = vec3Array.length;
        HealpixUtils.check(n2 == dArray.length, "inconsistent input arrays");
        RangeSet rangeSet = new RangeSet();
        if (this.scheme == Scheme.RING) {
            double d;
            double d2;
            int n3 = 1;
            if (bl) {
                HealpixUtils.check(0x20000000L / this.nside >= (long)n, "invalid oversampling factor");
                n3 = n;
            }
            HealpixBase healpixBase = null;
            if (n3 > 1) {
                healpixBase = new HealpixBase((long)n3 * this.nside, Scheme.RING);
                d2 = healpixBase.maxPixrad();
                d = this.maxPixrad();
            } else {
                d = bl ? this.maxPixrad() : 0.0;
                d2 = d;
            }
            long l = 1L;
            long l2 = this.nl4 - 1L;
            int n4 = 0;
            double[] dArray2 = new double[n2];
            double[] dArray3 = new double[n2];
            double[] dArray4 = new double[n2];
            double[] dArray5 = new double[n2];
            Pointing[] pointingArray = new Pointing[n2];
            long[] lArray = new long[n2];
            Zphi[] zphiArray = new Zphi[n2];
            for (int i = 0; i < n2; ++i) {
                long l3;
                long l4;
                double d3;
                double d4 = dArray[i] + d2;
                if (!(d4 < Math.PI)) continue;
                double d5 = Math.min(Math.PI, dArray[i] + d);
                Pointing pointing = new Pointing(vec3Array[i]);
                dArray4[n4] = FastMath.cos(d4);
                dArray5[n4] = FastMath.cos(d5);
                dArray2[n4] = d3 = FastMath.cos(pointing.theta);
                if (n3 > 1) {
                    lArray[n4] = this.zphi2pix(new Zphi(d3, pointing.phi));
                }
                if (n3 > 1) {
                    zphiArray[n4] = new Zphi(d3, pointing.phi);
                }
                dArray3[n4] = 1.0 / Math.sqrt((1.0 - d3) * (1.0 + d3));
                pointingArray[n4] = pointing;
                double d6 = pointing.theta - d4;
                double d7 = FastMath.cos(d6);
                long l5 = l4 = d6 <= 0.0 ? 1L : this.ringAbove(d7) + 1L;
                if (n3 > 1 && d6 > 0.0) {
                    l4 = Math.max(1L, l4 - 1L);
                }
                double d8 = pointing.theta + d4;
                double d9 = FastMath.cos(d8);
                long l6 = l3 = d8 >= Math.PI ? this.nl4 - 1L : this.ringAbove(d9);
                if (n3 > 1 && d8 < Math.PI) {
                    l3 = Math.min(this.nl4 - 1L, l3 + 1L);
                }
                if (l3 < l2) {
                    l2 = l3;
                }
                if (l4 > l) {
                    l = l4;
                }
                ++n4;
            }
            for (long i = l; i <= l2; ++i) {
                double d10 = this.ring2z(i);
                RingInfoSmall ringInfoSmall = this.get_ring_info_small(i);
                long l7 = ringInfoSmall.startpix;
                long l8 = ringInfoSmall.ringpix;
                long l9 = l7 + l8 - 1L;
                double d11 = ringInfoSmall.shifted ? 0.5 : 0.0;
                RangeSet rangeSet2 = new RangeSet();
                rangeSet2.append(l7, l9 + 1L);
                for (int j = 0; j < n4 && rangeSet2.nranges() > 0; ++j) {
                    long l10;
                    double d12 = (dArray5[j] - d10 * dArray2[j]) * dArray3[j];
                    double d13 = 1.0 - d10 * d10 - d12 * d12;
                    double d14 = d13 <= 0.0 ? 3.1415926535897922 : FastMath.atan2(Math.sqrt(d13), d12);
                    long l11 = (long)Math.floor((double)l8 * 0.15915494309189535 * (pointingArray[j].phi + d14) - d11);
                    if (n3 > 1) {
                        for (l10 = (long)Math.floor((double)l8 * 0.15915494309189535 * (pointingArray[j].phi - d14) - d11) + 1L; l10 <= l11 && this.checkPixelRing(healpixBase, l10, l8, l7, n3, zphiArray[j], dArray4[j], lArray[j]); ++l10) {
                        }
                        while (l11 > l10 && this.checkPixelRing(healpixBase, l11, l8, l7, n3, zphiArray[j], dArray4[j], lArray[j])) {
                            --l11;
                        }
                    }
                    if (l11 >= l8) {
                        l10 -= l8;
                        l11 -= l8;
                    }
                    if (l10 < 0L) {
                        if (l11 + 1L > l10 + l8 - 1L) continue;
                        rangeSet2.remove(l7 + l11 + 1L, l7 + l10 + l8);
                        continue;
                    }
                    rangeSet2.intersect(l7 + l10, l7 + l11 + 1L);
                }
                rangeSet.append(rangeSet2);
            }
        } else {
            int n5;
            int n6 = 0;
            if (bl) {
                HealpixUtils.check(1L << 29 - this.order >= (long)n, "invalid oversampling factor");
                HealpixUtils.check((n & n - 1) == 0, "oversampling factor must be a power of 2");
                n6 = HealpixUtils.ilog2(n);
            }
            int n7 = this.order + n6;
            double[][][] dArray6 = new double[n7 + 1][n2][3];
            for (int i = 0; i <= n7; ++i) {
                double d = HealpixProc.bn[i].maxPixrad();
                for (n5 = 0; n5 < n2; ++n5) {
                    dArray6[i][n5][0] = dArray[n5] + d > Math.PI ? -1.0 : FastMath.cos(dArray[n5] + d);
                    dArray6[i][n5][1] = i == 0 ? FastMath.cos(dArray[n5]) : dArray6[0][n5][1];
                    dArray6[i][n5][2] = dArray[n5] - d < 0.0 ? 1.0 : FastMath.cos(dArray[n5] - d);
                }
            }
            pstack pstack2 = new pstack(12 + 3 * n7);
            for (int i = 0; i < 12; ++i) {
                pstack2.push(11 - i, 0);
            }
            while (pstack2.size() > 0) {
                long l = pstack2.ptop();
                n5 = pstack2.otop();
                pstack2.pop();
                Vec3 vec3 = HealpixProc.bn[n5].pix2vec(l);
                int n8 = 3;
                for (int i = 0; i < n2 && n8 > 0; ++i) {
                    double d = vec3.dot(vec3Array[i]);
                    for (int j = 0; j < n8; ++j) {
                        if (!(d < dArray6[n5][i][j])) continue;
                        n8 = j;
                    }
                }
                if (n8 <= 0) continue;
                this.check_pixel(n5, n7, n8, rangeSet, l, pstack2, bl);
            }
        }
        return rangeSet;
    }

    private RangeSet queryPolygonInternal(Pointing[] pointingArray, int n) throws Exception {
        boolean bl = n != 0;
        int n2 = pointingArray.length;
        int n3 = bl ? n2 + 1 : n2;
        HealpixUtils.check(n2 >= 3, "not enough vertices in polygon");
        Vec3[] vec3Array = new Vec3[n2];
        for (int i = 0; i < n2; ++i) {
            vec3Array[i] = new Vec3(pointingArray[i]);
        }
        Vec3[] vec3Array2 = new Vec3[n3];
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            vec3Array2[i] = vec3Array[i].cross(vec3Array[(i + 1) % n2]);
            double d = vec3Array2[i].dot(vec3Array[(i + 2) % n2]);
            if (i == 0) {
                n4 = d < 0.0 ? -1 : 1;
            } else {
                HealpixUtils.check((double)n4 * d > 0.0, "polygon is not convex");
            }
            vec3Array2[i].scale((double)n4 / vec3Array2[i].length());
        }
        double[] dArray = new double[n3];
        Arrays.fill(dArray, 1.5707963267948966);
        if (bl) {
            CircleFinder circleFinder = new CircleFinder(vec3Array);
            vec3Array2[n2] = circleFinder.getCenter();
            dArray[n2] = FastMath.acos(circleFinder.getCosrad());
        }
        return this.queryMultiDisc(vec3Array2, dArray, n);
    }

    public RangeSet queryPolygon(Pointing[] pointingArray) throws Exception {
        return this.queryPolygonInternal(pointingArray, 0);
    }

    public RangeSet queryPolygonInclusive(Pointing[] pointingArray, int n) throws Exception {
        return this.queryPolygonInternal(pointingArray, n);
    }

    private void check_pixel(int n, int n2, int n3, RangeSet rangeSet, long l, pstack pstack2, boolean bl) {
        if (n3 == 0) {
            return;
        }
        if (n < this.order) {
            if (n3 >= 3) {
                int n4 = 2 * (this.order - n);
                rangeSet.append(l << n4, l + 1L << n4);
            } else {
                for (int i = 0; i < 4; ++i) {
                    pstack2.push(4L * l + 3L - (long)i, n + 1);
                }
            }
        } else if (n > this.order) {
            if (n3 >= 2) {
                rangeSet.append(l >>> 2 * (n - this.order));
                pstack2.popToMark();
            } else if (n < n2) {
                for (int i = 0; i < 4; ++i) {
                    pstack2.push(4L * l + 3L - (long)i, n + 1);
                }
            } else {
                rangeSet.append(l >>> 2 * (n - this.order));
                pstack2.popToMark();
            }
        } else if (n3 >= 2) {
            rangeSet.append(l);
        } else if (bl) {
            if (this.order < n2) {
                pstack2.mark();
                for (int i = 0; i < 4; ++i) {
                    pstack2.push(4L * l + 3L - (long)i, n + 1);
                }
            } else {
                rangeSet.append(l);
            }
        }
    }

    public long pix2ring(long l) {
        if (this.scheme == Scheme.RING) {
            if (l < this.ncap) {
                return 1 + HealpixUtils.isqrt(1L + 2L * l) >>> 1;
            }
            if (l < this.npix - this.ncap) {
                return (l - this.ncap) / this.nl4 + this.nside;
            }
            return this.nl4 - (long)(1 + HealpixUtils.isqrt(2L * (this.npix - l) - 1L) >>> 1);
        }
        Xyf xyf = this.nest2xyf(l);
        return ((long)jrll[xyf.face] << this.order) - (long)xyf.ix - (long)xyf.iy - 1L;
    }

    public Vec3[] boundaries(long l, int n) throws Exception {
        HealpixUtils.check(n > 0, "step must be positive");
        Vec3[] vec3Array = new Vec3[4 * n];
        Xyf xyf = this.pix2xyf(l);
        double d = 0.5 / (double)this.nside;
        double d2 = ((double)xyf.ix + 0.5) / (double)this.nside;
        double d3 = ((double)xyf.iy + 0.5) / (double)this.nside;
        double d4 = 1.0 / (double)((long)n * this.nside);
        for (int i = 0; i < n; ++i) {
            vec3Array[i] = new Fxyf(d2 + d - (double)i * d4, d3 + d, xyf.face).toVec3();
            vec3Array[i + n] = new Fxyf(d2 - d, d3 + d - (double)i * d4, xyf.face).toVec3();
            vec3Array[i + 2 * n] = new Fxyf(d2 - d + (double)i * d4, d3 - d, xyf.face).toVec3();
            vec3Array[i + 3 * n] = new Fxyf(d2 + d, d3 - d + (double)i * d4, xyf.face).toVec3();
        }
        return vec3Array;
    }

    private final class pstack {
        private long[] p;
        private int[] o;
        private int s;
        private int m;

        public pstack(int n) {
            this.p = new long[n];
            this.o = new int[n];
            this.m = 0;
            this.s = 0;
        }

        public void push(long l, int n) {
            this.p[this.s] = l;
            this.o[this.s] = n;
            ++this.s;
        }

        public void pop() {
            --this.s;
        }

        public void popToMark() {
            this.s = this.m;
        }

        public int size() {
            return this.s;
        }

        public void mark() {
            this.m = this.s;
        }

        public int otop() {
            return this.o[this.s - 1];
        }

        public long ptop() {
            return this.p[this.s - 1];
        }
    }

    private final class RingInfoSmall {
        long startpix;
        long ringpix;
        boolean shifted;

        private RingInfoSmall() {
        }
    }

    protected final class Xyf {
        public int ix;
        public int iy;
        public int face;

        public Xyf() {
        }

        public Xyf(int n, int n2, int n3) {
            this.ix = n;
            this.iy = n2;
            this.face = n3;
        }
    }
}

