/*
 * Decompiled with CFR 0.152.
 */
package healpix.essentials;

import healpix.essentials.HealpixBase;
import healpix.essentials.HealpixUtils;
import healpix.essentials.Scheme;
import java.util.Arrays;

public class HealpixMapDouble
extends HealpixBase {
    private double[] data;
    public static final double undef = -1.6375E30;

    public HealpixMapDouble() throws Exception {
        this(1L, Scheme.NESTED);
    }

    public HealpixMapDouble(long l, Scheme scheme) throws Exception {
        super(l, scheme);
        HealpixUtils.check(this.nside <= 8192L, "resolution too high");
        this.data = new double[(int)this.getNpix()];
    }

    public HealpixMapDouble(double[] dArray, Scheme scheme) throws Exception {
        super(HealpixMapDouble.npix2Nside(dArray.length), scheme);
        HealpixUtils.check(this.nside <= 8192L, "resolution too high");
        this.data = dArray;
    }

    @Override
    public void setNside(long l) throws Exception {
        if (l != this.nside) {
            super.setNside(l);
            HealpixUtils.check(this.nside <= 8192L, "resolution too high");
            this.data = new double[(int)this.getNpix()];
        }
    }

    @Override
    public void setNsideAndScheme(long l, Scheme scheme) throws Exception {
        super.setNsideAndScheme(l, scheme);
        HealpixUtils.check(this.nside <= 8192L, "resolution too high");
        this.data = new double[(int)this.getNpix()];
    }

    public void setDataAndScheme(double[] dArray, Scheme scheme) throws Exception {
        super.setNsideAndScheme(HealpixMapDouble.npix2Nside(dArray.length), scheme);
        this.data = dArray;
    }

    public void fill(double d) {
        Arrays.fill(this.data, d);
    }

    public void swapScheme() throws Exception {
        HealpixUtils.check(this.order >= 0 && this.order <= 13, "swapping not supported for this Nside");
        for (int i = 0; i < swap_cycle[this.order].length; ++i) {
            long l;
            int n = swap_cycle[this.order][i];
            double d = this.data[n];
            long l2 = n;
            long l3 = l = this.scheme == Scheme.RING ? this.nest2ring(n) : this.ring2nest(n);
            while (l != (long)n) {
                this.data[(int)l2] = this.data[(int)l];
                l2 = l;
                l = this.scheme == Scheme.RING ? this.nest2ring(l) : this.ring2nest(l);
            }
            this.data[(int)l2] = d;
        }
        this.scheme = this.scheme == Scheme.RING ? Scheme.NESTED : Scheme.RING;
    }

    public double getPixel(int n) {
        return this.data[n];
    }

    public double getPixel(long l) {
        return this.data[(int)l];
    }

    public void setPixel(int n, double d) {
        this.data[n] = d;
    }

    public void setPixel(long l, double d) {
        this.data[(int)l] = d;
    }

    public double[] getData() {
        return this.data;
    }

    public void importNograde(HealpixMapDouble healpixMapDouble) throws Exception {
        HealpixUtils.check(this.nside == healpixMapDouble.nside, "importNograde: maps have different nside");
        if (healpixMapDouble.scheme == this.scheme) {
            System.arraycopy(healpixMapDouble.data, 0, this.data, 0, (int)this.npix);
        } else {
            int n = 0;
            while ((long)n < this.npix) {
                this.data[this.scheme == Scheme.NESTED ? (int)this.ring2nest((long)((long)n)) : (int)this.nest2ring((long)((long)n))] = healpixMapDouble.data[n];
                ++n;
            }
        }
    }

    public void importUpgrade(HealpixMapDouble healpixMapDouble) throws Exception {
        HealpixUtils.check(this.nside > healpixMapDouble.nside, "importUpgrade: this is no upgrade");
        int n = (int)(this.nside / healpixMapDouble.nside);
        HealpixUtils.check(this.nside == healpixMapDouble.nside * (long)n, "the larger Nside must be a multiple of the smaller one");
        int n2 = 0;
        while ((long)n2 < healpixMapDouble.npix) {
            HealpixBase.Xyf xyf = healpixMapDouble.pix2xyf(n2);
            int n3 = xyf.ix;
            int n4 = xyf.iy;
            int n5 = xyf.face;
            for (int i = n * n4; i < n * (n4 + 1); ++i) {
                for (int j = n * n3; j < n * (n3 + 1); ++j) {
                    long l = this.xyf2pix(j, i, n5);
                    this.data[(int)l] = healpixMapDouble.data[n2];
                }
            }
            ++n2;
        }
    }

    public void importDegrade(HealpixMapDouble healpixMapDouble, boolean bl) throws Exception {
        HealpixUtils.check(this.nside < healpixMapDouble.nside, "importDegrade: this is no degrade");
        int n = (int)(healpixMapDouble.nside / this.nside);
        HealpixUtils.check(healpixMapDouble.nside == this.nside * (long)n, "the larger Nside must be a multiple of the smaller one");
        int n2 = bl ? n * n : 1;
        int n3 = 0;
        while ((long)n3 < this.npix) {
            HealpixBase.Xyf xyf = this.pix2xyf(n3);
            int n4 = xyf.ix;
            int n5 = xyf.iy;
            int n6 = xyf.face;
            int n7 = 0;
            double d = 0.0;
            for (int i = n * n5; i < n * (n5 + 1); ++i) {
                for (int j = n * n4; j < n * (n4 + 1); ++j) {
                    int n8 = (int)healpixMapDouble.xyf2pix(j, i, n6);
                    if (HealpixUtils.approx(healpixMapDouble.data[n8], -1.6375E30, 1.0E-5)) continue;
                    ++n7;
                    d += healpixMapDouble.data[n8];
                }
            }
            this.data[n3] = n7 < n2 ? -1.6375E30 : d / (double)n7;
            ++n3;
        }
    }

    public void importGeneral(HealpixMapDouble healpixMapDouble, boolean bl) throws Exception {
        if (healpixMapDouble.nside == this.nside) {
            this.importNograde(healpixMapDouble);
        } else if (healpixMapDouble.nside < this.nside) {
            this.importUpgrade(healpixMapDouble);
        } else {
            this.importDegrade(healpixMapDouble, bl);
        }
    }
}

