/*
 * Decompiled with CFR 0.152.
 */
package healpix.essentials;

import healpix.essentials.HealpixBase;
import healpix.essentials.HealpixUtils;
import healpix.essentials.Scheme;
import java.util.Arrays;

public class HealpixMapFloat
extends HealpixBase {
    private float[] data;
    public static final float undef = -1.6375E30f;

    public HealpixMapFloat() throws Exception {
        this(1L, Scheme.NESTED);
    }

    public HealpixMapFloat(long l, Scheme scheme) throws Exception {
        super(l, scheme);
        HealpixUtils.check(this.nside <= 8192L, "resolution too high");
        this.data = new float[(int)this.getNpix()];
    }

    public HealpixMapFloat(float[] fArray, Scheme scheme) throws Exception {
        super(HealpixMapFloat.npix2Nside(fArray.length), scheme);
        HealpixUtils.check(this.nside <= 8192L, "resolution too high");
        this.data = fArray;
    }

    @Override
    public void setNside(long l) throws Exception {
        if (l != this.nside) {
            super.setNside(l);
            HealpixUtils.check(this.nside <= 8192L, "resolution too high");
            this.data = new float[(int)this.getNpix()];
        }
    }

    @Override
    public void setNsideAndScheme(long l, Scheme scheme) throws Exception {
        super.setNsideAndScheme(l, scheme);
        HealpixUtils.check(this.nside <= 8192L, "resolution too high");
        this.data = new float[(int)this.getNpix()];
    }

    public void setDataAndScheme(float[] fArray, Scheme scheme) throws Exception {
        super.setNsideAndScheme(HealpixMapFloat.npix2Nside(fArray.length), scheme);
        this.data = fArray;
    }

    public void fill(float f) {
        Arrays.fill(this.data, f);
    }

    public void swapScheme() throws Exception {
        HealpixUtils.check(this.order >= 0 && this.order <= 13, "swapping not supported for this Nside");
        for (int i = 0; i < swap_cycle[this.order].length; ++i) {
            long l;
            int n = swap_cycle[this.order][i];
            float f = this.data[n];
            long l2 = n;
            long l3 = l = this.scheme == Scheme.RING ? this.nest2ring(n) : this.ring2nest(n);
            while (l != (long)n) {
                this.data[(int)l2] = this.data[(int)l];
                l2 = l;
                l = this.scheme == Scheme.RING ? this.nest2ring(l) : this.ring2nest(l);
            }
            this.data[(int)l2] = f;
        }
        this.scheme = this.scheme == Scheme.RING ? Scheme.NESTED : Scheme.RING;
    }

    public float getPixel(int n) {
        return this.data[n];
    }

    public float getPixel(long l) {
        return this.data[(int)l];
    }

    public void setPixel(int n, float f) {
        this.data[n] = f;
    }

    public void setPixel(long l, float f) {
        this.data[(int)l] = f;
    }

    public float[] getData() {
        return this.data;
    }

    public void importNograde(HealpixMapFloat healpixMapFloat) throws Exception {
        HealpixUtils.check(this.nside == healpixMapFloat.nside, "importNograde: maps have different nside");
        if (healpixMapFloat.scheme == this.scheme) {
            System.arraycopy(healpixMapFloat.data, 0, this.data, 0, (int)this.npix);
        } else {
            int n = 0;
            while ((long)n < this.npix) {
                this.data[this.scheme == Scheme.NESTED ? (int)this.ring2nest((long)((long)n)) : (int)this.nest2ring((long)((long)n))] = healpixMapFloat.data[n];
                ++n;
            }
        }
    }

    public void importUpgrade(HealpixMapFloat healpixMapFloat) throws Exception {
        HealpixUtils.check(this.nside > healpixMapFloat.nside, "importUpgrade: this is no upgrade");
        int n = (int)(this.nside / healpixMapFloat.nside);
        HealpixUtils.check(this.nside == healpixMapFloat.nside * (long)n, "the larger Nside must be a multiple of the smaller one");
        int n2 = 0;
        while ((long)n2 < healpixMapFloat.npix) {
            HealpixBase.Xyf xyf = healpixMapFloat.pix2xyf(n2);
            int n3 = xyf.ix;
            int n4 = xyf.iy;
            int n5 = xyf.face;
            for (int i = n * n4; i < n * (n4 + 1); ++i) {
                for (int j = n * n3; j < n * (n3 + 1); ++j) {
                    long l = this.xyf2pix(j, i, n5);
                    this.data[(int)l] = healpixMapFloat.data[n2];
                }
            }
            ++n2;
        }
    }

    public void importDegrade(HealpixMapFloat healpixMapFloat, boolean bl) throws Exception {
        HealpixUtils.check(this.nside < healpixMapFloat.nside, "importDegrade: this is no degrade");
        int n = (int)(healpixMapFloat.nside / this.nside);
        HealpixUtils.check(healpixMapFloat.nside == this.nside * (long)n, "the larger Nside must be a multiple of the smaller one");
        int n2 = bl ? n * n : 1;
        int n3 = 0;
        while ((long)n3 < this.npix) {
            HealpixBase.Xyf xyf = this.pix2xyf(n3);
            int n4 = xyf.ix;
            int n5 = xyf.iy;
            int n6 = xyf.face;
            int n7 = 0;
            double d = 0.0;
            for (int i = n * n5; i < n * (n5 + 1); ++i) {
                for (int j = n * n4; j < n * (n4 + 1); ++j) {
                    int n8 = (int)healpixMapFloat.xyf2pix(j, i, n6);
                    if (HealpixUtils.approx((double)healpixMapFloat.data[n8], (double)-1.6375E30f, 1.0E-5)) continue;
                    ++n7;
                    d += (double)healpixMapFloat.data[n8];
                }
            }
            this.data[n3] = n7 < n2 ? -1.6375E30f : (float)(d / (double)n7);
            ++n3;
        }
    }

    public void importGeneral(HealpixMapFloat healpixMapFloat, boolean bl) throws Exception {
        if (healpixMapFloat.nside == this.nside) {
            this.importNograde(healpixMapFloat);
        } else if (healpixMapFloat.nside < this.nside) {
            this.importUpgrade(healpixMapFloat);
        } else {
            this.importDegrade(healpixMapFloat, bl);
        }
    }
}

