/*
 * Decompiled with CFR 0.152.
 */
package healpix.essentials;

import healpix.essentials.FastMath;
import healpix.essentials.HealpixBase;
import healpix.essentials.Pointing;
import healpix.essentials.RangeSet;
import healpix.essentials.Scheme;
import healpix.essentials.Vec3;

public abstract class HealpixProc
extends HealpixBase {
    static final HealpixBase[] bn = new HealpixBase[30];
    static final HealpixBase[] br = new HealpixBase[30];
    static final double[] mpr = new double[30];
    static final double[] cmpr = new double[30];
    static final double[] smpr = new double[30];

    private HealpixProc() {
    }

    public static double maxPixrad(int n) {
        return bn[n].maxPixrad();
    }

    public static long ang2pixNest(int n, Pointing pointing) throws Exception {
        return bn[n].ang2pix(pointing);
    }

    public static long ang2pixRing(int n, Pointing pointing) throws Exception {
        return br[n].ang2pix(pointing);
    }

    public static Pointing pix2angNest(int n, long l) throws Exception {
        return bn[n].pix2ang(l);
    }

    public static Pointing pix2angRing(int n, long l) throws Exception {
        return br[n].pix2ang(l);
    }

    public static long vec2pixNest(int n, Vec3 vec3) throws Exception {
        return bn[n].vec2pix(vec3);
    }

    public static long vec2pixRing(int n, Vec3 vec3) throws Exception {
        return br[n].vec2pix(vec3);
    }

    public static Vec3 pix2vecNest(int n, long l) throws Exception {
        return bn[n].pix2vec(l);
    }

    public static Vec3 pix2vecRing(int n, long l) throws Exception {
        return br[n].pix2vec(l);
    }

    public static long ring2nest(int n, long l) throws Exception {
        return bn[n].ring2nest(l);
    }

    public static long nest2ring(int n, long l) throws Exception {
        return bn[n].nest2ring(l);
    }

    public static long[] neighboursNest(int n, long l) throws Exception {
        return bn[n].neighbours(l);
    }

    public static long[] neighboursRing(int n, long l) throws Exception {
        return br[n].neighbours(l);
    }

    public static Vec3[] boundariesNest(int n, long l, int n2) throws Exception {
        return bn[n].boundaries(l, n2);
    }

    public static Vec3[] boundariesRing(int n, long l, int n2) throws Exception {
        return br[n].boundaries(l, n2);
    }

    public static RangeSet queryDiscNest(int n, Pointing pointing, double d) throws Exception {
        return bn[n].queryDisc(pointing, d);
    }

    public static RangeSet queryDiscRing(int n, Pointing pointing, double d) throws Exception {
        return br[n].queryDisc(pointing, d);
    }

    public static RangeSet queryDiscInclusiveNest(int n, Pointing pointing, double d, int n2) throws Exception {
        return bn[n].queryDiscInclusive(pointing, d, n2);
    }

    public static RangeSet queryDiscInclusiveRing(int n, Pointing pointing, double d, int n2) throws Exception {
        return br[n].queryDiscInclusive(pointing, d, n2);
    }

    public static RangeSet queryPolygonNest(int n, Pointing[] pointingArray) throws Exception {
        return bn[n].queryPolygon(pointingArray);
    }

    public static RangeSet queryPolygonRing(int n, Pointing[] pointingArray) throws Exception {
        return br[n].queryPolygon(pointingArray);
    }

    public static RangeSet queryPolygonInclusiveNest(int n, Pointing[] pointingArray, int n2) throws Exception {
        return bn[n].queryPolygonInclusive(pointingArray, n2);
    }

    public static RangeSet queryPolygonInclusiveRing(int n, Pointing[] pointingArray, int n2) throws Exception {
        return br[n].queryPolygonInclusive(pointingArray, n2);
    }

    public static RangeSet queryStripNest(int n, double d, double d2, boolean bl) throws Exception {
        return bn[n].queryStrip(d, d2, bl);
    }

    public static RangeSet queryStripRing(int n, double d, double d2, boolean bl) throws Exception {
        return br[n].queryStrip(d, d2, bl);
    }

    static {
        try {
            for (int i = 0; i <= 29; ++i) {
                HealpixProc.bn[i] = new HealpixBase(1L << i, Scheme.NESTED);
                HealpixProc.br[i] = new HealpixBase(1L << i, Scheme.RING);
                HealpixProc.mpr[i] = bn[i].maxPixrad();
                HealpixProc.cmpr[i] = FastMath.cos(mpr[i]);
                HealpixProc.smpr[i] = FastMath.sin(mpr[i]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

