/*
 * Decompiled with CFR 0.152.
 */
package healpix.essentials;

import healpix.essentials.FastMath;
import healpix.essentials.Zphi;

public class HealpixUtils {
    public static void check(boolean bl, String string) throws Exception {
        if (!bl) {
            throw new Exception(string);
        }
    }

    public static int ilog2(long l) {
        return 63 - Long.numberOfLeadingZeros(Math.max(l, 1L));
    }

    public static int isqrt(long l) {
        long l2 = (long)Math.sqrt((double)l + 0.5);
        if (l < 0x4000000000000L) {
            return (int)l2;
        }
        if (l2 * l2 > l) {
            --l2;
        } else if ((l2 + 1L) * (l2 + 1L) <= l) {
            ++l2;
        }
        return (int)l2;
    }

    public static double cosdist_zphi(double d, double d2, double d3, double d4) {
        return d * d3 + FastMath.cos(d2 - d4) * Math.sqrt((1.0 - d * d) * (1.0 - d3 * d3));
    }

    public static double cosdist_zphi(Zphi zphi, Zphi zphi2) {
        return HealpixUtils.cosdist_zphi(zphi.z, zphi.phi, zphi2.z, zphi2.phi);
    }

    public static double fmodulo(double d, double d2) {
        if (d >= 0.0) {
            return d < d2 ? d : d % d2;
        }
        double d3 = d % d2 + d2;
        return d3 == d2 ? 0.0 : d3;
    }

    public static boolean approx(float f, float f2, float f3) {
        return Math.abs(f - f2) < f3 * Math.abs(f2);
    }

    public static boolean approx(double d, double d2, double d3) {
        return Math.abs(d - d2) < d3 * Math.abs(d2);
    }

    public static int uniq2order(long l) {
        return HealpixUtils.ilog2(l >>> 2) >>> 1;
    }

    private static long nest_peano_helper(long l, int n, int n2) {
        int n3;
        short[] sArray = new short[]{0, 35, 65, 66, 68, 5, 103, 6, 110, 109, 15, 44, 72, 9, 107, 10, 31, 126, 60, 125, 81, 16, 82, 51, 123, 88, 26, 25, 119, 84, 22, 21, 42, 75, 41, 104, 12, 47, 77, 78, 38, 71, 37, 100, 98, 97, 3, 32, 53, 54, 116, 87, 57, 58, 120, 91, 19, 114, 48, 113, 93, 28, 94, 63, 64, 1, 99, 2, 46, 79, 45, 108, 4, 39, 69, 70, 8, 43, 73, 74, 85, 20, 86, 55, 115, 80, 18, 17, 89, 24, 90, 59, 61, 62, 124, 95, 106, 105, 11, 40, 102, 101, 7, 36, 76, 13, 111, 14, 34, 67, 33, 96, 127, 92, 30, 29, 27, 122, 56, 121, 49, 50, 112, 83, 23, 118, 52, 117, 128, 194, 195, 161, 196, 133, 135, 230, 204, 141, 143, 238, 171, 233, 232, 138, 149, 212, 214, 183, 221, 159, 158, 252, 217, 155, 154, 248, 178, 243, 241, 144, 175, 237, 236, 142, 235, 170, 168, 201, 227, 162, 160, 193, 132, 198, 199, 165, 186, 251, 249, 152, 242, 176, 177, 211, 246, 180, 181, 215, 157, 220, 222, 191, 192, 129, 131, 226, 136, 202, 203, 169, 140, 206, 207, 173, 231, 166, 164, 197, 213, 151, 150, 244, 145, 208, 210, 179, 153, 216, 218, 187, 254, 188, 189, 223, 239, 174, 172, 205, 167, 229, 228, 134, 163, 225, 224, 130, 200, 137, 139, 234, 250, 184, 185, 219, 190, 255, 253, 156, 182, 247, 245, 148, 209, 147, 146, 240};
        byte[] byArray = new byte[]{16, 1, 27, 2, 31, 20, 6, 5, 10, 19, 9, 24, 13, 14, 28, 23, 0, 11, 17, 18, 21, 4, 22, 15, 26, 25, 3, 8, 7, 30, 12, 29, 48, 33, 35, 58, 53, 39, 38, 60, 59, 42, 40, 49, 62, 44, 45, 55, 32, 50, 51, 41, 37, 52, 54, 47, 43, 57, 56, 34, 46, 63, 61, 36};
        byte[][] byArrayArray = new byte[][]{{2, 5, 2, 5, 3, 6, 3, 6, 2, 3, 2, 3}, {2, 6, 2, 3, 3, 5, 2, 6, 2, 3, 3, 5}};
        byte[][] byArrayArray2 = new byte[][]{{0, 5, 6, 11, 10, 1, 4, 7, 2, 3, 8, 9}, {0, 5, 8, 9, 6, 1, 2, 7, 10, 11, 4, 3}};
        int n4 = (int)(l >>> 2 * n);
        long l2 = 0L;
        int n5 = byArrayArray[n2][n4] << 4 | n2 << 7;
        for (n3 = 2 * n - 4; n3 >= 0; n3 -= 4) {
            n5 = sArray[n5 & 0xF0 | (int)(l >>> n3) & 0xF];
            l2 = l2 << 4 | (long)(n5 & 0xF);
        }
        if (n3 == -2) {
            n5 = byArray[n5 >>> 2 & 0xFC | (int)l & 3];
            l2 = l2 << 2 | (long)(n5 & 3);
        }
        return l2 + ((long)byArrayArray2[n2][n4] << 2 * n);
    }

    public static long nest2peano(long l, int n) {
        return HealpixUtils.nest_peano_helper(l, n, 0);
    }

    public static long peano2nest(long l, int n) {
        return HealpixUtils.nest_peano_helper(l, n, 1);
    }
}

