/*
 * Decompiled with CFR 0.152.
 */
package healpix.essentials;

import healpix.essentials.FastMath;
import healpix.essentials.HealpixUtils;
import healpix.essentials.Pointing;
import healpix.essentials.Vec3;
import healpix.essentials.Zphi;

final class Hploc {
    public double z;
    public double phi;
    public double sth;
    public boolean have_sth;

    public Hploc() {
    }

    public Hploc(Vec3 vec3) {
        double d = 1.0 / vec3.length();
        this.z = vec3.z * d;
        this.phi = FastMath.atan2(vec3.y, vec3.x);
        if (Math.abs(this.z) > 0.99) {
            this.sth = Math.sqrt(vec3.x * vec3.x + vec3.y * vec3.y) * d;
            this.have_sth = true;
        }
    }

    public Hploc(Zphi zphi) {
        this.z = zphi.z;
        this.phi = zphi.phi;
        this.have_sth = false;
    }

    public Hploc(Pointing pointing) throws Exception {
        HealpixUtils.check(pointing.theta >= 0.0 && pointing.theta <= Math.PI, "invalid theta value");
        this.z = FastMath.cos(pointing.theta);
        this.phi = pointing.phi;
        if (Math.abs(this.z) > 0.99) {
            this.sth = FastMath.sin(pointing.theta);
            this.have_sth = true;
        }
    }

    public Zphi toZphi() {
        return new Zphi(this.z, this.phi);
    }

    public Pointing toPointing() {
        double d = this.have_sth ? this.sth : Math.sqrt((1.0 - this.z) * (1.0 + this.z));
        return new Pointing(FastMath.atan2(d, this.z), this.phi);
    }

    public Vec3 toVec3() {
        double d = this.have_sth ? this.sth : Math.sqrt((1.0 - this.z) * (1.0 + this.z));
        return new Vec3(d * FastMath.cos(this.phi), d * FastMath.sin(this.phi), this.z);
    }
}

