/*
 * Decompiled with CFR 0.152.
 */
package healpix.essentials;

import healpix.essentials.HealpixUtils;
import healpix.essentials.RangeSet;

public class Moc {
    private static final int maxorder = 29;
    private RangeSet rs;

    public Moc() {
        this.rs = new RangeSet();
    }

    public Moc(Moc moc) {
        this.rs = new RangeSet(moc.rs);
    }

    public Moc(RangeSet rangeSet, int n) {
        this.rs = new RangeSet(rangeSet.nranges());
        int n2 = 2 * (29 - n);
        for (int i = 0; i < rangeSet.nranges(); ++i) {
            this.rs.append(rangeSet.ivbegin(i) << n2, rangeSet.ivend(i) << n2);
        }
    }

    private static Moc fromNewRangeSet(RangeSet rangeSet) {
        Moc moc = new Moc();
        moc.rs = rangeSet;
        return moc;
    }

    public RangeSet getRangeSet() {
        return new RangeSet(this.rs);
    }

    public int maxOrder() {
        long l = 0L;
        for (int i = 0; i < this.rs.nranges(); ++i) {
            l |= this.rs.ivbegin(i) | this.rs.ivend(i);
        }
        return 29 - (Long.numberOfTrailingZeros(l) >>> 1);
    }

    public Moc degradedToOrder(int n, boolean bl) {
        int n2 = 2 * (29 - n);
        long l = (1L << n2) - 1L;
        long l2 = l ^ 0xFFFFFFFFFFFFFFFFL;
        long l3 = bl ? 0L : l;
        long l4 = bl ? l : 0L;
        RangeSet rangeSet = new RangeSet();
        for (int i = 0; i < this.rs.nranges(); ++i) {
            long l5 = this.rs.ivbegin(i) + l3 & l2;
            long l6 = this.rs.ivend(i) + l4 & l2;
            if (l6 <= l5) continue;
            rangeSet.append(l5, l6);
        }
        return Moc.fromNewRangeSet(rangeSet);
    }

    public void addPixelRange(int n, long l, long l2) {
        int n2 = 2 * (29 - n);
        this.rs.add(l << n2, l2 << n2);
    }

    public void addPixel(int n, long l) {
        this.addPixelRange(n, l, l + 1L);
    }

    public Moc union(Moc moc) {
        return Moc.fromNewRangeSet(this.rs.union(moc.rs));
    }

    public Moc intersection(Moc moc) {
        return Moc.fromNewRangeSet(this.rs.intersection(moc.rs));
    }

    public Moc subtraction(Moc moc) {
        return Moc.fromNewRangeSet(this.rs.difference(moc.rs));
    }

    public Moc complement() {
        RangeSet rangeSet = new RangeSet(new long[]{0L, 0x3000000000000000L});
        return Moc.fromNewRangeSet(rangeSet.difference(this.rs));
    }

    public boolean contains(Moc moc) {
        return this.rs.contains(moc.rs);
    }

    public boolean overlaps(Moc moc) {
        return this.rs.overlaps(moc.rs);
    }

    public RangeSet toUniqRS() {
        RangeSet rangeSet = new RangeSet(this.rs);
        RangeSet rangeSet2 = new RangeSet();
        RangeSet rangeSet3 = new RangeSet();
        for (int i = 0; i <= 29; ++i) {
            if (rangeSet.isEmpty()) {
                return rangeSet3;
            }
            int n = 2 * (29 - i);
            long l = (1L << n) - 1L;
            long l2 = 1L << 2 * i + 2;
            rangeSet2.clear();
            for (int j = 0; j < rangeSet.nranges(); ++j) {
                long l3 = rangeSet.ivbegin(j) + l >>> n;
                long l4 = rangeSet.ivend(j) >>> n;
                rangeSet2.append(l3 << n, l4 << n);
                rangeSet3.append(l3 + l2, l4 + l2);
            }
            if (rangeSet2.isEmpty()) continue;
            rangeSet = rangeSet.difference(rangeSet2);
        }
        return rangeSet3;
    }

    public long[] toUniq() {
        return this.toUniqRS().toArray();
    }

    public static Moc fromUniqRS(RangeSet rangeSet) {
        RangeSet rangeSet2 = new RangeSet();
        RangeSet rangeSet3 = new RangeSet();
        int n = 0;
        int n2 = 58;
        for (int i = 0; i < rangeSet.nranges(); ++i) {
            for (long j = rangeSet.ivbegin(i); j < rangeSet.ivend(i); ++j) {
                int n3 = HealpixUtils.uniq2order(j);
                if (n3 != n) {
                    rangeSet2 = rangeSet2.union(rangeSet3);
                    rangeSet3.clear();
                    n = n3;
                    n2 = 2 * (29 - n3);
                }
                long l = j - (1L << 2 * n3 + 2);
                rangeSet3.append(l << n2, l + 1L << n2);
            }
        }
        rangeSet2 = rangeSet2.union(rangeSet3);
        return Moc.fromNewRangeSet(rangeSet2);
    }

    public static Moc fromUniq(long[] lArray) {
        return Moc.fromUniqRS(RangeSet.fromArray(lArray));
    }

    public byte[] toCompressed() throws Exception {
        return this.rs.toCompressed();
    }

    public static Moc fromCompressed(byte[] byArray) throws Exception {
        return Moc.fromNewRangeSet(RangeSet.fromCompressed(byArray));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof Moc)) {
            return false;
        }
        Moc moc = (Moc)object;
        return this.rs.equals(moc.rs);
    }

    public int hashCode() {
        return this.rs.hashCode();
    }

    public int nranges() {
        return this.rs.nranges();
    }
}

