/*
 * Decompiled with CFR 0.152.
 */
package healpix.essentials;

import healpix.essentials.HealpixBase;
import healpix.essentials.HealpixUtils;
import healpix.essentials.Moc;
import healpix.essentials.Scheme;
import healpix.essentials.Vec3;
import java.util.ArrayList;

public class MocQuery {
    public static Moc doMocQuery(int n, ArrayList<MocQueryComponent> arrayList) throws Exception {
        return new queryHelper(n, n, false, arrayList).result();
    }

    public static Moc doMocQueryInclusive(int n, int n2, ArrayList<MocQueryComponent> arrayList) throws Exception {
        return new queryHelper(n, n2, true, arrayList).result();
    }

    private static double isLeft(Vec3 vec3, Vec3 vec32, Vec3 vec33) {
        return vec3.cross(vec32).dot(vec33);
    }

    private static int[] getHull(Vec3[] vec3Array, int[] nArray) throws Exception {
        int n;
        int n2 = nArray.length;
        int[] nArray2 = new int[2 * n2 + 1];
        int n3 = n2 - 2;
        int n4 = n3 + 3;
        nArray2[n3] = nArray2[n4] = nArray[2];
        if (MocQuery.isLeft(vec3Array[nArray[0]], vec3Array[nArray[1]], vec3Array[nArray[2]]) > 0.0) {
            nArray2[n3 + 1] = nArray[0];
            nArray2[n3 + 2] = nArray[1];
        } else {
            nArray2[n3 + 1] = nArray[1];
            nArray2[n3 + 2] = nArray[0];
        }
        for (n = 3; n < n2; ++n) {
            if (MocQuery.isLeft(vec3Array[nArray2[n3]], vec3Array[nArray2[n3 + 1]], vec3Array[nArray[n]]) > 0.0 && MocQuery.isLeft(vec3Array[nArray2[n4 - 1]], vec3Array[nArray2[n4]], vec3Array[nArray[n]]) > 0.0) continue;
            while (MocQuery.isLeft(vec3Array[nArray2[n3]], vec3Array[nArray2[n3 + 1]], vec3Array[nArray[n]]) <= 0.0) {
                ++n3;
            }
            nArray2[--n3] = nArray[n];
            while (MocQuery.isLeft(vec3Array[nArray2[n4 - 1]], vec3Array[nArray2[n4]], vec3Array[nArray[n]]) <= 0.0) {
                --n4;
            }
            nArray2[++n4] = nArray[n];
        }
        n = n4 - n3;
        int[] nArray3 = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray3[i] = nArray2[n3 + i + 1];
        }
        return nArray3;
    }

    public static ArrayList<MocQueryComponent> prepPolyHelper(Vec3[] vec3Array, int[] nArray, ArrayList<MocQueryComponent> arrayList, boolean bl) throws Exception {
        int n;
        int n2;
        int[] nArray2 = MocQuery.getHull(vec3Array, nArray);
        boolean[] blArray = new boolean[nArray2.length];
        int n3 = 0;
        int n4 = 0;
        int n5 = nArray2.length;
        int n6 = nArray.length;
        while (nArray2[n3] != nArray[n4]) {
            ++n4;
        }
        int n7 = 0;
        if (nArray.length == 3) {
            for (n2 = 0; n2 < 3; ++n2) {
                blArray[n2] = true;
            }
        } else {
            do {
                if (nArray2[n2 = (n3 + 1) % n5] == nArray[n = (n4 + 1) % n6]) {
                    blArray[n3] = true;
                    n3 = n2;
                    n4 = n;
                    continue;
                }
                int n8 = 2;
                while (nArray[n] != nArray2[n2]) {
                    n = (n + 1) % n6;
                    ++n8;
                }
                int[] nArray3 = new int[n8];
                int n9 = 0;
                int n10 = n;
                while (nArray[n10] != nArray2[n3]) {
                    nArray3[n9++] = nArray[n10];
                    n10 = (n10 + n6 - 1) % n6;
                }
                nArray3[n9] = nArray2[n3];
                ++n7;
                arrayList = MocQuery.prepPolyHelper(vec3Array, nArray3, arrayList, false);
                n3 = n2;
                n4 = n;
            } while (n3 != 0);
        }
        if (n7 > 1) {
            arrayList.add(new MocQueryComponent(MocQueryOp.OR, n7));
        }
        if (n7 > 0) {
            arrayList.add(new MocQueryComponent(MocQueryOp.NOT));
        }
        if (!bl) {
            blArray[nArray2.length - 1] = false;
        }
        for (n2 = 0; n2 < nArray2.length; ++n2) {
            if (!blArray[n2]) continue;
            arrayList.add(new MocQueryComponent(vec3Array[nArray2[n2]].cross(vec3Array[nArray2[(n2 + 1) % nArray2.length]]).norm(), 1.5707963267948966));
        }
        n2 = 0;
        for (n = 0; n < nArray2.length; ++n) {
            if (!blArray[n]) continue;
            ++n2;
        }
        if (n7 > 0) {
            ++n2;
        }
        if (n2 > 1) {
            arrayList.add(new MocQueryComponent(MocQueryOp.AND, n2));
        }
        return arrayList;
    }

    public static ArrayList<MocQueryComponent> prepPolygon(ArrayList<Vec3> arrayList) throws Exception {
        HealpixUtils.check(arrayList.size() >= 3, "not enough vertices in polygon");
        Vec3[] vec3Array = new Vec3[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            vec3Array[i] = arrayList.get(i).norm();
        }
        int[] nArray = new int[vec3Array.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i;
        }
        ArrayList<MocQueryComponent> arrayList2 = new ArrayList<MocQueryComponent>();
        return MocQuery.prepPolyHelper(vec3Array, nArray, arrayList2, true);
    }

    public static Moc queryGeneralPolygon(ArrayList<Vec3> arrayList, int n) throws Exception {
        return MocQuery.doMocQuery(n, MocQuery.prepPolygon(arrayList));
    }

    public static Moc queryGeneralPolygonInclusive(ArrayList<Vec3> arrayList, int n, int n2) throws Exception {
        return MocQuery.doMocQueryInclusive(n, n2, MocQuery.prepPolygon(arrayList));
    }

    private static class queryHelper {
        private int order;
        private int omax;
        private int ncomp;
        private boolean inclusive;
        private HealpixBase[] base;
        private double[] cr;
        private double[][] crmin;
        private double[][] crmax;
        private int[] shortcut;
        private MocQueryOp[] op;
        private int[] nops;
        private Vec3[] center;
        private pstack stk;
        private long pix;
        private int o;
        private Vec3 pv;
        private int loc;

        private void check_pixel(int n, Moc moc) {
            if (n == 0) {
                return;
            }
            if (this.o < this.order) {
                if (n >= 3) {
                    moc.addPixel(this.o, this.pix);
                } else {
                    for (int i = 0; i < 4; ++i) {
                        this.stk.push(4L * this.pix + 3L - (long)i, this.o + 1);
                    }
                }
            } else if (this.o > this.order) {
                if (n >= 2) {
                    moc.addPixel(this.order, this.pix >>> 2 * (this.o - this.order));
                    this.stk.popToMark();
                } else if (this.o < this.omax) {
                    for (int i = 0; i < 4; ++i) {
                        this.stk.push(4L * this.pix + 3L - (long)i, this.o + 1);
                    }
                } else {
                    moc.addPixel(this.order, this.pix >>> 2 * (this.o - this.order));
                    this.stk.popToMark();
                }
            } else if (n >= 2) {
                moc.addPixel(this.order, this.pix);
            } else if (this.inclusive) {
                if (this.order < this.omax) {
                    this.stk.mark();
                    for (int i = 0; i < 4; ++i) {
                        this.stk.push(4L * this.pix + 3L - (long)i, this.o + 1);
                    }
                } else {
                    moc.addPixel(this.order, this.pix);
                }
            }
        }

        void correctLoc() throws Exception {
            int n;
            HealpixUtils.check((n = this.loc--) >= 0 && n < this.ncomp, "inconsistency");
            for (int i = 0; i < this.nops[n]; ++i) {
                this.correctLoc();
            }
        }

        int getZone(int n, int n2) {
            if (n == n2) {
                this.loc = this.shortcut[this.loc];
                return n;
            }
            int n3 = this.loc--;
            switch (this.op[n3]) {
                case AND: {
                    int n4 = n2;
                    for (int i = 0; i < this.nops[n3]; ++i) {
                        n4 = this.getZone(n, n4);
                    }
                    return n4;
                }
                case OR: {
                    int n5 = n;
                    for (int i = 0; i < this.nops[n3]; ++i) {
                        n5 = this.getZone(n5, n2);
                    }
                    return n5;
                }
                case XOR: {
                    int n6 = this.getZone(0, 3);
                    int n7 = this.getZone(0, 3);
                    return Math.max(n, Math.min(n2, Math.max(Math.min(n6, 3 - n7), Math.min(3 - n6, n7))));
                }
                case NOT: {
                    return 3 - this.getZone(3 - n2, 3 - n);
                }
                case NONE: {
                    int n8 = n2;
                    double d = this.pv.dot(this.center[n3]);
                    if (d <= this.crmax[this.o][n3]) {
                        n8 = 0;
                    } else if (d <= this.cr[n3]) {
                        n8 = 1;
                    } else if (d <= this.crmin[this.o][n3]) {
                        n8 = 2;
                    }
                    return Math.max(n, Math.min(n2, n8));
                }
            }
            return -1;
        }

        public queryHelper(int n, int n2, boolean bl, ArrayList<MocQueryComponent> arrayList) throws Exception {
            int n3;
            this.order = n;
            this.omax = n2;
            this.ncomp = arrayList.size();
            this.inclusive = bl;
            this.base = new HealpixBase[this.omax + 1];
            this.cr = new double[this.ncomp];
            this.crmin = new double[this.omax + 1][this.ncomp];
            this.crmax = new double[this.omax + 1][this.ncomp];
            HealpixUtils.check(this.ncomp >= 1, "bad query component ArrayList");
            HealpixUtils.check(this.order <= this.omax, "order>omax");
            if (!this.inclusive) {
                HealpixUtils.check(this.order == this.omax, "inconsistency");
            }
            HealpixUtils.check(this.omax <= 29, "omax too high");
            this.op = new MocQueryOp[this.ncomp];
            this.nops = new int[this.ncomp];
            this.center = new Vec3[this.ncomp];
            for (n3 = 0; n3 < this.ncomp; ++n3) {
                this.op[n3] = arrayList.get((int)n3).op;
                this.nops[n3] = arrayList.get((int)n3).nops;
                this.center[n3] = arrayList.get((int)n3).center;
                if (this.op[n3] != MocQueryOp.NONE) continue;
                this.cr[n3] = Math.cos(arrayList.get((int)n3).radius);
            }
            this.o = 0;
            while (this.o <= this.omax) {
                this.base[this.o] = new HealpixBase(1 << this.o, Scheme.NESTED);
                double d = this.base[this.o].maxPixrad();
                for (int i = 0; i < this.ncomp; ++i) {
                    if (this.op[i] != MocQueryOp.NONE) continue;
                    double d2 = arrayList.get((int)i).radius;
                    this.crmax[this.o][i] = d2 + d >= Math.PI ? -1.01 : Math.cos(d2 + d);
                    this.crmin[this.o][i] = d2 - d <= 0.0 ? 1.01 : Math.cos(d2 - d);
                }
                ++this.o;
            }
            this.stk = new pstack(12 + 3 * this.omax);
            this.shortcut = new int[this.ncomp];
            for (n3 = 0; n3 < this.ncomp; ++n3) {
                this.loc = n3;
                this.correctLoc();
                this.shortcut[n3] = this.loc;
            }
        }

        Moc result() throws Exception {
            int n;
            Moc moc = new Moc();
            this.stk.clear();
            this.stk.mark();
            for (n = 0; n < 12; ++n) {
                this.stk.push(11 - n, 0);
            }
            while (!this.stk.empty()) {
                this.pix = this.stk.ptop();
                this.o = this.stk.otop();
                this.stk.pop();
                this.pv = this.base[this.o].pix2vec(this.pix);
                this.loc = this.ncomp - 1;
                n = this.getZone(0, 3);
                this.check_pixel(n, moc);
                HealpixUtils.check(this.loc == -1, "stack not used up");
            }
            return moc;
        }

        private final class pstack {
            private long[] p;
            private int[] o;
            private int s;
            private int m;

            public pstack(int n) {
                this.p = new long[n];
                this.o = new int[n];
                this.m = 0;
                this.s = 0;
            }

            public void push(long l, int n) {
                this.p[this.s] = l;
                this.o[this.s] = n;
                ++this.s;
            }

            public void pop() {
                --this.s;
            }

            public void popToMark() {
                this.s = this.m;
            }

            public int size() {
                return this.s;
            }

            public void mark() {
                this.m = this.s;
            }

            public int otop() {
                return this.o[this.s - 1];
            }

            public long ptop() {
                return this.p[this.s - 1];
            }

            public void clear() {
                this.m = 0;
                this.s = 0;
            }

            public boolean empty() {
                return this.s == 0;
            }
        }
    }

    public static class MocQueryComponent {
        public MocQueryOp op;
        public Vec3 center;
        public double radius;
        public int nops;

        public MocQueryComponent(MocQueryOp mocQueryOp) throws Exception {
            this.op = mocQueryOp;
            HealpixUtils.check(mocQueryOp != MocQueryOp.NONE, "bad operator");
            switch (this.op) {
                case AND: 
                case OR: 
                case XOR: {
                    this.nops = 2;
                    break;
                }
                case NOT: {
                    this.nops = 1;
                    break;
                }
                case NONE: {
                    this.nops = 0;
                }
            }
        }

        public MocQueryComponent(MocQueryOp mocQueryOp, int n) throws Exception {
            this.op = mocQueryOp;
            this.nops = n;
            switch (this.op) {
                case AND: 
                case OR: {
                    HealpixUtils.check(this.nops >= 2, "bad nops");
                    break;
                }
                case XOR: {
                    HealpixUtils.check(this.nops == 2, "bad nops");
                    break;
                }
                case NOT: {
                    HealpixUtils.check(this.nops == 1, "bad nops");
                    break;
                }
                case NONE: {
                    HealpixUtils.check(false, "bad operator");
                }
            }
        }

        public MocQueryComponent(Vec3 vec3, double d) {
            this.op = MocQueryOp.NONE;
            this.center = new Vec3(vec3);
            this.center.normalize();
            this.radius = d;
            this.nops = 0;
        }
    }

    public static enum MocQueryOp {
        AND,
        OR,
        XOR,
        NOT,
        NONE;

    }
}

