/*
 * Decompiled with CFR 0.152.
 */
package healpix.essentials;

import healpix.essentials.Moc;
import healpix.essentials.RangeSet;

public class MocStringIO {
    public static Moc mocFromString(String string) {
        string = string.replaceAll(",+", " ");
        string = string.replaceAll("[\\[\\]{}\"]+", "");
        string = string.replaceAll("\\s*[:/]\\s*", "/ ");
        string = string.replaceAll("\\s*-\\s*", "-");
        String[] stringArray = string.split("[\\s]+");
        RangeSet rangeSet = new RangeSet();
        int n = 0;
        long l = 0L;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].isEmpty()) continue;
            if (stringArray[i].contains("/")) {
                stringArray[i] = stringArray[i].split("/")[0];
                n = Integer.parseInt(stringArray[i]);
                l = 4L * (1L << 2 * n);
                continue;
            }
            if (stringArray[i].contains("-")) {
                String[] stringArray2 = stringArray[i].split("-");
                rangeSet.add(Long.parseLong(stringArray2[0]) + l, Long.parseLong(stringArray2[1]) + l + 1L);
                continue;
            }
            rangeSet.add(Long.parseLong(stringArray[i]) + l);
        }
        return Moc.fromUniqRS(rangeSet);
    }

    private static String mocToStringGeneral(Moc moc, boolean bl) {
        RangeSet rangeSet = moc.toUniqRS();
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            stringBuilder.append("{");
        }
        boolean bl2 = true;
        int n = moc.maxOrder();
        for (int i = 0; i <= n; ++i) {
            RangeSet rangeSet2 = new RangeSet();
            long l = 4L * (1L << 2 * i);
            rangeSet2.append(l, 4L * l);
            rangeSet2 = rangeSet2.intersection(rangeSet);
            boolean bl3 = false;
            if (!rangeSet2.isEmpty()) {
                for (int j = 0; j < rangeSet2.nranges(); ++j) {
                    long l2 = rangeSet2.ivbegin(j) - l;
                    long l3 = rangeSet2.ivend(j) - l;
                    if (!bl3) {
                        if (!bl2) {
                            stringBuilder.append(bl ? ", " : " ");
                        }
                        bl2 = false;
                        if (bl) {
                            stringBuilder.append("\"").append(i).append("\":[");
                        } else {
                            stringBuilder.append(i).append("/");
                        }
                        bl3 = true;
                    } else {
                        stringBuilder.append(",");
                    }
                    if (bl) {
                        for (long k = l2; k < l3 - 1L; ++k) {
                            stringBuilder.append(k).append(",");
                        }
                        stringBuilder.append(l3 - 1L);
                        continue;
                    }
                    stringBuilder.append(l2);
                    if (l3 <= l2 + 1L) continue;
                    stringBuilder.append("-").append(l3 - 1L);
                }
            }
            if (!bl || !bl3) continue;
            stringBuilder.append("]");
        }
        if (bl) {
            stringBuilder.append("}");
        }
        return stringBuilder.toString();
    }

    public static String mocToStringASCII(Moc moc) {
        return MocStringIO.mocToStringGeneral(moc, false);
    }

    public static String mocToStringJSON(Moc moc) {
        return MocStringIO.mocToStringGeneral(moc, true);
    }
}

