/*
 * Decompiled with CFR 0.152.
 */
package healpix.essentials;

import healpix.essentials.FastMath;
import healpix.essentials.HealpixUtils;
import healpix.essentials.Vec3;
import healpix.essentials.Zphi;

public class Pointing {
    public double theta;
    public double phi;

    public Pointing() {
    }

    public Pointing(Pointing pointing) {
        this.theta = pointing.theta;
        this.phi = pointing.phi;
    }

    public Pointing(double d, double d2) {
        this.theta = d;
        this.phi = d2;
    }

    public Pointing(Vec3 vec3) {
        this.theta = FastMath.atan2(Math.sqrt(vec3.x * vec3.x + vec3.y * vec3.y), vec3.z);
        this.phi = FastMath.atan2(vec3.y, vec3.x);
        if (this.phi < 0.0) {
            this.phi += Math.PI * 2;
        }
        if (this.phi >= Math.PI * 2) {
            this.phi -= Math.PI * 2;
        }
    }

    public Pointing(Zphi zphi) {
        double d = Math.sqrt((1.0 - zphi.z) * (1.0 + zphi.z));
        this.theta = FastMath.atan2(d, zphi.z);
        this.phi = zphi.phi;
    }

    public void normalizeTheta() {
        this.theta = HealpixUtils.fmodulo(this.theta, Math.PI * 2);
        if (this.theta > Math.PI) {
            this.phi += Math.PI;
            this.theta = Math.PI * 2 - this.theta;
        }
    }

    public void normalize() {
        this.normalizeTheta();
        this.phi = HealpixUtils.fmodulo(this.phi, Math.PI * 2);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ptg(");
        stringBuilder.append(this.theta);
        stringBuilder.append(",");
        stringBuilder.append(this.phi);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Pointing pointing = (Pointing)object;
        if (Double.compare(pointing.phi, this.phi) != 0) {
            return false;
        }
        return Double.compare(pointing.theta, this.theta) == 0;
    }

    public int hashCode() {
        int n = Double.valueOf(this.theta).hashCode();
        n = 31 * n + Double.valueOf(this.phi).hashCode();
        return n;
    }
}

