/*
 * Decompiled with CFR 0.152.
 */
package healpix.essentials;

import healpix.essentials.Compressor;
import healpix.essentials.HealpixUtils;
import java.util.NoSuchElementException;

public class RangeSet {
    private static final ValueIterator EMPTY_ITER = new ValueIterator(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public long next() {
            throw new NoSuchElementException();
        }
    };
    protected long[] r;
    protected int sz;

    public RangeSet() {
        this(4);
    }

    public RangeSet(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("capacity must be positive");
        }
        this.r = new long[n << 1];
        this.sz = 0;
    }

    public RangeSet(long[] lArray) {
        this.sz = lArray.length;
        this.r = new long[this.sz];
        System.arraycopy(lArray, 0, this.r, 0, this.sz);
        this.checkConsistency();
    }

    public RangeSet(RangeSet rangeSet) {
        this.sz = rangeSet.sz;
        this.r = new long[this.sz];
        System.arraycopy(rangeSet.r, 0, this.r, 0, this.sz);
    }

    public void checkConsistency() {
        if ((this.sz & 1) != 0) {
            throw new IllegalArgumentException("invalid number of entries");
        }
        for (int i = 1; i < this.sz; ++i) {
            if (this.r[i] > this.r[i - 1]) continue;
            throw new IllegalArgumentException("inconsistent entries");
        }
    }

    private void resize(int n) {
        if (n < this.sz) {
            throw new IllegalArgumentException("requested array size too small");
        }
        if (n == this.r.length) {
            return;
        }
        long[] lArray = new long[n];
        System.arraycopy(this.r, 0, lArray, 0, this.sz);
        this.r = lArray;
    }

    public void ensureCapacity(int n) {
        if (this.r.length < n) {
            this.resize(Math.max(2 * this.r.length, n));
        }
    }

    public void trimSize() {
        this.resize(this.sz);
    }

    public void trimIfTooLarge() {
        if (this.r.length - this.sz >= this.sz) {
            this.resize(this.sz);
        }
    }

    private int iiv(long l) {
        int n = this.sz;
        int n2 = 0;
        while (n > 0) {
            int n3 = n >>> 1;
            int n4 = n2 + n3;
            if (this.r[n4] <= l) {
                n2 = ++n4;
                n -= n3 + 1;
                continue;
            }
            n = n3;
        }
        return n2 - 1;
    }

    public void append(long l) {
        this.append(l, l + 1L);
    }

    public void append(long l, long l2) {
        if (l >= l2) {
            return;
        }
        if (this.sz > 0 && l <= this.r[this.sz - 1]) {
            if (l < this.r[this.sz - 2]) {
                throw new IllegalArgumentException("bad append operation");
            }
            if (l2 > this.r[this.sz - 1]) {
                this.r[this.sz - 1] = l2;
            }
            return;
        }
        this.ensureCapacity(this.sz + 2);
        this.r[this.sz] = l;
        this.r[this.sz + 1] = l2;
        this.sz += 2;
    }

    public void append(RangeSet rangeSet) {
        for (int i = 0; i < rangeSet.sz; i += 2) {
            this.append(rangeSet.r[i], rangeSet.r[i + 1]);
        }
    }

    public int nranges() {
        return this.sz >>> 1;
    }

    public boolean isEmpty() {
        return this.sz == 0;
    }

    public long ivbegin(int n) {
        return this.r[2 * n];
    }

    public long ivend(int n) {
        return this.r[2 * n + 1];
    }

    public void clear() {
        this.sz = 0;
    }

    private void pushv(long l) {
        this.ensureCapacity(this.sz + 1);
        this.r[this.sz++] = l;
    }

    private static int strategy(int n, int n2) {
        int n3;
        double d = 1.0 * (double)(n + n2);
        int n4 = n < n2 ? n : n2;
        double d2 = 1.0 * (double)n4 * Math.max(1.0, (double)HealpixUtils.ilog2(n3 = n < n2 ? n2 : n));
        return d <= d2 ? 1 : (n4 == n ? 2 : 3);
    }

    private static boolean generalAllOrNothing1(RangeSet rangeSet, RangeSet rangeSet2, boolean bl, boolean bl2) {
        boolean bl3;
        boolean bl4 = bl;
        boolean bl5 = bl2;
        boolean bl6 = bl4 || bl5;
        int n = 0;
        int n2 = rangeSet.sz;
        int n3 = 0;
        int n4 = rangeSet2.sz;
        boolean bl7 = n != n2;
        boolean bl8 = bl3 = n3 != n4;
        while (bl7 || bl3) {
            boolean bl9;
            long l = bl7 ? rangeSet.r[n] : 0L;
            long l2 = bl3 ? rangeSet2.r[n3] : 0L;
            boolean bl10 = bl7 && (!bl3 || l <= l2);
            boolean bl11 = bl9 = bl3 && (!bl7 || l2 <= l);
            if (bl10) {
                bl4 = !bl4;
                boolean bl12 = bl7 = ++n != n2;
            }
            if (bl9) {
                bl5 = !bl5;
                bl3 = ++n3 != n4;
            }
            if ((bl4 || bl5) == bl6) continue;
            return false;
        }
        return true;
    }

    private static boolean generalAllOrNothing2(RangeSet rangeSet, RangeSet rangeSet2, boolean bl, boolean bl2) {
        int n;
        int n2 = n = bl ? 0 : -1;
        while (n < rangeSet.sz) {
            if (n == -1) {
                if (!bl2 || rangeSet2.r[0] < rangeSet.r[0]) {
                    return false;
                }
            } else if (n == rangeSet.sz - 1) {
                if (!bl2 || rangeSet2.r[rangeSet2.sz - 1] > rangeSet.r[rangeSet.sz - 1]) {
                    return false;
                }
            } else {
                int n3 = rangeSet2.iiv(rangeSet.r[n]);
                if (n3 != rangeSet2.sz - 1 && rangeSet2.r[n3 + 1] < rangeSet.r[n + 1]) {
                    return false;
                }
                if (bl2 == ((n3 & 1) == 0)) {
                    return false;
                }
            }
            n += 2;
        }
        return true;
    }

    private static boolean generalAllOrNothing(RangeSet rangeSet, RangeSet rangeSet2, boolean bl, boolean bl2) {
        if (rangeSet.isEmpty()) {
            return bl ? true : rangeSet2.isEmpty();
        }
        if (rangeSet2.isEmpty()) {
            return bl2 ? true : rangeSet.isEmpty();
        }
        int n = RangeSet.strategy(rangeSet.nranges(), rangeSet2.nranges());
        return n == 1 ? RangeSet.generalAllOrNothing1(rangeSet, rangeSet2, bl, bl2) : (n == 2 ? RangeSet.generalAllOrNothing2(rangeSet, rangeSet2, bl, bl2) : RangeSet.generalAllOrNothing2(rangeSet2, rangeSet, bl2, bl));
    }

    private static RangeSet generalUnion1(RangeSet rangeSet, RangeSet rangeSet2, boolean bl, boolean bl2) {
        boolean bl3;
        RangeSet rangeSet3 = new RangeSet();
        boolean bl4 = bl;
        boolean bl5 = bl2;
        boolean bl6 = bl4 || bl5;
        int n = 0;
        int n2 = rangeSet.sz;
        int n3 = 0;
        int n4 = rangeSet2.sz;
        boolean bl7 = n != n2;
        boolean bl8 = bl3 = n3 != n4;
        while (bl7 || bl3) {
            boolean bl9;
            long l = bl7 ? rangeSet.r[n] : 0L;
            long l2 = bl3 ? rangeSet2.r[n3] : 0L;
            boolean bl10 = bl7 && (!bl3 || l <= l2);
            boolean bl11 = bl9 = bl3 && (!bl7 || l2 <= l);
            if (bl10) {
                bl4 = !bl4;
                boolean bl12 = bl7 = ++n != n2;
            }
            if (bl9) {
                bl5 = !bl5;
                bl3 = ++n3 != n4;
            }
            if ((bl4 || bl5) == bl6) continue;
            rangeSet3.pushv(bl10 ? l : l2);
            bl6 = !bl6;
        }
        return rangeSet3;
    }

    private static RangeSet generalUnion2(RangeSet rangeSet, RangeSet rangeSet2, boolean bl, boolean bl2) {
        int n;
        RangeSet rangeSet3 = new RangeSet();
        int n2 = n = bl ? 0 : -1;
        while (n < rangeSet.sz) {
            int n3 = n == -1 ? -1 : rangeSet2.iiv(rangeSet.r[n]);
            boolean bl3 = bl2 ^ (n3 & 1) == 0;
            if (n > -1 && !bl3) {
                rangeSet3.pushv(rangeSet.r[n]);
            }
            while (n3 < rangeSet2.sz - 1 && (n == rangeSet.sz - 1 || rangeSet2.r[n3 + 1] < rangeSet.r[n + 1])) {
                bl3 = !bl3;
                rangeSet3.pushv(rangeSet2.r[++n3]);
            }
            if (n < rangeSet.sz - 1 && !bl3) {
                rangeSet3.pushv(rangeSet.r[n + 1]);
            }
            n += 2;
        }
        return rangeSet3;
    }

    private static RangeSet generalUnion(RangeSet rangeSet, RangeSet rangeSet2, boolean bl, boolean bl2) {
        if (rangeSet.isEmpty()) {
            return bl ? new RangeSet() : new RangeSet(rangeSet2);
        }
        if (rangeSet2.isEmpty()) {
            return bl2 ? new RangeSet() : new RangeSet(rangeSet);
        }
        int n = RangeSet.strategy(rangeSet.nranges(), rangeSet2.nranges());
        return n == 1 ? RangeSet.generalUnion1(rangeSet, rangeSet2, bl, bl2) : (n == 2 ? RangeSet.generalUnion2(rangeSet, rangeSet2, bl, bl2) : RangeSet.generalUnion2(rangeSet2, rangeSet, bl2, bl));
    }

    public RangeSet union(RangeSet rangeSet) {
        return RangeSet.generalUnion(this, rangeSet, false, false);
    }

    public RangeSet intersection(RangeSet rangeSet) {
        return RangeSet.generalUnion(this, rangeSet, true, true);
    }

    public RangeSet difference(RangeSet rangeSet) {
        return RangeSet.generalUnion(this, rangeSet, true, false);
    }

    public boolean contains(long l) {
        return (this.iiv(l) & 1) == 0;
    }

    public boolean contains(long l, long l2) {
        int n = this.iiv(l);
        if ((n & 1) != 0) {
            return false;
        }
        return l2 <= this.r[n + 1];
    }

    @Deprecated
    public boolean containsAll(long l, long l2) {
        return this.contains(l, l2);
    }

    public boolean overlaps(long l, long l2) {
        int n = this.iiv(l);
        if ((n & 1) == 0) {
            return true;
        }
        if (n == this.sz - 1) {
            return false;
        }
        return this.r[n + 1] < l2;
    }

    @Deprecated
    public boolean containsAny(long l, long l2) {
        return this.overlaps(l, l2);
    }

    public boolean contains(RangeSet rangeSet) {
        return RangeSet.generalAllOrNothing(this, rangeSet, false, true);
    }

    @Deprecated
    public boolean containsAll(RangeSet rangeSet) {
        return this.contains(rangeSet);
    }

    public boolean overlaps(RangeSet rangeSet) {
        return !RangeSet.generalAllOrNothing(this, rangeSet, true, true);
    }

    @Deprecated
    public boolean containsAny(RangeSet rangeSet) {
        return this.overlaps(rangeSet);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof RangeSet)) {
            return false;
        }
        RangeSet rangeSet = (RangeSet)object;
        if (rangeSet.sz != this.sz) {
            return false;
        }
        for (int i = 0; i < this.sz; ++i) {
            if (rangeSet.r[i] == this.r[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = Integer.valueOf(this.sz).hashCode();
        for (int i = 0; i < this.sz; ++i) {
            n = 31 * n + Long.valueOf(this.r[this.sz]).hashCode();
        }
        return n;
    }

    public long nval() {
        long l = 0L;
        for (int i = 0; i < this.sz; i += 2) {
            l += this.r[i + 1] - this.r[i];
        }
        return l;
    }

    private void addRemove(long l, long l2, int n) {
        boolean bl;
        int n2;
        boolean bl2;
        int n3;
        int n4 = this.iiv(l);
        int n5 = this.iiv(l2);
        if (n4 >= 0 && this.r[n4] == l) {
            --n4;
        }
        if (((n3 = n5 - ((bl2 = (n5 & 1) == n) ? 1 : 0)) - (n2 = n4 + 1 + ((bl = (n4 & 1) == n) ? 1 : 0)) & 1) == 0) {
            throw new IllegalArgumentException("cannot happen: " + n2 + " " + n3);
        }
        if (bl && bl2 && n4 + 1 > n5) {
            this.ensureCapacity(this.sz + 2);
            System.arraycopy(this.r, n4 + 1, this.r, n4 + 3, this.sz - n4 - 1);
            this.r[n4 + 1] = l;
            this.r[n4 + 2] = l2;
            this.sz += 2;
        } else {
            if (bl) {
                this.r[n4 + 1] = l;
            }
            if (bl2) {
                this.r[n5] = l2;
            }
            if (n2 != n3 + 1) {
                System.arraycopy(this.r, n3 + 1, this.r, n2, this.sz - n3 - 1);
            }
            this.sz -= n3 - n2 + 1;
        }
    }

    public void intersect(long l, long l2) {
        int n = this.iiv(l);
        int n2 = this.iiv(l2);
        if (n2 >= 0 && this.r[n2] == l2) {
            --n2;
        }
        boolean bl = (n & 1) == 0;
        boolean bl2 = (n2 & 1) == 0;
        this.sz = n2 + 1;
        if (bl2) {
            this.r[this.sz++] = l2;
        }
        if (bl) {
            this.r[n--] = l;
        }
        if (n >= 0) {
            System.arraycopy(this.r, n + 1, this.r, 0, this.sz - n - 1);
        }
        this.sz -= n + 1;
        if ((this.sz & 1) != 0) {
            throw new IllegalArgumentException("cannot happen");
        }
    }

    public void add(long l, long l2) {
        if (this.sz == 0 || l >= this.r[this.sz - 1]) {
            this.append(l, l2);
        } else {
            this.addRemove(l, l2, 1);
        }
    }

    public void add(long l) {
        if (this.sz == 0 || l >= this.r[this.sz - 1]) {
            this.append(l, l + 1L);
        } else {
            this.addRemove(l, l + 1L, 1);
        }
    }

    public void remove(long l, long l2) {
        this.addRemove(l, l2, 0);
    }

    public void remove(long l) {
        this.addRemove(l, l + 1L, 0);
    }

    public long[] toArray() {
        long[] lArray = new long[(int)this.nval()];
        int n = 0;
        for (int i = 0; i < this.sz; i += 2) {
            long l = this.r[i];
            while (l < this.r[i + 1]) {
                lArray[n++] = l++;
            }
        }
        return lArray;
    }

    public static RangeSet fromArray(long[] lArray) {
        RangeSet rangeSet = new RangeSet();
        for (int i = 0; i < lArray.length; ++i) {
            rangeSet.append(lArray[i]);
        }
        return rangeSet;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{ ");
        for (int i = 0; i < this.sz; i += 2) {
            stringBuilder.append("[").append(this.r[i]).append(";").append(this.r[i + 1]).append("[");
            if (i >= this.sz - 2) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append(" }");
        return stringBuilder.toString();
    }

    public ValueIterator valueIterator() {
        if (this.sz == 0) {
            return EMPTY_ITER;
        }
        return new ValueIterator(){
            int pos = 0;
            long value;
            {
                this.value = RangeSet.this.sz > 0 ? RangeSet.this.r[0] : 0L;
            }

            @Override
            public boolean hasNext() {
                return this.pos < RangeSet.this.sz;
            }

            @Override
            public long next() {
                if (this.pos > RangeSet.this.sz) {
                    throw new NoSuchElementException();
                }
                long l = this.value++;
                if (this.value == RangeSet.this.r[this.pos + 1]) {
                    this.pos += 2;
                    if (this.pos < RangeSet.this.sz) {
                        this.value = RangeSet.this.r[this.pos];
                    }
                }
                return l;
            }
        };
    }

    public byte[] toCompressed() throws Exception {
        return Compressor.interpol_encode(this.r, 0, this.sz);
    }

    public static RangeSet fromCompressed(byte[] byArray) throws Exception {
        return new RangeSet(Compressor.interpol_decode(byArray));
    }

    public static interface ValueIterator {
        public boolean hasNext();

        public long next();
    }
}

