/*
 * Decompiled with CFR 0.152.
 */
package healpix.essentials;

import healpix.essentials.FastMath;
import healpix.essentials.Pointing;
import healpix.essentials.Zphi;

public class Vec3 {
    public double x;
    public double y;
    public double z;

    public Vec3() {
    }

    public Vec3(Vec3 vec3) {
        this.x = vec3.x;
        this.y = vec3.y;
        this.z = vec3.z;
    }

    public Vec3(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public Vec3(Pointing pointing) {
        double d = FastMath.sin(pointing.theta);
        this.x = d * FastMath.cos(pointing.phi);
        this.y = d * FastMath.sin(pointing.phi);
        this.z = FastMath.cos(pointing.theta);
    }

    public Vec3(Zphi zphi) {
        double d = Math.sqrt((1.0 - zphi.z) * (1.0 + zphi.z));
        this.x = d * FastMath.cos(zphi.phi);
        this.y = d * FastMath.sin(zphi.phi);
        this.z = zphi.z;
    }

    public Vec3(double[] dArray) {
        if (dArray.length != 3) {
            throw new IllegalArgumentException("Wrong array size");
        }
        this.x = dArray[0];
        this.y = dArray[1];
        this.z = dArray[2];
    }

    public final double length() {
        return Math.sqrt(this.lengthSquared());
    }

    public final double lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public void normalize() {
        double d = 1.0 / this.length();
        this.x *= d;
        this.y *= d;
        this.z *= d;
    }

    public Vec3 norm() {
        double d = 1.0 / this.length();
        return new Vec3(this.x * d, this.y * d, this.z * d);
    }

    public final double angle(Vec3 vec3) {
        return FastMath.atan2(this.cross(vec3).length(), this.dot(vec3));
    }

    public Vec3 cross(Vec3 vec3) {
        return new Vec3(this.y * vec3.z - vec3.y * this.z, this.z * vec3.x - vec3.z * this.x, this.x * vec3.y - vec3.x * this.y);
    }

    public Vec3 mul(double d) {
        return new Vec3(d * this.x, d * this.y, d * this.z);
    }

    public void flip() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
    }

    public Vec3 flipped() {
        return new Vec3(-this.x, -this.y, -this.z);
    }

    public void scale(double d) {
        this.x *= d;
        this.y *= d;
        this.z *= d;
    }

    public final double dot(Vec3 vec3) {
        return this.x * vec3.x + this.y * vec3.y + this.z * vec3.z;
    }

    public Vec3 add(Vec3 vec3) {
        return new Vec3(this.x + vec3.x, this.y + vec3.y, this.z + vec3.z);
    }

    public Vec3 sub(Vec3 vec3) {
        return new Vec3(this.x - vec3.x, this.y - vec3.y, this.z - vec3.z);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("vec3(");
        stringBuilder.append(this.x);
        stringBuilder.append(",");
        stringBuilder.append(this.y);
        stringBuilder.append(",");
        stringBuilder.append(this.z);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public double[] toArray() {
        return new double[]{this.x, this.y, this.z};
    }

    public void toArray(double[] dArray) {
        if (dArray.length != 3) {
            throw new IllegalArgumentException("wrong array size");
        }
        dArray[0] = this.x;
        dArray[1] = this.y;
        dArray[2] = this.z;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Vec3 vec3 = (Vec3)object;
        if (Double.compare(vec3.x, this.x) != 0) {
            return false;
        }
        if (Double.compare(vec3.y, this.y) != 0) {
            return false;
        }
        return Double.compare(vec3.z, this.z) == 0;
    }

    public int hashCode() {
        int n = Double.valueOf(this.x).hashCode();
        n = 31 * n + Double.valueOf(this.y).hashCode();
        n = 31 * n + Double.valueOf(this.z).hashCode();
        return n;
    }
}

