/*
 * Decompiled with CFR 0.152.
 */
package healpix.essentials;

import healpix.essentials.FastMath;
import healpix.essentials.Pointing;
import healpix.essentials.Vec3;

public final class Zphi {
    public double z;
    public double phi;

    public Zphi() {
    }

    public Zphi(double d, double d2) {
        this.z = d;
        this.phi = d2;
    }

    public Zphi(Vec3 vec3) {
        this.z = vec3.z / vec3.length();
        this.phi = FastMath.atan2(vec3.y, vec3.x);
    }

    public Zphi(Pointing pointing) {
        this.z = FastMath.cos(pointing.theta);
        this.phi = pointing.phi;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("zphi(");
        stringBuilder.append(this.z);
        stringBuilder.append(",");
        stringBuilder.append(this.phi);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Zphi zphi = (Zphi)object;
        if (Double.compare(zphi.phi, this.phi) != 0) {
            return false;
        }
        return Double.compare(zphi.z, this.z) == 0;
    }

    public int hashCode() {
        long l = this.z != 0.0 ? Double.doubleToLongBits(this.z) : 0L;
        int n = (int)(l ^ l >>> 32);
        l = this.phi != 0.0 ? Double.doubleToLongBits(this.phi) : 0L;
        n = 31 * n + (int)(l ^ l >>> 32);
        return n;
    }
}

