/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.plastic;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcException;
import uk.ac.starlink.plastic.Agent;
import uk.ac.starlink.plastic.PlasticUtils;

class XmlRpcAgent
extends Agent {
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.plastic");
    private final XmlRpcClient client_;
    private final String connection_;

    public XmlRpcAgent(int iseq, String name, URI[] supportedMessages, URL xmlrpcUrl) {
        super(iseq, name, supportedMessages);
        this.client_ = PlasticUtils.createXmlRpcClient(xmlrpcUrl);
        this.connection_ = "XMLRPC: " + xmlrpcUrl;
    }

    public Object request(URI sender, URI message, List args) throws IOException {
        Vector<Object> argv = new Vector<Object>();
        argv.add(sender.toString());
        argv.add(message.toString());
        argv.add(XmlRpcAgent.doctorObject(args));
        try {
            String method = PlasticUtils.XMLRPC_PREFIX == null ? "perform" : PlasticUtils.XMLRPC_PREFIX + ".perform";
            Object result = this.client_.execute(method, argv);
            if (result instanceof IOException) {
                throw (IOException)result;
            }
            if (result instanceof Throwable) {
                Throwable err = (Throwable)result;
                throw (IOException)new IOException(err.getMessage()).initCause(err);
            }
            return result;
        }
        catch (IOException e) {
            throw e;
        }
        catch (XmlRpcException e) {
            return (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }

    public static Object doctorObject(Object obj) {
        if (obj == null) {
            return new Vector();
        }
        if (obj instanceof URL) {
            return obj.toString();
        }
        if (obj instanceof URI) {
            return obj.toString();
        }
        if (obj instanceof Collection) {
            Vector<Object> vec = new Vector<Object>();
            Iterator it = ((Collection)obj).iterator();
            while (it.hasNext()) {
                vec.add(XmlRpcAgent.doctorObject(it.next()));
            }
            return vec;
        }
        if (obj instanceof Object[]) {
            Vector<Object> vec = new Vector<Object>();
            Object[] array = (Object[])obj;
            for (int i = 0; i < array.length; ++i) {
                vec.add(XmlRpcAgent.doctorObject(array[i]));
            }
            return vec;
        }
        if (obj instanceof Map) {
            Hashtable<String, Object> hash = new Hashtable<String, Object>();
            Iterator it = ((Map)obj).entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                hash.put(String.valueOf(entry.getKey()), XmlRpcAgent.doctorObject(entry.getValue()));
            }
            return hash;
        }
        if (obj instanceof Throwable) {
            logger_.log(Level.WARNING, "XML-RPC exception: " + obj, (Throwable)obj);
            return new Vector();
        }
        if (obj instanceof Integer || obj instanceof Boolean || obj instanceof String || obj instanceof Double || obj instanceof Date || obj instanceof byte[]) {
            return obj;
        }
        logger_.warning("Bad XML-RPC object type " + obj.getClass().getName() + " - using empty list");
        return new Vector();
    }
}

