/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.injection;

import com.google.inject.AbstractModule;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.binder.AnnotatedBindingBuilder;
import com.google.inject.binder.LinkedBindingBuilder;
import com.google.inject.binder.ScopedBindingBuilder;
import com.google.inject.name.Named;
import com.google.inject.util.Providers;
import griffon.core.injection.Binding;
import griffon.core.injection.InstanceBinding;
import griffon.core.injection.ProviderBinding;
import griffon.core.injection.ProviderTypeBinding;
import griffon.core.injection.Qualified;
import griffon.core.injection.TargetBinding;
import griffon.exceptions.ClosedInjectorException;
import griffon.exceptions.InstanceNotFoundException;
import griffon.exceptions.MembersInjectionException;
import griffon.util.AnnotationUtils;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.codehaus.griffon.runtime.injection.InstanceTracker;

public class GuiceInjector
implements griffon.core.injection.Injector<Injector> {
    private static final String ERROR_TYPE_NULL = "Argument 'type' must not be null";
    private static final String ERROR_DELEGATE_NULL = "Argument 'delegate' must not be null";
    private static final String ERROR_INSTANCE_TRACKER_NULL = "Argument 'instanceTracker' must not be null";
    private static final String ERROR_QUALIFIER_NULL = "Argument 'qualifier' must not be null";
    private static final String ERROR_INSTANCE_NULL = "Argument 'instance' must not be null";
    private final InstanceTracker instanceTracker;
    private final Injector delegate;
    private final Object lock = new Object[0];
    @GuardedBy(value="lock")
    private boolean closed;

    public GuiceInjector(@Nonnull InstanceTracker instanceTracker) {
        this.instanceTracker = Objects.requireNonNull(instanceTracker, ERROR_INSTANCE_TRACKER_NULL);
        this.delegate = Objects.requireNonNull(instanceTracker.getInjector(), ERROR_DELEGATE_NULL);
    }

    static Module moduleFromBindings(final @Nonnull Iterable<Binding<?>> iterable) {
        return new AbstractModule(){

            protected void configure() {
                for (Binding binding : iterable) {
                    if (binding instanceof TargetBinding) {
                        this.handleTargetBinding((TargetBinding)binding);
                        continue;
                    }
                    if (binding instanceof InstanceBinding) {
                        this.handleInstanceBinding((InstanceBinding)binding);
                        continue;
                    }
                    if (binding instanceof ProviderTypeBinding) {
                        this.handleProviderTypeBinding((ProviderTypeBinding)binding);
                        continue;
                    }
                    if (binding instanceof ProviderBinding) {
                        this.handleProviderBinding((ProviderBinding)binding);
                        continue;
                    }
                    throw new IllegalArgumentException("Don't know how to handle " + binding);
                }
            }

            @Nonnull
            private LinkedBindingBuilder handleBinding(@Nonnull Binding<?> binding) {
                AnnotatedBindingBuilder annotatedBindingBuilder = this.bind(binding.getSource());
                if (binding.getClassifier() != null) {
                    return annotatedBindingBuilder.annotatedWith(binding.getClassifier());
                }
                if (binding.getClassifierType() != null) {
                    return annotatedBindingBuilder.annotatedWith(binding.getClassifierType());
                }
                return annotatedBindingBuilder;
            }

            private void handleTargetBinding(@Nonnull TargetBinding<?> targetBinding) {
                LinkedBindingBuilder linkedBindingBuilder = this.handleBinding((Binding<?>)targetBinding);
                if (targetBinding.getSource() != targetBinding.getTarget()) {
                    ScopedBindingBuilder scopedBindingBuilder = linkedBindingBuilder.to(targetBinding.getTarget());
                    if (targetBinding.isSingleton()) {
                        scopedBindingBuilder.in(Singleton.class);
                    }
                } else if (targetBinding.isSingleton()) {
                    linkedBindingBuilder.in(Singleton.class);
                }
            }

            private void handleInstanceBinding(@Nonnull InstanceBinding<?> instanceBinding) {
                this.handleBinding((Binding<?>)instanceBinding).toInstance(instanceBinding.getInstance());
            }

            private void handleProviderTypeBinding(@Nonnull ProviderTypeBinding<?> providerTypeBinding) {
                ScopedBindingBuilder scopedBindingBuilder = this.handleBinding((Binding<?>)providerTypeBinding).toProvider(providerTypeBinding.getProviderType());
                if (providerTypeBinding.isSingleton()) {
                    scopedBindingBuilder.in(Singleton.class);
                }
            }

            private void handleProviderBinding(@Nonnull ProviderBinding<?> providerBinding) {
                ScopedBindingBuilder scopedBindingBuilder = this.handleBinding((Binding<?>)providerBinding).toProvider(Providers.guicify((Provider)providerBinding.getProvider()));
                if (providerBinding.isSingleton()) {
                    scopedBindingBuilder.in(Singleton.class);
                }
            }
        };
    }

    @Nonnull
    public <T> T getInstance(@Nonnull Class<T> clazz) throws InstanceNotFoundException {
        Objects.requireNonNull(clazz, ERROR_TYPE_NULL);
        if (this.isClosed()) {
            throw new InstanceNotFoundException(clazz, (Throwable)new ClosedInjectorException((griffon.core.injection.Injector)this));
        }
        try {
            return (T)this.delegate.getInstance(clazz);
        }
        catch (RuntimeException runtimeException) {
            throw new InstanceNotFoundException(clazz, (Throwable)runtimeException);
        }
    }

    @Nonnull
    public <T> T getInstance(@Nonnull Class<T> clazz, @Nonnull Annotation annotation) throws InstanceNotFoundException {
        Objects.requireNonNull(clazz, ERROR_TYPE_NULL);
        Objects.requireNonNull(annotation, ERROR_QUALIFIER_NULL);
        if (this.isClosed()) {
            throw new InstanceNotFoundException(clazz, annotation, (Throwable)new ClosedInjectorException((griffon.core.injection.Injector)this));
        }
        try {
            return (T)this.delegate.getInstance(Key.get(clazz, (Annotation)annotation));
        }
        catch (RuntimeException runtimeException) {
            throw new InstanceNotFoundException(clazz, annotation, (Throwable)runtimeException);
        }
    }

    @Nonnull
    public <T> Collection<T> getInstances(@Nonnull Class<T> clazz) throws InstanceNotFoundException {
        List list;
        Objects.requireNonNull(clazz, ERROR_TYPE_NULL);
        if (this.isClosed()) {
            throw new InstanceNotFoundException(clazz, (Throwable)new ClosedInjectorException((griffon.core.injection.Injector)this));
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        try {
            list = this.delegate.findBindingsByType(TypeLiteral.get(clazz));
        }
        catch (RuntimeException runtimeException) {
            throw new InstanceNotFoundException(clazz, (Throwable)runtimeException);
        }
        if (list == null) {
            throw new InstanceNotFoundException(clazz);
        }
        for (com.google.inject.Binding binding : list) {
            try {
                arrayList.add(this.delegate.getInstance(binding.getKey()));
            }
            catch (RuntimeException runtimeException) {
                throw new InstanceNotFoundException(clazz, (Throwable)runtimeException);
            }
        }
        return arrayList;
    }

    @Nonnull
    public <T> Collection<Qualified<T>> getQualifiedInstances(@Nonnull Class<T> clazz) throws InstanceNotFoundException {
        List list;
        Objects.requireNonNull(clazz, ERROR_TYPE_NULL);
        if (this.isClosed()) {
            throw new InstanceNotFoundException(clazz, (Throwable)new ClosedInjectorException((griffon.core.injection.Injector)this));
        }
        ArrayList<Qualified<T>> arrayList = new ArrayList<Qualified<T>>();
        try {
            list = this.delegate.findBindingsByType(TypeLiteral.get(clazz));
        }
        catch (RuntimeException runtimeException) {
            throw new InstanceNotFoundException(clazz, (Throwable)runtimeException);
        }
        if (list == null) {
            throw new InstanceNotFoundException(clazz);
        }
        for (com.google.inject.Binding binding : list) {
            try {
                Key key = binding.getKey();
                Object object = this.delegate.getInstance(key);
                arrayList.add(new Qualified(object, this.translate(key.getAnnotation())));
            }
            catch (RuntimeException runtimeException) {
                throw new InstanceNotFoundException(clazz, (Throwable)runtimeException);
            }
        }
        return arrayList;
    }

    @Nullable
    private Annotation translate(@Nullable Annotation annotation) {
        if (annotation instanceof Named) {
            return AnnotationUtils.named((String)((Named)annotation).value());
        }
        return annotation;
    }

    public void injectMembers(@Nonnull Object object) throws MembersInjectionException {
        Objects.requireNonNull(object, ERROR_INSTANCE_NULL);
        if (this.isClosed()) {
            throw new MembersInjectionException(object, (Throwable)new ClosedInjectorException((griffon.core.injection.Injector)this));
        }
        try {
            this.delegate.injectMembers(object);
        }
        catch (RuntimeException runtimeException) {
            throw new MembersInjectionException(object, (Throwable)runtimeException);
        }
    }

    @Nonnull
    public Injector getDelegateInjector() {
        return this.delegate;
    }

    public void release(@Nonnull Object object) {
        this.instanceTracker.release(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.isClosed()) {
            throw new ClosedInjectorException((griffon.core.injection.Injector)this);
        }
        this.instanceTracker.releaseAll();
        Object object = this.lock;
        synchronized (object) {
            this.closed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isClosed() {
        Object object = this.lock;
        synchronized (object) {
            return this.closed;
        }
    }
}

