/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.injection;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.AbstractMatcher;
import com.google.inject.matcher.Matcher;
import com.google.inject.matcher.Matchers;
import com.google.inject.spi.InjectionListener;
import com.google.inject.spi.ProvisionListener;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import com.google.inject.util.Providers;
import griffon.core.ApplicationEvent;
import griffon.core.GriffonApplication;
import griffon.core.artifact.GriffonArtifact;
import griffon.core.injection.Binding;
import griffon.core.injection.InjectorFactory;
import griffon.util.AnnotationUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.codehaus.griffon.runtime.core.injection.InjectorProvider;
import org.codehaus.griffon.runtime.injection.GuiceInjector;
import org.codehaus.griffon.runtime.injection.InstanceTracker;
import org.codehaus.griffon.runtime.injection.MethodUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuiceInjectorFactory
implements InjectorFactory {
    private static final Logger LOG = LoggerFactory.getLogger(GuiceInjectorFactory.class);

    @Nonnull
    public GuiceInjector createInjector(@Nonnull GriffonApplication griffonApplication, @Nonnull Iterable<Binding<?>> iterable) {
        Objects.requireNonNull(griffonApplication, "Argument 'application' must not be null");
        Objects.requireNonNull(iterable, "Argument 'bindings' must not be null");
        InjectorProvider injectorProvider = new InjectorProvider();
        GuiceInjector guiceInjector = this.createModules(griffonApplication, injectorProvider, iterable);
        injectorProvider.setInjector((griffon.core.injection.Injector)guiceInjector);
        return guiceInjector;
    }

    private GuiceInjector createModules(final @Nonnull GriffonApplication griffonApplication, final @Nonnull InjectorProvider injectorProvider, @Nonnull Iterable<Binding<?>> iterable) {
        Module module2;
        InjectionListener<GriffonArtifact> injectionListener = new InjectionListener<GriffonArtifact>(){

            public void afterInjection(GriffonArtifact griffonArtifact) {
                griffonApplication.getEventRouter().publishEvent(ApplicationEvent.NEW_INSTANCE.getName(), Arrays.asList(griffonArtifact.getClass(), griffonArtifact));
            }
        };
        InjectionListener<Object> injectionListener2 = new InjectionListener<Object>(){

            public void afterInjection(Object object) {
                MethodUtils.invokeAnnotatedMethod(object, PostConstruct.class);
            }
        };
        InstanceTracker instanceTracker = new InstanceTracker();
        AbstractModule abstractModule = new AbstractModule((InjectionListener)injectionListener, (InjectionListener)injectionListener2, instanceTracker){
            final /* synthetic */ InjectionListener val$injectionListener;
            final /* synthetic */ InjectionListener val$postConstructorInjectorListener;
            final /* synthetic */ InstanceTracker val$instanceTracker;
            {
                this.val$injectionListener = injectionListener;
                this.val$postConstructorInjectorListener = injectionListener2;
                this.val$instanceTracker = instanceTracker;
            }

            protected void configure() {
                this.bind(griffon.core.injection.Injector.class).toProvider(Providers.guicify((Provider)injectorProvider)).in(Singleton.class);
                this.bindListener((Matcher)new AbstractMatcher<TypeLiteral<?>>(){

                    public boolean matches(TypeLiteral<?> typeLiteral) {
                        return GriffonArtifact.class.isAssignableFrom(typeLiteral.getRawType());
                    }
                }, new TypeListener(){

                    public <I> void hear(TypeLiteral<I> typeLiteral, TypeEncounter<I> typeEncounter) {
                        if (GriffonArtifact.class.isAssignableFrom(typeLiteral.getRawType())) {
                            TypeEncounter<I> typeEncounter2 = typeEncounter;
                            typeEncounter2.register(val$injectionListener);
                        }
                    }
                });
                this.bindListener(Matchers.any(), new TypeListener(){

                    public <I> void hear(TypeLiteral<I> typeLiteral, TypeEncounter<I> typeEncounter) {
                        typeEncounter.register(val$postConstructorInjectorListener);
                    }
                });
                this.bindListener(Matchers.any(), new ProvisionListener[]{new ProvisionListener(){

                    public <T> void onProvision(ProvisionListener.ProvisionInvocation<T> provisionInvocation) {
                        val$instanceTracker.track(provisionInvocation.getBinding(), provisionInvocation.provision());
                    }
                }});
            }
        };
        ArrayList<3> arrayList = new ArrayList<3>();
        arrayList.add(abstractModule);
        arrayList.add(GuiceInjector.moduleFromBindings(iterable));
        ArrayList<Module> arrayList2 = new ArrayList<Module>();
        ServiceLoader<Module> serviceLoader = ServiceLoader.load(Module.class, this.getClass().getClassLoader());
        for (Module module2 : serviceLoader) {
            LOG.trace("Adding module {}", (Object)module2);
            arrayList2.add(module2);
        }
        Map map = AnnotationUtils.sortByDependencies(arrayList2, (String)"Module", (String)"module");
        arrayList.addAll(map.values());
        module2 = Guice.createInjector(arrayList);
        instanceTracker.setInjector((Injector)module2);
        return new GuiceInjector(instanceTracker);
    }
}

