/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.injection;

import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.Scopes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.PreDestroy;
import org.codehaus.griffon.runtime.core.injection.InjectionUnitOfWork;
import org.codehaus.griffon.runtime.injection.MethodUtils;

class InstanceTracker {
    private static final String ERROR_INSTANCE_NULL = "Argument 'instance' must not be null";
    private static final String ERROR_BINDING_NULL = "Argument 'binding' must not be null";
    private final Map<Object, Binding<?>> instanceToKeyMap = Collections.synchronizedMap(new LinkedHashMap());
    private Injector injector;

    InstanceTracker() {
    }

    public void setInjector(@Nonnull Injector injector) {
        this.injector = injector;
    }

    @Nonnull
    public Injector getInjector() {
        return this.injector;
    }

    @Nonnull
    public <T> T track(@Nonnull Binding<?> binding, @Nonnull T t) {
        Objects.requireNonNull(binding, ERROR_BINDING_NULL);
        Objects.requireNonNull(t, ERROR_INSTANCE_NULL);
        if (MethodUtils.hasMethodAnnotatedwith(t, PreDestroy.class)) {
            if (Scopes.isSingleton(binding)) {
                this.instanceToKeyMap.put(t, binding);
            } else {
                try {
                    InjectionUnitOfWork.track(t);
                }
                catch (IllegalStateException illegalStateException) {
                    this.instanceToKeyMap.put(t, binding);
                }
            }
        }
        return t;
    }

    public <T> void release(@Nonnull T t) {
        Objects.requireNonNull(t, ERROR_INSTANCE_NULL);
        MethodUtils.invokeAnnotatedMethod(t, PreDestroy.class);
        Binding<?> binding = this.instanceToKeyMap.get(t);
        if (binding != null) {
            this.instanceToKeyMap.remove(t);
        }
    }

    public void releaseAll() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.addAll(this.instanceToKeyMap.keySet());
        this.instanceToKeyMap.clear();
        Collections.reverse(arrayList);
        for (Object e : arrayList) {
            MethodUtils.invokeAnnotatedMethod(e, PreDestroy.class);
        }
        arrayList.clear();
    }
}

