/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.injection;

import griffon.exceptions.InstanceMethodInvocationException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public final class MethodUtils {
    public static boolean hasMethodAnnotatedwith(@Nonnull Object object, @Nonnull Class<? extends Annotation> clazz) {
        for (Class<?> clazz2 = object.getClass(); clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            boolean bl = false;
            for (Method method : clazz2.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(clazz) || method.getParameterTypes().length != 0) continue;
                return true;
            }
        }
        return false;
    }

    public static void invokeAnnotatedMethod(final @Nonnull Object object, @Nonnull Class<? extends Annotation> clazz) {
        ArrayList<Method> arrayList = new ArrayList<Method>();
        for (Class<?> clazz2 = object.getClass(); clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            boolean bl = false;
            for (Method method : clazz2.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(clazz) || method.getParameterTypes().length != 0) continue;
                if (bl) {
                    throw new InstanceMethodInvocationException(object, method, MethodUtils.buildCause(object.getClass(), method, arrayList));
                }
                arrayList.add(method);
                bl = true;
            }
        }
        for (final Method method : arrayList) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    boolean bl = method.isAccessible();
                    try {
                        method.setAccessible(true);
                        Object object2 = method.invoke(object, new Object[0]);
                        return object2;
                    }
                    catch (IllegalAccessException | IllegalArgumentException exception) {
                        throw new InstanceMethodInvocationException(object, method.getName(), null, (Throwable)exception);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        throw new InstanceMethodInvocationException(object, method.getName(), null, invocationTargetException.getTargetException());
                    }
                    finally {
                        method.setAccessible(bl);
                    }
                }
            });
        }
    }

    @Nonnull
    private static Throwable buildCause(@Nonnull Class<?> clazz, @Nonnull Method method, @Nonnull List<Method> list) {
        StringBuilder stringBuilder = new StringBuilder("The following methods were found annotated with @PostConstruct on ").append(clazz);
        for (Method method2 : list) {
            stringBuilder.append("\n  ").append(method2.toGenericString());
        }
        stringBuilder.append("\n  ").append(method.toGenericString());
        return new IllegalStateException(stringBuilder.toString());
    }
}

