/*
 * Decompiled with CFR 0.152.
 */
package griffon.core.editors;

import griffon.core.editors.CalendarPropertyEditor;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Calendar;
import java.util.Date;

public class ExtendedCalendarPropertyEditor
extends CalendarPropertyEditor {
    protected void setValueInternal(Object object) {
        if (object instanceof LocalDate) {
            this.handleAsLocalDate((LocalDate)object);
        } else if (object instanceof LocalDateTime) {
            this.handleAsLocalDateTime((LocalDateTime)object);
        } else {
            super.setValueInternal(object);
        }
    }

    protected void handleAsLocalDate(LocalDate localDate) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(localDate.toEpochDay()));
        super.setValueInternal((Object)calendar);
    }

    protected void handleAsLocalDateTime(LocalDateTime localDateTime) {
        LocalDate localDate = localDateTime.toLocalDate();
        LocalTime localTime = localDateTime.toLocalTime();
        Calendar calendar = Calendar.getInstance();
        calendar.set(localDate.getYear(), localDate.getMonthValue() - 1, localDate.getDayOfMonth(), localTime.getHour(), localTime.getMinute(), localTime.getSecond());
        super.setValueInternal((Object)calendar);
    }
}

