/*
 * Decompiled with CFR 0.152.
 */
package griffon.core.editors;

import griffon.core.editors.AbstractPropertyEditor;
import griffon.core.formatters.Formatter;
import griffon.core.formatters.LocalDateFormatter;
import griffon.util.GriffonNameUtils;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class LocalDatePropertyEditor
extends AbstractPropertyEditor {
    protected void setValueInternal(Object object) {
        if (null == object) {
            super.setValueInternal(null);
        } else if (object instanceof CharSequence) {
            this.handleAsString(String.valueOf(object));
        } else if (object instanceof LocalDate) {
            super.setValueInternal(object);
        } else if (object instanceof LocalDateTime) {
            super.setValueInternal((Object)((LocalDateTime)object).toLocalDate());
        } else if (object instanceof Date) {
            super.setValueInternal((Object)LocalDate.ofEpochDay(((Date)object).getTime()));
        } else if (object instanceof Calendar) {
            super.setValueInternal((Object)LocalDate.ofEpochDay(((Calendar)object).getTime().getTime()));
        } else if (object instanceof Number) {
            super.setValueInternal((Object)LocalDate.ofEpochDay(((Number)object).longValue()));
        } else if (object instanceof List) {
            this.handleAsList((List)object);
        } else if (object instanceof Map) {
            this.handleAsMap((Map)object);
        } else {
            throw this.illegalValue(object, LocalDate.class);
        }
    }

    protected void handleAsString(String string) {
        if (GriffonNameUtils.isBlank((String)string)) {
            super.setValueInternal(null);
            return;
        }
        try {
            super.setValueInternal((Object)LocalDate.parse(string));
        }
        catch (DateTimeParseException dateTimeParseException) {
            throw this.illegalValue(string, LocalDate.class, dateTimeParseException);
        }
    }

    protected Formatter<LocalDate> resolveFormatter() {
        return GriffonNameUtils.isBlank((String)this.getFormat()) ? null : new LocalDateFormatter(this.getFormat());
    }

    protected void handleAsList(List<?> list) {
        if (list.isEmpty()) {
            super.setValueInternal(null);
            return;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.addAll(list);
        if (arrayList.size() != 3) {
            throw this.illegalValue(list, LocalDate.class);
        }
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Object e = arrayList.get(i);
            if (e instanceof Number) {
                arrayList.set(i, this.parse((Number)e));
                continue;
            }
            if (e instanceof CharSequence) {
                arrayList.set(i, this.parse(String.valueOf(e)));
                continue;
            }
            throw this.illegalValue(list, LocalDate.class);
        }
        super.setValueInternal((Object)LocalDate.of((int)((Integer)arrayList.get(0)), (Integer)arrayList.get(1), (int)((Integer)arrayList.get(2))));
    }

    protected void handleAsMap(Map<?, ?> map) {
        if (map.isEmpty()) {
            super.setValueInternal(null);
            return;
        }
        int n = this.getMapValue(map, "year", 1970);
        int n2 = this.getMapValue(map, "month", 1);
        int n3 = this.getMapValue(map, "day", 1);
        super.setValueInternal((Object)LocalDate.of(n, n2, n3));
    }

    protected int parse(String string) {
        try {
            return Integer.parseInt(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw this.illegalValue(string, LocalDate.class, numberFormatException);
        }
    }

    protected int parse(Number number) {
        return number.intValue();
    }

    protected int getMapValue(Map<?, ?> map, String string, int n) {
        Object obj = map.get(string);
        if (null == obj) {
            obj = map.get(String.valueOf(string.charAt(0)));
        }
        if (null == obj) {
            return n;
        }
        if (obj instanceof CharSequence) {
            return this.parse(String.valueOf(obj));
        }
        if (obj instanceof Number) {
            return this.parse((Number)obj);
        }
        throw this.illegalValue(map, LocalDate.class);
    }
}

