/*
 * Decompiled with CFR 0.152.
 */
package griffon.core.editors;

import griffon.core.editors.AbstractPropertyEditor;
import griffon.core.formatters.Formatter;
import griffon.core.formatters.LocalDateTimeFormatter;
import griffon.util.GriffonNameUtils;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class LocalDateTimePropertyEditor
extends AbstractPropertyEditor {
    protected void setValueInternal(Object object) {
        if (null == object) {
            super.setValueInternal(null);
        } else if (object instanceof CharSequence) {
            this.handleAsString(String.valueOf(object));
        } else if (object instanceof LocalDateTime) {
            super.setValueInternal(object);
        } else if (object instanceof LocalDate) {
            super.setValueInternal((Object)LocalDateTime.of((LocalDate)object, LocalTime.of(0, 0, 0, 0)));
        } else if (object instanceof Date) {
            this.handleAsDate((Date)object);
        } else if (object instanceof Calendar) {
            this.handleAsCalendar((Calendar)object);
        } else if (object instanceof Number) {
            this.handleAsDate(new Date(((Number)object).longValue()));
        } else if (object instanceof List) {
            this.handleAsList((List)object);
        } else {
            throw this.illegalValue(object, LocalDateTime.class);
        }
    }

    protected void handleAsDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        this.handleAsCalendar(calendar);
    }

    protected void handleAsCalendar(Calendar calendar) {
        int n = calendar.get(10);
        int n2 = calendar.get(12);
        int n3 = calendar.get(13);
        int n4 = calendar.get(14) * 1000;
        super.setValueInternal((Object)LocalDateTime.of(LocalDate.ofEpochDay(calendar.getTime().getTime()), LocalTime.of(n, n2, n3, n4)));
    }

    protected void handleAsString(String string) {
        if (GriffonNameUtils.isBlank((String)string)) {
            super.setValueInternal(null);
            return;
        }
        try {
            super.setValueInternal((Object)LocalDateTime.parse(string));
        }
        catch (DateTimeParseException dateTimeParseException) {
            throw this.illegalValue(string, LocalDateTime.class, dateTimeParseException);
        }
    }

    protected Formatter<LocalDateTime> resolveFormatter() {
        return GriffonNameUtils.isBlank((String)this.getFormat()) ? null : new LocalDateTimeFormatter(this.getFormat());
    }

    protected void handleAsList(List<?> list) {
        if (list.isEmpty()) {
            super.setValueInternal(null);
            return;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.addAll(list);
        switch (list.size()) {
            case 7: {
                break;
            }
            case 6: {
                arrayList.add(0.0);
                break;
            }
            case 5: {
                arrayList.add(0.0);
                arrayList.add(0.0);
                break;
            }
            case 4: {
                arrayList.add(0.0);
                arrayList.add(0.0);
                arrayList.add(0.0);
                break;
            }
            case 3: {
                arrayList.add(0.0);
                arrayList.add(0.0);
                arrayList.add(0.0);
                arrayList.add(0.0);
                break;
            }
            default: {
                throw this.illegalValue(list, LocalDateTime.class);
            }
        }
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Object e = arrayList.get(i);
            if (e instanceof Number) {
                arrayList.set(i, this.parse((Number)e));
                continue;
            }
            if (e instanceof CharSequence) {
                arrayList.set(i, this.parse(String.valueOf(e)));
                continue;
            }
            throw this.illegalValue(list, LocalDateTime.class);
        }
        super.setValueInternal((Object)LocalDateTime.of((int)((Integer)arrayList.get(0)), (Integer)arrayList.get(1), (int)((Integer)arrayList.get(2)), (int)((Integer)arrayList.get(3)), (int)((Integer)arrayList.get(4)), (int)((Integer)arrayList.get(5)), (int)((Integer)arrayList.get(6))));
    }

    protected int parse(String string) {
        try {
            return Integer.parseInt(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw this.illegalValue(string, LocalDateTime.class, numberFormatException);
        }
    }

    protected int parse(Number number) {
        return number.intValue();
    }
}

