/*
 * Decompiled with CFR 0.152.
 */
package griffon.core.formatters;

import griffon.core.formatters.AbstractFormatter;
import griffon.core.formatters.ParseException;
import griffon.util.GriffonNameUtils;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class LocalDateFormatter
extends AbstractFormatter<LocalDate> {
    private final DateTimeFormatter formatter;
    private final String pattern;

    public LocalDateFormatter() {
        this(null);
    }

    public LocalDateFormatter(@Nullable String string) {
        if (GriffonNameUtils.isBlank((String)string)) {
            this.formatter = DateTimeFormatter.ISO_LOCAL_DATE;
            this.pattern = "yyyy-MM-dd";
        } else {
            this.formatter = DateTimeFormatter.ofPattern(string);
            this.pattern = string;
        }
    }

    @Nonnull
    public String getPattern() {
        return this.pattern;
    }

    @Nullable
    public String format(@Nullable LocalDate localDate) {
        return localDate == null ? null : this.formatter.format(localDate);
    }

    @Nullable
    public LocalDate parse(@Nullable String string) throws ParseException {
        if (GriffonNameUtils.isBlank((String)string)) {
            return null;
        }
        try {
            return LocalDate.parse(string, this.formatter);
        }
        catch (DateTimeParseException dateTimeParseException) {
            throw new ParseException((Throwable)dateTimeParseException);
        }
    }
}

