/*
 * Decompiled with CFR 0.152.
 */
package griffon.core.formatters;

import griffon.core.formatters.AbstractFormatter;
import griffon.core.formatters.ParseException;
import griffon.util.GriffonNameUtils;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class LocalDateTimeFormatter
extends AbstractFormatter<LocalDateTime> {
    private final DateTimeFormatter formatter;
    private final String pattern;

    public LocalDateTimeFormatter() {
        this(null);
    }

    public LocalDateTimeFormatter(@Nullable String string) {
        if (GriffonNameUtils.isBlank((String)string)) {
            this.formatter = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
            this.pattern = "yyyy-MM-dd'T'HH:mm:ss.SSS";
        } else {
            this.formatter = DateTimeFormatter.ofPattern(string);
            this.pattern = string;
        }
    }

    @Nonnull
    public String getPattern() {
        return this.pattern;
    }

    @Nullable
    public String format(@Nullable LocalDateTime localDateTime) {
        return localDateTime == null ? null : this.formatter.format(localDateTime);
    }

    @Nullable
    public LocalDateTime parse(@Nullable String string) throws ParseException {
        if (GriffonNameUtils.isBlank((String)string)) {
            return null;
        }
        try {
            return LocalDateTime.parse(string, this.formatter);
        }
        catch (DateTimeParseException dateTimeParseException) {
            throw new ParseException((Throwable)dateTimeParseException);
        }
    }
}

