/*
 * Decompiled with CFR 0.152.
 */
package griffon.core.formatters;

import griffon.core.formatters.AbstractFormatter;
import griffon.core.formatters.ParseException;
import griffon.util.GriffonNameUtils;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class LocalTimeFormatter
extends AbstractFormatter<LocalTime> {
    private final DateTimeFormatter formatter;
    private final String pattern;

    public LocalTimeFormatter() {
        this(null);
    }

    public LocalTimeFormatter(@Nullable String string) {
        if (GriffonNameUtils.isBlank((String)string)) {
            this.formatter = DateTimeFormatter.ISO_LOCAL_TIME;
            this.pattern = "HH:mm:ss.SSS";
        } else {
            this.formatter = DateTimeFormatter.ofPattern(string);
            this.pattern = string;
        }
    }

    @Nonnull
    public String getPattern() {
        return this.pattern;
    }

    @Nullable
    public String format(@Nullable LocalTime localTime) {
        return localTime == null ? null : this.formatter.format(localTime);
    }

    @Nullable
    public LocalTime parse(@Nullable String string) throws ParseException {
        if (GriffonNameUtils.isBlank((String)string)) {
            return null;
        }
        try {
            return LocalTime.parse(string, this.formatter);
        }
        catch (DateTimeParseException dateTimeParseException) {
            throw new ParseException((Throwable)dateTimeParseException);
        }
    }
}

