/*
 * Decompiled with CFR 0.152.
 */
package griffon.plugins.preferences;

import griffon.util.GriffonNameUtils;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;

public class NodeChangeEvent
implements Serializable {
    private static final long serialVersionUID = -1751843471998802294L;
    private final String path;
    private final Type type;

    public NodeChangeEvent(@Nonnull String path, @Nonnull Type type) {
        this.path = GriffonNameUtils.requireNonBlank((String)path, (String)"Argument 'path' must not be blank");
        this.type = Objects.requireNonNull(type, "Argument 'type' must not be null");
    }

    @Nonnull
    public String getPath() {
        return this.path;
    }

    @Nonnull
    public Type getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeChangeEvent that = (NodeChangeEvent)o;
        return this.path.equals(that.path) && this.type == that.type;
    }

    public int hashCode() {
        int result = this.path.hashCode();
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public String toString() {
        return "NodeChangeEvent{path='" + this.path + '\'' + ", type=" + (Object)((Object)this.type) + '}';
    }

    public static enum Type {
        ADDED,
        REMOVED;

    }
}

