/*
 * Decompiled with CFR 0.152.
 */
package griffon.plugins.preferences.persistors;

import griffon.core.GriffonApplication;
import griffon.core.editors.PropertyEditorResolver;
import griffon.core.env.Metadata;
import griffon.plugins.preferences.Preferences;
import griffon.plugins.preferences.PreferencesManager;
import griffon.plugins.preferences.PreferencesNode;
import griffon.plugins.preferences.PreferencesPersistor;
import java.beans.PropertyEditor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMapBasedPreferencesPersistor
implements PreferencesPersistor {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractMapBasedPreferencesPersistor.class);
    private static final String KEY_PREFERENCES_PERSISTOR_LOCATION = "preferences.persistor.location";
    private static final String DEFAULT_PREFIX = ".prefs";
    private final GriffonApplication application;
    @Inject
    private Metadata metadata;

    @Inject
    public AbstractMapBasedPreferencesPersistor(@Nonnull GriffonApplication application) {
        this.application = Objects.requireNonNull(application, "Argument 'application' cannot ne null");
    }

    @Nonnull
    protected InputStream inputStream() throws IOException {
        File file;
        String fileName = this.resolvePreferencesFileName();
        if (LOG.isInfoEnabled()) {
            LOG.info("Reading preferences from " + fileName);
        }
        if (!(file = new File(fileName)).exists()) {
            file.getParentFile().mkdirs();
        }
        return new FileInputStream(file);
    }

    @Nonnull
    protected OutputStream outputStream() throws IOException {
        File file;
        String fileName = this.resolvePreferencesFileName();
        if (LOG.isInfoEnabled()) {
            LOG.info("Writing preferences to " + fileName);
        }
        if (!(file = new File(fileName)).exists()) {
            file.getParentFile().mkdirs();
        }
        return new FileOutputStream(file);
    }

    @Nonnull
    protected String resolvePreferencesFileName() {
        String defaultLocation = System.getProperty("user.home") + File.separator + "." + this.metadata.getApplicationName() + File.separator + "preferences" + File.separator + "default" + this.resolvePrefix();
        return this.application.getConfiguration().getAsString(KEY_PREFERENCES_PERSISTOR_LOCATION, defaultLocation);
    }

    @Nonnull
    protected String resolvePrefix() {
        return DEFAULT_PREFIX;
    }

    @Override
    @Nonnull
    public Preferences read(@Nonnull PreferencesManager preferencesManager) throws IOException {
        InputStream inputStream = this.inputStream();
        Map<String, Object> map = this.read(inputStream);
        inputStream.close();
        PreferencesNode node = preferencesManager.getPreferences().getRoot();
        this.readInto(map, node);
        return preferencesManager.getPreferences();
    }

    @Nonnull
    protected Map<String, Object> read(@Nonnull InputStream inputStream) throws IOException {
        return Collections.emptyMap();
    }

    @Override
    public void write(@Nonnull PreferencesManager preferencesManager) throws IOException {
        PreferencesNode node = preferencesManager.getPreferences().getRoot();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        this.writeTo(node, map);
        OutputStream outputStream = this.outputStream();
        this.write(map, outputStream);
        outputStream.flush();
        outputStream.close();
    }

    protected abstract void write(@Nonnull Map<String, Object> var1, @Nonnull OutputStream var2) throws IOException;

    private void readInto(@Nonnull Map<String, Object> map, @Nonnull PreferencesNode node) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Map) {
                this.readInto((Map)value, node.node(key));
                continue;
            }
            if (value instanceof List || value instanceof Number || value instanceof Boolean || value instanceof CharSequence) {
                node.putAt(key, value);
                continue;
            }
            throw new IllegalArgumentException("Invalid value for '" + node.path() + "." + key + "' => " + value);
        }
    }

    private void writeTo(PreferencesNode node, Map<String, Object> map) {
        for (String key : node.keys()) {
            Object value = node.getAt(key);
            if (value == null) continue;
            map.put(key, this.convertValue(value));
        }
        for (Map.Entry entry : node.children().entrySet()) {
            LinkedHashMap<String, Object> childMap = new LinkedHashMap<String, Object>();
            this.writeTo((PreferencesNode)entry.getValue(), childMap);
            map.put((String)entry.getKey(), childMap);
        }
    }

    private Object convertValue(Object value) {
        if (value == null || value instanceof Boolean || value instanceof Number || value instanceof CharSequence) {
            return value;
        }
        if (value instanceof Map) {
            LinkedHashMap<String, Object> tmp = new LinkedHashMap<String, Object>();
            Map source = (Map)value;
            for (Object key : source.keySet()) {
                Object val = source.get(key);
                if (val == null) continue;
                tmp.put(String.valueOf(key), this.convertValue(val));
            }
            return tmp;
        }
        if (value instanceof Collection) {
            ArrayList<Object> tmp = new ArrayList<Object>();
            List source = (List)value;
            for (Object val : source) {
                tmp.add(this.convertValue(val));
            }
            return tmp;
        }
        if (value.getClass().isArray()) {
            Object[] source;
            ArrayList<Object> tmp = new ArrayList<Object>();
            for (Object val : source = (Object[])value) {
                tmp.add(this.convertValue(val));
            }
            return tmp;
        }
        PropertyEditor propertyEditor = PropertyEditorResolver.findEditor(value.getClass());
        if (propertyEditor != null) {
            propertyEditor.setValue(value);
            return propertyEditor.getAsText();
        }
        return value;
    }
}

