/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.preferences;

import griffon.plugins.preferences.NodeChangeEvent;
import griffon.plugins.preferences.NodeChangeListener;
import griffon.plugins.preferences.PreferenceChangeEvent;
import griffon.plugins.preferences.PreferenceChangeListener;
import griffon.plugins.preferences.Preferences;
import griffon.plugins.preferences.PreferencesNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public abstract class AbstractPreferences
implements Preferences {
    private static final String ERROR_LISTENER_NULL = "Argument 'listener' must not be null";
    private static final String ERROR_EVENT_NULL = "Argument 'event' must not be null";
    private final List<NodeChangeListener> nodeChangeListeners = new ArrayList<NodeChangeListener>();
    private final List<PreferenceChangeListener> changeListeners = new ArrayList<PreferenceChangeListener>();

    @Override
    public void addNodeChangeListener(@Nonnull NodeChangeListener listener) {
        Objects.requireNonNull(listener, ERROR_LISTENER_NULL);
        if (this.nodeChangeListeners.contains(listener)) {
            return;
        }
        this.nodeChangeListeners.add(listener);
    }

    @Override
    public void removeNodeChangeListener(@Nonnull NodeChangeListener listener) {
        Objects.requireNonNull(listener, ERROR_LISTENER_NULL);
        this.nodeChangeListeners.remove(listener);
    }

    @Override
    @Nonnull
    public NodeChangeListener[] getNodeChangeListeners() {
        return this.nodeChangeListeners.toArray(new NodeChangeListener[this.nodeChangeListeners.size()]);
    }

    @Override
    public void addPreferencesChangeListener(@Nonnull PreferenceChangeListener listener) {
        Objects.requireNonNull(listener, ERROR_LISTENER_NULL);
        if (this.changeListeners.contains(listener)) {
            return;
        }
        this.changeListeners.add(listener);
    }

    @Override
    public void removePreferencesChangeListener(@Nonnull PreferenceChangeListener listener) {
        Objects.requireNonNull(listener, ERROR_LISTENER_NULL);
        this.changeListeners.remove(listener);
    }

    @Override
    @Nonnull
    public PreferenceChangeListener[] getPreferencesChangeListeners() {
        return this.changeListeners.toArray(new PreferenceChangeListener[this.changeListeners.size()]);
    }

    @Override
    public void preferenceChanged(@Nonnull PreferenceChangeEvent event) {
        Objects.requireNonNull(event, ERROR_EVENT_NULL);
        for (PreferenceChangeListener listener : this.changeListeners) {
            listener.preferenceChanged(event);
        }
    }

    @Override
    public void nodeChanged(@Nonnull NodeChangeEvent event) {
        Objects.requireNonNull(event, ERROR_EVENT_NULL);
        for (NodeChangeListener listener : this.nodeChangeListeners) {
            listener.nodeChanged(event);
        }
    }

    @Override
    public boolean containsNode(@Nonnull Class<?> clazz) {
        return this.getRoot().containsNode(clazz);
    }

    @Override
    public boolean containsNode(@Nonnull String path) {
        return this.getRoot().containsNode(path);
    }

    @Override
    public PreferencesNode node(@Nonnull Class<?> clazz) {
        return this.getRoot().node(clazz);
    }

    @Override
    public PreferencesNode node(@Nonnull String path) {
        return this.getRoot().node(path);
    }

    @Override
    public PreferencesNode removeNode(@Nonnull Class<?> clazz) {
        return this.getRoot().removeNode(clazz);
    }

    @Override
    public PreferencesNode removeNode(@Nonnull String path) {
        return this.getRoot().removeNode(path);
    }
}

