/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.preferences;

import griffon.core.ApplicationEvent;
import griffon.core.CallableWithArgs;
import griffon.core.GriffonApplication;
import griffon.core.GriffonExceptionHandler;
import griffon.core.RunnableWithArgs;
import griffon.core.editors.ExtendedPropertyEditor;
import griffon.core.editors.PropertyEditorResolver;
import griffon.exceptions.InstanceMethodInvocationException;
import griffon.plugins.preferences.NodeChangeEvent;
import griffon.plugins.preferences.NodeChangeListener;
import griffon.plugins.preferences.Preference;
import griffon.plugins.preferences.PreferenceChangeEvent;
import griffon.plugins.preferences.PreferenceChangeListener;
import griffon.plugins.preferences.PreferencesAware;
import griffon.plugins.preferences.PreferencesManager;
import griffon.plugins.preferences.PreferencesNode;
import griffon.util.GriffonClassUtils;
import griffon.util.GriffonNameUtils;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPreferencesManager
implements PreferencesManager {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractPreferencesManager.class);
    protected static final String ERROR_INSTANCE_NULL = "Argument 'instance' must not be null";
    protected static final String ERROR_FIELD_NULL = "Argument 'field' must not be null";
    protected static final String ERROR_TYPE_NULL = "Argument 'type' must not be null";
    protected static final String ERROR_VALUE_NULL = "Argument 'value' must not be null";
    @Inject
    protected GriffonApplication application;
    private final InstanceStore instanceStore = new InstanceStore();

    @PostConstruct
    private void initialize() {
        this.application = Objects.requireNonNull(this.application, "Argument 'application' cannot ne null");
        this.application.getEventRouter().addEventListener(ApplicationEvent.NEW_INSTANCE.getName(), new RunnableWithArgs(){

            public void run(Object ... args) {
                Object instance = args[1];
                AbstractPreferencesManager.this.injectPreferences(instance);
            }
        });
        this.application.getEventRouter().addEventListener(ApplicationEvent.DESTROY_INSTANCE.getName(), new RunnableWithArgs(){

            public void run(Object ... args) {
                Object instance = args[1];
                if (AbstractPreferencesManager.this.instanceStore.contains(instance)) {
                    AbstractPreferencesManager.this.instanceStore.remove(instance);
                }
            }
        });
        this.getPreferences().addNodeChangeListener(new NodeChangeListener(){

            @Override
            public void nodeChanged(@Nonnull NodeChangeEvent event) {
                if (event.getType() == NodeChangeEvent.Type.ADDED) {
                    for (InstanceContainer instanceContainer : AbstractPreferencesManager.this.instanceStore) {
                        if (!instanceContainer.containsPartialPath(event.getPath())) continue;
                        AbstractPreferencesManager.this.injectPreferences(instanceContainer.instance());
                    }
                }
            }
        });
        this.getPreferences().addPreferencesChangeListener(new PreferenceChangeListener(){

            @Override
            public void preferenceChanged(@Nonnull PreferenceChangeEvent event) {
                for (InstanceContainer instanceContainer : AbstractPreferencesManager.this.instanceStore) {
                    String path;
                    if (!instanceContainer.containsPath(path = "/".equals(path = event.getPath()) ? event.getKey() : path + "." + event.getKey())) continue;
                    InjectionPoint injectionPoint = (InjectionPoint)instanceContainer.injectionPoints.get(path);
                    Object value = event.getNewValue();
                    if (null != value && !injectionPoint.getType().isAssignableFrom(value.getClass())) {
                        value = AbstractPreferencesManager.this.convertValue(injectionPoint.getType(), value, injectionPoint.format);
                    }
                    injectionPoint.setValue(instanceContainer.instance(), value);
                }
            }
        });
    }

    @Override
    public void save(@Nonnull Object instance) {
        Objects.requireNonNull(instance, ERROR_INSTANCE_NULL);
        LinkedHashMap<String, PreferenceDescriptor> descriptors = new LinkedHashMap<String, PreferenceDescriptor>();
        Class<?> klass = instance.getClass();
        do {
            this.harvestDescriptors(klass, instance, descriptors);
        } while (null != (klass = klass.getSuperclass()));
        this.doSavePreferences(instance, descriptors);
    }

    protected void injectPreferences(@Nonnull Object instance) {
        Objects.requireNonNull(instance, ERROR_INSTANCE_NULL);
        LinkedHashMap<String, PreferenceDescriptor> descriptors = new LinkedHashMap<String, PreferenceDescriptor>();
        Class<?> klass = instance.getClass();
        do {
            this.harvestDescriptors(klass, instance, descriptors);
        } while (null != (klass = klass.getSuperclass()));
        this.doPreferencesInjection(instance, descriptors);
        if (instance.getClass().getAnnotation(PreferencesAware.class) != null && !this.instanceStore.contains(instance)) {
            LinkedList<InjectionPoint> injectionPoints = new LinkedList<InjectionPoint>();
            for (PreferenceDescriptor pd : descriptors.values()) {
                injectionPoints.add(pd.asInjectionPoint());
            }
            this.instanceStore.add(instance, injectionPoints);
        }
    }

    protected void harvestDescriptors(@Nonnull Class klass, @Nonnull Object instance, @Nonnull Map<String, PreferenceDescriptor> descriptors) {
        PropertyDescriptor[] propertyDescriptors = GriffonClassUtils.getPropertyDescriptors((Class)klass);
        for (PropertyDescriptor pd : propertyDescriptors) {
            Method readMethod = pd.getReadMethod();
            Method writeMethod = pd.getWriteMethod();
            if (null == readMethod || null == writeMethod || Modifier.isStatic(readMethod.getModifiers()) || Modifier.isStatic(writeMethod.getModifiers())) continue;
            Preference annotation = writeMethod.getAnnotation(Preference.class);
            if (null == annotation) {
                annotation = readMethod.getAnnotation(Preference.class);
            }
            if (null == annotation) continue;
            String propertyName = pd.getName();
            String fqName = writeMethod.getDeclaringClass().getName().replace('$', '.') + "." + writeMethod.getName();
            String path = "/" + writeMethod.getDeclaringClass().getName().replace('$', '/').replace('.', '/') + "." + propertyName;
            String key = annotation.key();
            Object[] args = annotation.args();
            String defaultValue = annotation.defaultValue();
            String resolvedPath = !GriffonNameUtils.isBlank((String)key) ? key : path;
            String format = annotation.format();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Property " + propertyName + " of instance " + instance + " [path='" + resolvedPath + "', args='" + Arrays.toString(args) + "', defaultValue='" + defaultValue + "', format='" + format + "'] is marked for preference injection.");
            }
            descriptors.put(propertyName, new MethodPreferenceDescriptor(readMethod, writeMethod, fqName, resolvedPath, (String[])args, defaultValue, format));
        }
        for (Field field : klass.getDeclaredFields()) {
            Preference annotation;
            if (field.isSynthetic() || Modifier.isStatic(field.getModifiers()) || descriptors.containsKey(field.getName()) || null == (annotation = field.getAnnotation(Preference.class))) continue;
            String fqFieldName = field.getDeclaringClass().getName().replace('$', '.') + "." + field.getName();
            String path = "/" + field.getDeclaringClass().getName().replace('$', '/').replace('.', '/') + "." + field.getName();
            String key = annotation.key();
            Object[] args = annotation.args();
            String defaultValue = annotation.defaultValue();
            String resolvedPath = !GriffonNameUtils.isBlank((String)key) ? key : path;
            String format = annotation.format();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Field " + fqFieldName + " of instance " + instance + " [path='" + resolvedPath + "', args='" + Arrays.toString(args) + "', defaultValue='" + defaultValue + "', format='" + format + "'] is marked for preference injection.");
            }
            descriptors.put(field.getName(), new FieldPreferenceDescriptor(field, fqFieldName, resolvedPath, (String[])args, defaultValue, format));
        }
    }

    protected void doPreferencesInjection(@Nonnull Object instance, @Nonnull Map<String, PreferenceDescriptor> descriptors) {
        for (PreferenceDescriptor descriptor : descriptors.values()) {
            Object value = this.resolvePreference(descriptor.path, descriptor.args, descriptor.defaultValue);
            if (null == value) continue;
            InjectionPoint injectionPoint = descriptor.asInjectionPoint();
            if (!injectionPoint.getType().isAssignableFrom(value.getClass())) {
                value = this.convertValue(injectionPoint.getType(), value, descriptor.format);
            }
            injectionPoint.setValue(instance, value);
        }
    }

    protected void doSavePreferences(@Nonnull Object instance, @Nonnull Map<String, PreferenceDescriptor> descriptors) {
        for (PreferenceDescriptor descriptor : descriptors.values()) {
            InjectionPoint injectionPoint = descriptor.asInjectionPoint();
            Object value = injectionPoint.getValue(instance);
            String[] parsedPath = this.parsePath(descriptor.path);
            PreferencesNode node = this.getPreferences().node(parsedPath[0]);
            String key = parsedPath[1];
            if (value != null) {
                PropertyEditor propertyEditor;
                if (!GriffonNameUtils.isBlank((String)descriptor.format) && (propertyEditor = this.resolvePropertyEditor(value.getClass(), descriptor.format)) != null) {
                    propertyEditor.setValue(value);
                    value = propertyEditor.getAsText();
                }
                node.putAt(key, value);
                continue;
            }
            node.remove(key);
        }
    }

    protected Object resolvePreference(@Nonnull String path, @Nonnull String[] args, @Nonnull String defaultValue) {
        String key;
        String[] parsedPath = this.parsePath(path);
        PreferencesNode node = this.getPreferences().node(parsedPath[0]);
        if (node.containsKey(key = parsedPath[1])) {
            return this.evalPreferenceWithArguments(node.getAt(key), args);
        }
        node.putAt(key, defaultValue);
        return defaultValue;
    }

    protected Object evalPreferenceWithArguments(@Nullable Object value, @Nullable Object[] args) {
        if (value instanceof CallableWithArgs) {
            CallableWithArgs callable = (CallableWithArgs)value;
            return callable.call(args);
        }
        if (value instanceof CharSequence) {
            return this.formatPreferenceValue(String.valueOf(value), args);
        }
        return value;
    }

    protected String formatPreferenceValue(@Nonnull String message, @Nullable Object[] args) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Formatting message={} args={}", (Object)message, (Object)Arrays.toString(args));
        }
        if (args == null || args.length == 0) {
            return message;
        }
        return MessageFormat.format(message, args);
    }

    @Nonnull
    protected Object convertValue(@Nonnull Class<?> type, @Nonnull Object value, @Nullable String format) {
        Objects.requireNonNull(type, ERROR_TYPE_NULL);
        Objects.requireNonNull(value, ERROR_VALUE_NULL);
        PropertyEditor propertyEditor = this.resolvePropertyEditor(type, format);
        if (null == propertyEditor) {
            return value;
        }
        if (value instanceof CharSequence) {
            propertyEditor.setAsText(String.valueOf(value));
        } else {
            propertyEditor.setValue(value);
        }
        return propertyEditor.getValue();
    }

    @Nullable
    protected PropertyEditor resolvePropertyEditor(@Nonnull Class<?> type, @Nullable String format) {
        Objects.requireNonNull(type, ERROR_TYPE_NULL);
        PropertyEditor propertyEditor = PropertyEditorResolver.findEditor(type);
        if (propertyEditor instanceof ExtendedPropertyEditor) {
            ((ExtendedPropertyEditor)propertyEditor).setFormat(format);
        }
        return propertyEditor;
    }

    @Nonnull
    protected String[] parsePath(@Nonnull String path) {
        int split = path.lastIndexOf(".");
        String head = split < 0 ? path : path.substring(0, split);
        String tail = split > 0 ? path.substring(split + 1) : null;
        head = head.replace('.', '/');
        return new String[]{head, tail};
    }

    private static class MethodPreferenceDescriptor
    extends PreferenceDescriptor {
        public final Method readMethod;
        public final Method writeMethod;

        private MethodPreferenceDescriptor(Method readMethod, Method writeMethod, String fqName, String path, String[] args, String defaultValue, String format) {
            super(fqName, path, args, defaultValue, format);
            this.readMethod = readMethod;
            this.writeMethod = writeMethod;
        }

        @Override
        public InjectionPoint asInjectionPoint() {
            return new MethodInjectionPoint(this.readMethod, this.writeMethod, this.fqName, this.path, this.format);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("MethodPreferenceDescriptor{");
            sb.append("readMethod=").append(this.readMethod);
            sb.append(", writeMethod=").append(this.writeMethod);
            sb.append(", fqName='").append(this.fqName).append('\'');
            sb.append(", path='").append(this.path).append('\'');
            sb.append(", args=").append(Arrays.toString(this.args));
            sb.append(", defaultValue='").append(this.defaultValue).append('\'');
            sb.append(", format='").append(this.format).append('\'');
            sb.append('}');
            return sb.toString();
        }
    }

    private static class FieldPreferenceDescriptor
    extends PreferenceDescriptor {
        public final Field field;

        private FieldPreferenceDescriptor(Field field, String fqName, String path, String[] args, String defaultValue, String format) {
            super(fqName, path, args, defaultValue, format);
            this.field = field;
        }

        @Override
        public InjectionPoint asInjectionPoint() {
            return new FieldInjectionPoint(this.field, this.fqName, this.path, this.format);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("FieldPreferenceDescriptor{");
            sb.append("field=").append(this.field);
            sb.append(", fqName='").append(this.fqName).append('\'');
            sb.append(", path='").append(this.path).append('\'');
            sb.append(", args=").append(Arrays.toString(this.args));
            sb.append(", defaultValue='").append(this.defaultValue).append('\'');
            sb.append(", format='").append(this.format).append('\'');
            sb.append('}');
            return sb.toString();
        }
    }

    private static abstract class PreferenceDescriptor {
        public final String fqName;
        public final String path;
        public final String[] args;
        public final String defaultValue;
        public final String format;

        private PreferenceDescriptor(String fqName, String path, String[] args, String defaultValue, String format) {
            this.fqName = fqName;
            this.path = path;
            this.args = args;
            this.defaultValue = defaultValue;
            this.format = format;
        }

        public abstract InjectionPoint asInjectionPoint();
    }

    private static class MethodInjectionPoint
    extends InjectionPoint {
        public final Method readMethod;
        public final Method writeMethod;
        private final Class type;

        private MethodInjectionPoint(Method readMethod, Method writeMethod, String fqName, String path, String format) {
            super(fqName, path, format);
            this.readMethod = readMethod;
            this.writeMethod = writeMethod;
            this.type = readMethod.getReturnType();
        }

        @Override
        public void setValue(Object instance, Object value) {
            block2: {
                try {
                    this.writeMethod.invoke(instance, value);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    if (!LOG.isWarnEnabled()) break block2;
                    LOG.warn("Cannot set value on method " + this.fqName + "() of instance " + instance, GriffonExceptionHandler.sanitize((Throwable)e));
                }
            }
        }

        @Override
        public Object getValue(Object instance) {
            try {
                return this.readMethod.invoke(instance, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("Cannot get value on method " + this.fqName + "() of instance " + instance, GriffonExceptionHandler.sanitize((Throwable)e));
                }
                return null;
            }
        }

        @Override
        public Class<?> getType() {
            return this.type;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("MethodInjectionPoint{");
            sb.append("readMethod=").append(this.readMethod);
            sb.append(", writeMethod=").append(this.writeMethod);
            sb.append(", type=").append(this.type);
            sb.append(", fqName='").append(this.fqName).append('\'');
            sb.append(", path='").append(this.path).append('\'');
            sb.append(", format='").append(this.format).append('\'');
            sb.append('}');
            return sb.toString();
        }
    }

    private static class FieldInjectionPoint
    extends InjectionPoint {
        private static final Object[] NO_ARGS = new Object[0];
        public final Field field;

        private FieldInjectionPoint(Field field, String fqName, String path, String format) {
            super(fqName, path, format);
            this.field = field;
        }

        @Override
        public void setValue(Object instance, Object value) {
            Objects.requireNonNull(instance, AbstractPreferencesManager.ERROR_INSTANCE_NULL);
            Objects.requireNonNull(this.field, AbstractPreferencesManager.ERROR_FIELD_NULL);
            String setter = GriffonNameUtils.getSetterName((String)this.field.getName());
            try {
                GriffonClassUtils.invokeExactInstanceMethod((Object)instance, (String)setter, (Object)value);
            }
            catch (InstanceMethodInvocationException imie) {
                try {
                    this.field.setAccessible(true);
                    this.field.set(instance, value);
                }
                catch (IllegalAccessException e) {
                    LOG.warn("Cannot set value on field {} of instance {}", new Object[]{this.fqName, instance, GriffonExceptionHandler.sanitize((Throwable)e)});
                }
            }
        }

        @Override
        public Object getValue(Object instance) {
            String getter = GriffonNameUtils.getGetterName((String)this.field.getName());
            try {
                return GriffonClassUtils.invokeExactInstanceMethod((Object)instance, (String)getter);
            }
            catch (InstanceMethodInvocationException imie) {
                try {
                    this.field.setAccessible(true);
                    return this.field.get(instance);
                }
                catch (IllegalAccessException e) {
                    LOG.warn("Cannot set value on field {} of instance {}", new Object[]{this.fqName, instance, GriffonExceptionHandler.sanitize((Throwable)e)});
                    return null;
                }
            }
        }

        @Override
        public Class<?> getType() {
            return this.field.getType();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("FieldInjectionPoint{");
            sb.append("field=").append(this.field);
            sb.append(", fqName='").append(this.fqName).append('\'');
            sb.append(", path='").append(this.path).append('\'');
            sb.append(", format='").append(this.format).append('\'');
            sb.append('}');
            return sb.toString();
        }
    }

    private static abstract class InjectionPoint {
        public final String fqName;
        public final String path;
        public final String format;

        private InjectionPoint(String fqName, String path, String format) {
            this.fqName = fqName;
            this.path = path;
            this.format = format;
        }

        public abstract void setValue(Object var1, Object var2);

        public abstract Object getValue(Object var1);

        public abstract Class<?> getType();
    }

    private static class InstanceContainer {
        private final WeakReference<Object> instance;
        private final Map<String, InjectionPoint> injectionPoints = new LinkedHashMap<String, InjectionPoint>();

        private InstanceContainer(Object instance, List<InjectionPoint> injectionPoints) {
            this.instance = new WeakReference<Object>(instance);
            for (InjectionPoint ip : injectionPoints) {
                this.injectionPoints.put(ip.path, ip);
            }
        }

        private Object instance() {
            return this.instance.get();
        }

        private boolean containsPath(String path) {
            for (String p : this.injectionPoints.keySet()) {
                if (!p.equals(path)) continue;
                return true;
            }
            return false;
        }

        public boolean containsPartialPath(String path) {
            for (String p : this.injectionPoints.keySet()) {
                if (!p.startsWith(path + ".")) continue;
                return true;
            }
            return false;
        }
    }

    private static class InstanceStore
    implements Iterable<InstanceContainer> {
        private final List<InstanceContainer> instances = new CopyOnWriteArrayList<InstanceContainer>();

        private InstanceStore() {
        }

        private void add(Object instance, List<InjectionPoint> injectionPoints) {
            if (null == instance) {
                return;
            }
            this.instances.add(new InstanceContainer(instance, injectionPoints));
        }

        private void remove(Object instance) {
            InstanceContainer instance1;
            Object candidate;
            if (null == instance) {
                return;
            }
            InstanceContainer subject = null;
            Iterator<InstanceContainer> iterator = this.instances.iterator();
            while (iterator.hasNext() && !instance.equals(candidate = (subject = (instance1 = iterator.next())).instance())) {
            }
            if (subject != null) {
                this.instances.remove(subject);
            }
        }

        private boolean contains(Object instance) {
            if (null == instance) {
                return false;
            }
            for (InstanceContainer instanceContainer : this.instances) {
                Object candidate = instanceContainer.instance();
                if (!instance.equals(candidate)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Iterator<InstanceContainer> iterator() {
            final Iterator<InstanceContainer> it = this.instances.iterator();
            return new Iterator<InstanceContainer>(){

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public InstanceContainer next() {
                    return (InstanceContainer)it.next();
                }

                @Override
                public void remove() {
                    it.remove();
                }
            };
        }
    }
}

