/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.preferences;

import griffon.plugins.preferences.Preferences;
import griffon.plugins.preferences.PreferencesNode;
import griffon.util.GriffonNameUtils;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractPreferencesNode
implements PreferencesNode {
    protected final Preferences preferences;
    protected PreferencesNode parent;
    protected final String name;
    private String path;

    public AbstractPreferencesNode(@Nonnull Preferences preferences, @Nullable PreferencesNode parent, @Nonnull String name) {
        this.preferences = Objects.requireNonNull(preferences, "Argument 'preferences' must not be null");
        this.name = GriffonNameUtils.requireNonBlank((String)name, (String)"Argument 'name' must not be null");
        this.parent = parent;
    }

    @Override
    @Nonnull
    public String name() {
        return this.name;
    }

    @Override
    @Nonnull
    public String path() {
        if (null == this.path) {
            this.path = null == this.parent ? "/" : (this.parent.isRoot() ? this.parent.path() + this.name : this.parent.path() + "/" + this.name);
        }
        return this.path;
    }

    @Override
    @Nullable
    public PreferencesNode parent() {
        return this.parent;
    }

    @Override
    public boolean isRoot() {
        return this.path().equals("/");
    }

    @Override
    @Nonnull
    public PreferencesNode merge(@Nonnull PreferencesNode other) {
        Objects.requireNonNull(other, "Argument 'other' must not be null");
        for (String key : other.keys()) {
            this.putAt(key, other.getAt(key));
        }
        for (Map.Entry entry : other.children().entrySet()) {
            String childNodeName = (String)entry.getKey();
            PreferencesNode newChild = this.children().get(childNodeName);
            if (newChild == null) {
                newChild = this.createChildNode(childNodeName);
            }
            newChild.merge((PreferencesNode)entry.getValue());
            this.storeChildNode(childNodeName, newChild);
        }
        return this;
    }

    @Override
    public boolean containsNode(@Nonnull Class<?> clazz) {
        Objects.requireNonNull(clazz, "Argument 'clazz' must not be null");
        return this.containsNode(clazz.getName());
    }

    @Override
    public boolean containsNode(@Nonnull String path) {
        Objects.requireNonNull(path, "Argument 'path' must not be null");
        String[] parsedPath = this.parsePath(path);
        return parsedPath.length != 0 && this.getChildNode(parsedPath[0]) != null;
    }

    @Override
    @Nullable
    public PreferencesNode node(@Nonnull Class<?> clazz) {
        Objects.requireNonNull(clazz, "Argument 'clazz' must not be null");
        return this.node(clazz.getName());
    }

    @Override
    @Nullable
    public PreferencesNode node(@Nonnull String path) {
        Objects.requireNonNull(path, "Argument 'path' must not be null");
        String[] parsedPath = this.parsePath(path);
        if (parsedPath.length == 0) {
            return null;
        }
        String nodeName = parsedPath[0];
        PreferencesNode node = this.getChildNode(nodeName);
        if (node == null) {
            node = this.createChildNode(nodeName);
            this.storeChildNode(nodeName, node);
        }
        if (!GriffonNameUtils.isBlank((String)parsedPath[1])) {
            node = node.node(parsedPath[1]);
        }
        return node;
    }

    @Override
    @Nullable
    public PreferencesNode removeNode(@Nonnull Class<?> clazz) {
        Objects.requireNonNull(clazz, "Argument 'clazz' must not be null");
        return this.removeNode(clazz.getName());
    }

    @Override
    @Nullable
    public PreferencesNode removeNode(@Nonnull String path) {
        String[] parsedPath = this.parsePath(path);
        if (parsedPath.length == 0) {
            return null;
        }
        String nodeName = parsedPath[0];
        PreferencesNode node = this.getChildNode(nodeName);
        if (node != null) {
            node = !GriffonNameUtils.isBlank((String)parsedPath[1]) ? node.removeNode(parsedPath[1]) : this.removeChildNode(nodeName);
        }
        return node;
    }

    @Nonnull
    private String[] parsePath(String path) {
        int split;
        if (GriffonNameUtils.isBlank((String)path) || !this.isRoot() && path.startsWith("/") || path.endsWith("/")) {
            return new String[0];
        }
        path = path.replace('.', "/".charAt(0));
        if (this.isRoot() && path.startsWith("/")) {
            path = path.substring(1);
        }
        String head = (split = path.indexOf("/")) < 0 ? path : path.substring(0, split);
        String tail = split > 0 ? path.substring(split + 1) : null;
        return new String[]{head, tail};
    }
}

