/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.preferences;

import griffon.core.editors.PropertyEditorResolver;
import griffon.plugins.preferences.NodeChangeEvent;
import griffon.plugins.preferences.PreferenceChangeEvent;
import griffon.plugins.preferences.Preferences;
import griffon.plugins.preferences.PreferencesNode;
import griffon.util.GriffonNameUtils;
import griffon.util.TypeUtils;
import java.beans.PropertyEditor;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.codehaus.griffon.runtime.preferences.AbstractPreferencesNode;

public class DefaultPreferencesNode
extends AbstractPreferencesNode {
    private static final String ERROR_TYPE_NULL = "Argument 'type' must not be null";
    private static final String ERROR_KEY_BLANK = "Argument 'key' must not be null";
    private static final String ERROR_NODE_NAME_BLANK = "Argument 'nodeName' must not be null";
    private final Object lock = new Object[0];
    @GuardedBy(value="lock")
    private final Map<String, Object> properties = new LinkedHashMap<String, Object>();
    @GuardedBy(value="lock")
    private final Map<String, PreferencesNode> nodes = new LinkedHashMap<String, PreferencesNode>();

    public DefaultPreferencesNode(@Nonnull Preferences preferences, @Nonnull PreferencesNode parent, @Nonnull String name) {
        super(preferences, parent, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Object getAt(@Nonnull String key) {
        Object object = this.lock;
        synchronized (object) {
            return this.properties.get(GriffonNameUtils.requireNonBlank((String)key, (String)ERROR_KEY_BLANK));
        }
    }

    @Override
    @Nullable
    public <T> T getAt(@Nonnull String key, Class<T> type) {
        Objects.requireNonNull(type, ERROR_TYPE_NULL);
        Object value = this.getAt(key);
        PropertyEditor propertyEditor = PropertyEditorResolver.findEditor(type);
        if (value instanceof CharSequence) {
            propertyEditor.setAsText(String.valueOf(value));
        } else {
            propertyEditor.setValue(value);
        }
        return (T)propertyEditor.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAt(@Nonnull String key, @Nullable Object value) {
        Object oldValue = null;
        Object object = this.lock;
        synchronized (object) {
            oldValue = this.properties.get(GriffonNameUtils.requireNonBlank((String)key, (String)ERROR_KEY_BLANK));
            this.properties.put(key, value);
        }
        if (!TypeUtils.equals((Object)oldValue, (Object)value)) {
            this.firePreferencesChanged(this.path(), key, oldValue, value);
        }
    }

    private void firePreferencesChanged(@Nonnull String path, @Nonnull String key, @Nullable Object oldValue, @Nullable Object newValue) {
        this.preferences.preferenceChanged(new PreferenceChangeEvent(path, key, oldValue, newValue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(@Nonnull String key) {
        Object oldValue = null;
        Object object = this.lock;
        synchronized (object) {
            oldValue = this.properties.remove(GriffonNameUtils.requireNonBlank((String)key, (String)ERROR_KEY_BLANK));
        }
        if (oldValue != null) {
            this.firePreferencesChanged(this.path(), key, oldValue, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.properties.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(@Nonnull String key) {
        Object object = this.lock;
        synchronized (object) {
            return this.properties.containsKey(GriffonNameUtils.requireNonBlank((String)key, (String)ERROR_KEY_BLANK));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public String[] keys() {
        Object object = this.lock;
        synchronized (object) {
            return this.properties.keySet().toArray(new String[this.properties.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public Map<String, PreferencesNode> children() {
        Object object = this.lock;
        synchronized (object) {
            return Collections.unmodifiableMap(this.nodes);
        }
    }

    @Override
    @Nonnull
    public PreferencesNode createChildNode(@Nonnull String nodeName) {
        return new DefaultPreferencesNode(this.preferences, this, GriffonNameUtils.requireNonBlank((String)nodeName, (String)ERROR_NODE_NAME_BLANK));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeChildNode(@Nonnull String nodeName, @Nonnull PreferencesNode node) {
        GriffonNameUtils.requireNonBlank((String)nodeName, (String)ERROR_NODE_NAME_BLANK);
        Objects.requireNonNull(node, "Argument 'node' must not be null");
        Object object = this.lock;
        synchronized (object) {
            this.nodes.put(nodeName, node);
        }
        this.preferences.nodeChanged(new NodeChangeEvent(node.path(), NodeChangeEvent.Type.ADDED));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public PreferencesNode removeChildNode(@Nonnull String nodeName) {
        PreferencesNode node = null;
        Object object = this.lock;
        synchronized (object) {
            node = this.nodes.remove(GriffonNameUtils.requireNonBlank((String)nodeName, (String)ERROR_NODE_NAME_BLANK));
        }
        if (node != null) {
            this.preferences.nodeChanged(new NodeChangeEvent(node.path(), NodeChangeEvent.Type.REMOVED));
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public PreferencesNode getChildNode(@Nonnull String nodeName) {
        Object object = this.lock;
        synchronized (object) {
            return this.nodes.get(GriffonNameUtils.requireNonBlank((String)nodeName, (String)ERROR_NODE_NAME_BLANK));
        }
    }
}

