/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.preferences;

import griffon.core.GriffonApplication;
import griffon.core.GriffonExceptionHandler;
import griffon.plugins.preferences.PreferencesManager;
import griffon.plugins.preferences.PreferencesPersistor;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import org.codehaus.griffon.runtime.core.addon.AbstractGriffonAddon;

@Named(value="preferences")
public class PreferencesAddon
extends AbstractGriffonAddon {
    @Inject
    private PreferencesManager preferencesManager;
    @Inject
    private PreferencesPersistor preferencesPersistor;
    private boolean preferencesWereRead;

    public void init(@Nonnull GriffonApplication application) {
        block3: {
            try {
                this.preferencesPersistor.read(this.preferencesManager);
                this.preferencesWereRead = true;
            }
            catch (FileNotFoundException fnfe) {
                this.preferencesWereRead = true;
            }
            catch (IOException e) {
                if (!this.getLog().isWarnEnabled()) break block3;
                this.getLog().warn("Cannot read preferences", GriffonExceptionHandler.sanitize((Throwable)e));
            }
        }
    }

    public void onShutdown(@Nonnull GriffonApplication application) {
        block3: {
            if (this.preferencesWereRead) {
                try {
                    this.preferencesPersistor.write(this.preferencesManager);
                }
                catch (IOException e) {
                    if (!this.getLog().isWarnEnabled()) break block3;
                    this.getLog().warn("Cannot persist preferences", GriffonExceptionHandler.sanitize((Throwable)e));
                }
            }
        }
    }
}

