/*
 * Decompiled with CFR 0.152.
 */
package griffon.swing;

import griffon.core.ApplicationClassLoader;
import griffon.core.ApplicationConfigurer;
import griffon.core.ApplicationEvent;
import griffon.core.Configuration;
import griffon.core.Context;
import griffon.core.ExecutorServiceManager;
import griffon.core.GriffonApplication;
import griffon.core.RunnableWithArgs;
import griffon.core.ShutdownHandler;
import griffon.core.addon.AddonManager;
import griffon.core.addon.GriffonAddon;
import griffon.core.artifact.ArtifactManager;
import griffon.core.controller.ActionManager;
import griffon.core.env.ApplicationPhase;
import griffon.core.env.Lifecycle;
import griffon.core.event.EventRouter;
import griffon.core.i18n.MessageSource;
import griffon.core.injection.Injector;
import griffon.core.mvc.MVCGroupManager;
import griffon.core.resources.ResourceHandler;
import griffon.core.resources.ResourceInjector;
import griffon.core.resources.ResourceResolver;
import griffon.core.threading.UIThreadManager;
import griffon.core.view.WindowManager;
import griffon.util.AnnotationUtils;
import griffon.util.GriffonApplicationUtils;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JApplet;
import org.codehaus.griffon.runtime.core.MVCGroupExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGriffonApplet
extends JApplet
implements GriffonApplication {
    public static final String[] EMPTY_ARGS = new String[0];
    private static final long serialVersionUID = -3489610863053527695L;
    private static final String ERROR_SHUTDOWN_HANDLER_NULL = "Argument 'shutdownHandler' must not be null";
    protected final Object[] lock = new Object[0];
    private final List<ShutdownHandler> shutdownHandlers = new ArrayList<ShutdownHandler>();
    private final String[] startupArgs;
    private final Object shutdownLock = new Object();
    private final Logger log;
    private Locale locale = Locale.getDefault();
    private ApplicationPhase phase = ApplicationPhase.INITIALIZE;
    private Injector<?> injector;

    public AbstractGriffonApplet() {
        this(EMPTY_ARGS);
    }

    public AbstractGriffonApplet(@Nonnull String[] stringArray) {
        Objects.requireNonNull(stringArray, "Argument 'args' must not be null");
        this.startupArgs = Arrays.copyOf(stringArray, stringArray.length);
        this.log = LoggerFactory.getLogger(this.getClass());
    }

    @Override
    public void init() {
        this.initialize();
        this.startup();
    }

    @Override
    public void start() {
        this.ready();
    }

    @Override
    public void stop() {
        this.event(ApplicationEvent.STOP_START, Arrays.asList(this));
        this.getApplicationConfigurer().runLifecycleHandler(Lifecycle.STOP);
        this.event(ApplicationEvent.STOP_END, Arrays.asList(this));
    }

    @Override
    public void destroy() {
        this.shutdown();
    }

    @Override
    @Nonnull
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public void setLocale(@Nonnull Locale locale) {
        Locale locale2 = this.locale;
        this.locale = locale;
        Locale.setDefault(locale);
        this.firePropertyChange("locale", locale2, locale);
    }

    @Nonnull
    public String[] getStartupArgs() {
        return this.startupArgs;
    }

    @Nonnull
    public Logger getLog() {
        return this.log;
    }

    public void setLocaleAsString(@Nullable String string) {
        this.setLocale(GriffonApplicationUtils.parseLocale((String)string));
    }

    public void addShutdownHandler(@Nonnull ShutdownHandler shutdownHandler) {
        Objects.requireNonNull(shutdownHandler, ERROR_SHUTDOWN_HANDLER_NULL);
        if (!this.shutdownHandlers.contains(shutdownHandler)) {
            this.shutdownHandlers.add(shutdownHandler);
        }
    }

    public void removeShutdownHandler(@Nonnull ShutdownHandler shutdownHandler) {
        Objects.requireNonNull(shutdownHandler, ERROR_SHUTDOWN_HANDLER_NULL);
        this.shutdownHandlers.remove(shutdownHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public ApplicationPhase getPhase() {
        Object[] objectArray = this.lock;
        synchronized (this.lock) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.phase;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setPhase(@Nonnull ApplicationPhase applicationPhase) {
        Objects.requireNonNull(applicationPhase, "Argument 'phase' must not be null");
        Object[] objectArray = this.lock;
        synchronized (this.lock) {
            this.phase = applicationPhase;
            this.firePropertyChange("phase", this.phase, this.phase);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Nonnull
    public ApplicationClassLoader getApplicationClassLoader() {
        return (ApplicationClassLoader)this.injector.getInstance(ApplicationClassLoader.class);
    }

    @Nonnull
    public Context getContext() {
        return (Context)this.injector.getInstance(Context.class, (Annotation)AnnotationUtils.named((String)"applicationContext"));
    }

    @Nonnull
    public Configuration getConfiguration() {
        return (Configuration)this.injector.getInstance(Configuration.class);
    }

    @Nonnull
    public UIThreadManager getUIThreadManager() {
        return (UIThreadManager)this.injector.getInstance(UIThreadManager.class);
    }

    @Nonnull
    public EventRouter getEventRouter() {
        return (EventRouter)this.injector.getInstance(EventRouter.class, (Annotation)AnnotationUtils.named((String)"applicationEventRouter"));
    }

    @Nonnull
    public ArtifactManager getArtifactManager() {
        return (ArtifactManager)this.injector.getInstance(ArtifactManager.class);
    }

    @Nonnull
    public ActionManager getActionManager() {
        return (ActionManager)this.injector.getInstance(ActionManager.class);
    }

    @Nonnull
    public AddonManager getAddonManager() {
        return (AddonManager)this.injector.getInstance(AddonManager.class);
    }

    @Nonnull
    public MVCGroupManager getMvcGroupManager() {
        return (MVCGroupManager)this.injector.getInstance(MVCGroupManager.class);
    }

    @Nonnull
    public MessageSource getMessageSource() {
        return (MessageSource)this.injector.getInstance(MessageSource.class, (Annotation)AnnotationUtils.named((String)"applicationMessageSource"));
    }

    @Nonnull
    public ResourceResolver getResourceResolver() {
        return (ResourceResolver)this.injector.getInstance(ResourceResolver.class, (Annotation)AnnotationUtils.named((String)"applicationResourceResolver"));
    }

    @Nonnull
    public ResourceHandler getResourceHandler() {
        return (ResourceHandler)this.injector.getInstance(ResourceHandler.class);
    }

    @Nonnull
    public ResourceInjector getResourceInjector() {
        return (ResourceInjector)this.injector.getInstance(ResourceInjector.class, (Annotation)AnnotationUtils.named((String)"applicationResourceInjector"));
    }

    @Nonnull
    public Injector<?> getInjector() {
        return this.injector;
    }

    public void setInjector(@Nonnull Injector<?> injector) {
        this.injector = Objects.requireNonNull(injector, "Argument 'injector' cannot be null");
        this.injector.injectMembers((Object)this);
        this.addShutdownHandler((ShutdownHandler)this.getWindowManager());
        MVCGroupExceptionHandler.registerWith((GriffonApplication)this);
    }

    @Nonnull
    public <W> WindowManager<W> getWindowManager() {
        return (WindowManager)this.injector.getInstance(WindowManager.class);
    }

    protected ApplicationConfigurer getApplicationConfigurer() {
        return (ApplicationConfigurer)this.injector.getInstance(ApplicationConfigurer.class);
    }

    public void initialize() {
        if (this.getPhase() == ApplicationPhase.INITIALIZE) {
            this.getApplicationConfigurer().init();
        }
    }

    public void ready() {
        if (this.getPhase() != ApplicationPhase.STARTUP) {
            return;
        }
        this.showStartingWindow();
        this.setPhase(ApplicationPhase.READY);
        this.event(ApplicationEvent.READY_START, Arrays.asList(this));
        this.getApplicationConfigurer().runLifecycleHandler(Lifecycle.READY);
        this.event(ApplicationEvent.READY_END, Arrays.asList(this));
        this.setPhase(ApplicationPhase.MAIN);
    }

    protected void showStartingWindow() {
        Object object = this.getWindowManager().getStartingWindow();
        if (object != null) {
            this.getWindowManager().show(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canShutdown() {
        this.event(ApplicationEvent.SHUTDOWN_REQUESTED, Arrays.asList(this));
        Object object = this.shutdownLock;
        synchronized (object) {
            for (ShutdownHandler shutdownHandler : this.shutdownHandlers) {
                if (shutdownHandler.canShutdown((GriffonApplication)this)) continue;
                this.event(ApplicationEvent.SHUTDOWN_ABORTED, Arrays.asList(this));
                if (this.log.isDebugEnabled()) {
                    try {
                        this.log.debug("Shutdown aborted by " + shutdownHandler);
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        this.log.debug("Shutdown aborted by a handler");
                    }
                }
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shutdown() {
        ArrayList arrayList;
        if (this.getPhase() == ApplicationPhase.SHUTDOWN) {
            return false;
        }
        if (!this.canShutdown()) {
            return false;
        }
        this.log.info("Shutdown is in process");
        this.setPhase(ApplicationPhase.SHUTDOWN);
        this.log.debug("Shutdown stage 1: notify all event listeners");
        if (this.getEventRouter().isEventPublishingEnabled()) {
            arrayList = new CountDownLatch(this.getUIThreadManager().isUIThread() ? 1 : 0);
            this.getEventRouter().addEventListener(ApplicationEvent.SHUTDOWN_START.getName(), new RunnableWithArgs((CountDownLatch)((Object)arrayList)){
                final /* synthetic */ CountDownLatch val$latch;
                {
                    this.val$latch = countDownLatch;
                }

                public void run(Object ... objectArray) {
                    this.val$latch.countDown();
                }
            });
            this.event(ApplicationEvent.SHUTDOWN_START, Arrays.asList(this));
            try {
                ((CountDownLatch)((Object)arrayList)).await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.log.debug("Shutdown stage 2: notify all shutdown handlers");
        arrayList = this.shutdownLock;
        synchronized (arrayList) {
            for (Object object : this.shutdownHandlers) {
                object.onShutdown((GriffonApplication)this);
            }
        }
        this.log.debug("Shutdown stage 3: destroy all MVC groups");
        arrayList = new ArrayList();
        arrayList.addAll(this.getMvcGroupManager().getGroups().keySet());
        for (Object object : arrayList) {
            this.getMvcGroupManager().destroyMVCGroup((String)object);
        }
        this.log.debug("Shutdown stage 4: execute Shutdown script");
        this.getApplicationConfigurer().runLifecycleHandler(Lifecycle.SHUTDOWN);
        ((ExecutorServiceManager)this.injector.getInstance(ExecutorServiceManager.class)).shutdownAll();
        this.injector.close();
        return true;
    }

    public void startup() {
        Object object;
        if (this.getPhase() != ApplicationPhase.INITIALIZE) {
            return;
        }
        this.setPhase(ApplicationPhase.STARTUP);
        this.event(ApplicationEvent.STARTUP_START, Arrays.asList(this));
        Object object2 = this.getConfiguration().get("application.startupGroups", null);
        if (object2 instanceof List) {
            this.log.info("Initializing all startup groups: {}", object2);
            for (String object3 : (List)object2) {
                this.getMvcGroupManager().createMVC(object3.trim());
            }
        } else if (object2 != null && object2.getClass().isArray()) {
            object = (Object[])object2;
            this.log.info("Initializing all startup groups: {}", (Object)Arrays.toString((Object[])object));
            for (Iterator iterator : object) {
                this.getMvcGroupManager().createMVC(String.valueOf(iterator).trim());
            }
        } else if (object2 != null && object2 instanceof String) {
            object = ((String)object2).split(",");
            this.log.info("Initializing all startup groups: {}", (Object)Arrays.toString((Object[])object));
            for (Iterator iterator : object) {
                this.getMvcGroupManager().createMVC(((String)((Object)iterator)).trim());
            }
        }
        for (Map.Entry entry : this.getAddonManager().getAddons().entrySet()) {
            List list = ((GriffonAddon)entry.getValue()).getStartupGroups();
            if (list.isEmpty()) continue;
            this.log.info("Initializing all {} startup groups: {}", entry.getKey(), (Object)list);
            Map map = ((GriffonAddon)entry.getValue()).getMvcGroups();
            for (String string : list) {
                if (!map.containsKey(string)) continue;
                this.getMvcGroupManager().createMVC(string.trim());
            }
        }
        this.getApplicationConfigurer().runLifecycleHandler(Lifecycle.STARTUP);
        this.event(ApplicationEvent.STARTUP_END, Arrays.asList(this));
    }

    protected void event(@Nonnull ApplicationEvent applicationEvent, @Nullable List<?> list) {
        this.getEventRouter().publishEvent(applicationEvent.getName(), list);
    }
}

