/*
 * Decompiled with CFR 0.152.
 */
package griffon.swing.editors;

import griffon.core.editors.AbstractPropertyEditor;
import griffon.util.GriffonNameUtils;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageInputStream;

public class BufferedImagePropertyEditor
extends AbstractPropertyEditor {
    protected void setValueInternal(Object object) {
        if (null == object) {
            super.setValueInternal(null);
        } else if (object instanceof CharSequence) {
            this.handleAsString(String.valueOf(object));
        } else if (object instanceof File) {
            this.handleAsFile((File)object);
        } else if (object instanceof URL) {
            this.handleAsURL((URL)object);
        } else if (object instanceof URI) {
            this.handleAsURI((URI)object);
        } else if (object instanceof InputStream) {
            this.handleAsInputStream((InputStream)object);
        } else if (object instanceof ImageInputStream) {
            this.handleAsImageInputStream((ImageInputStream)object);
        } else if (object instanceof BufferedImage) {
            super.setValueInternal(object);
        } else {
            throw this.illegalValue(object, BufferedImage.class);
        }
    }

    protected void handleAsString(String string) {
        if (GriffonNameUtils.isBlank((String)string)) {
            super.setValueInternal(null);
        } else {
            this.handleAsURL(((Object)((Object)this)).getClass().getClassLoader().getResource(string));
        }
    }

    protected void handleAsFile(File file) {
        try {
            super.setValueInternal((Object)ImageIO.read(file));
        }
        catch (IOException iOException) {
            throw this.illegalValue(file, BufferedImage.class, iOException);
        }
    }

    protected void handleAsURL(URL uRL) {
        try {
            super.setValueInternal((Object)ImageIO.read(uRL));
        }
        catch (IOException iOException) {
            throw this.illegalValue(uRL, BufferedImage.class, iOException);
        }
    }

    protected void handleAsURI(URI uRI) {
        try {
            this.handleAsURL(uRI.toURL());
        }
        catch (MalformedURLException malformedURLException) {
            throw this.illegalValue(uRI, BufferedImage.class, malformedURLException);
        }
    }

    protected void handleAsInputStream(InputStream inputStream) {
        try {
            super.setValueInternal((Object)ImageIO.read(inputStream));
        }
        catch (IOException iOException) {
            throw this.illegalValue(inputStream, BufferedImage.class, iOException);
        }
    }

    protected void handleAsImageInputStream(ImageInputStream imageInputStream) {
        try {
            super.setValueInternal((Object)ImageIO.read(imageInputStream));
        }
        catch (IOException iOException) {
            throw this.illegalValue(imageInputStream, BufferedImage.class, iOException);
        }
    }
}

