/*
 * Decompiled with CFR 0.152.
 */
package griffon.swing.editors;

import griffon.core.editors.AbstractPropertyEditor;
import griffon.core.formatters.Formatter;
import griffon.core.formatters.ParseException;
import griffon.swing.formatters.ColorFormatter;
import griffon.util.GriffonNameUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ColorPropertyEditor
extends AbstractPropertyEditor {
    public static String format(Color color) {
        return ColorFormatter.LONG.format(color);
    }

    public String getAsText() {
        if (null == this.getValue()) {
            return null;
        }
        return GriffonNameUtils.isBlank((String)this.getFormat()) ? ColorPropertyEditor.format((Color)this.getValueInternal()) : this.getFormattedValue();
    }

    protected void setValueInternal(Object object) {
        if (null == object) {
            super.setValueInternal(null);
        } else if (object instanceof CharSequence) {
            this.handleAsString(String.valueOf(object).trim());
        } else if (object instanceof List) {
            this.handleAsList((List)object);
        } else if (object instanceof Map) {
            this.handleAsMap((Map)object);
        } else if (object instanceof Number) {
            this.handleAsNumber((Number)object);
        } else if (object instanceof Color) {
            super.setValueInternal(object);
        } else {
            throw this.illegalValue(object, Color.class);
        }
    }

    protected Formatter<Color> resolveFormatter() {
        return !GriffonNameUtils.isBlank((String)this.getFormat()) ? ColorFormatter.getInstance(this.getFormat()) : null;
    }

    protected void handleAsString(String string) {
        try {
            if (GriffonNameUtils.isBlank((String)string)) {
                super.setValueInternal(null);
            } else {
                super.setValueInternal((Object)ColorFormatter.parseColor(string));
            }
        }
        catch (ParseException parseException) {
            throw this.illegalValue(string, Color.class, (Exception)((Object)parseException));
        }
    }

    protected void handleAsList(List<?> list) {
        if (list.isEmpty()) {
            super.setValueInternal(null);
            return;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.addAll(list);
        switch (list.size()) {
            case 3: {
                arrayList.add(255);
                break;
            }
            case 4: {
                break;
            }
            default: {
                throw this.illegalValue(list, Color.class);
            }
        }
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Object e = arrayList.get(i);
            if (e instanceof Number) {
                arrayList.set(i, this.parse((Number)e));
                continue;
            }
            if (e instanceof CharSequence) {
                arrayList.set(i, this.parse(String.valueOf(e)));
                continue;
            }
            throw this.illegalValue(list, Color.class);
        }
        super.setValueInternal((Object)new Color((Integer)arrayList.get(0), (Integer)arrayList.get(1), (Integer)arrayList.get(2), (Integer)arrayList.get(3)));
    }

    protected void handleAsMap(Map<?, ?> map) {
        if (map.isEmpty()) {
            super.setValueInternal(null);
            return;
        }
        int n = this.getMapValue(map, "red", 0);
        int n2 = this.getMapValue(map, "green", 0);
        int n3 = this.getMapValue(map, "blue", 0);
        int n4 = this.getMapValue(map, "alpha", 255);
        super.setValueInternal((Object)new Color(n, n2, n3, n4));
    }

    protected int parse(String string) {
        try {
            return Integer.parseInt(String.valueOf(string).trim(), 16) & 0xFF;
        }
        catch (NumberFormatException numberFormatException) {
            throw this.illegalValue(string, Color.class, numberFormatException);
        }
    }

    protected int parse(Number number) {
        return number.intValue() & 0xFF;
    }

    protected int getMapValue(Map<?, ?> map, String string, int n) {
        Object obj = map.get(string);
        if (null == obj) {
            obj = map.get(String.valueOf(string.charAt(0)));
        }
        if (null == obj) {
            return n;
        }
        if (obj instanceof CharSequence) {
            return this.parse(String.valueOf(obj));
        }
        if (obj instanceof Number) {
            return this.parse((Number)obj);
        }
        throw this.illegalValue(map, Color.class);
    }

    protected void handleAsNumber(Number number) {
        int n = this.parse(number);
        super.setValueInternal((Object)new Color(n, n, n, 255));
    }
}

