/*
 * Decompiled with CFR 0.152.
 */
package griffon.swing.editors;

import griffon.core.editors.AbstractPropertyEditor;
import griffon.util.GriffonNameUtils;
import java.awt.Font;
import java.util.List;
import java.util.Map;

public class FontPropertyEditor
extends AbstractPropertyEditor {
    public String getAsText() {
        if (null == this.getValue()) {
            return null;
        }
        Font font = (Font)this.getValue();
        return font.getFamily() + "-" + this.formatStyle(font) + "-" + font.getSize();
    }

    protected String formatStyle(Font font) {
        if (font.isBold() && font.isItalic()) {
            return "BOLDITALIC";
        }
        if (font.isBold()) {
            return "BOLD";
        }
        if (font.isItalic()) {
            return "ITALIC";
        }
        return "PLAIN";
    }

    protected void setValueInternal(Object object) {
        if (null == object) {
            super.setValueInternal(null);
        } else if (object instanceof CharSequence) {
            this.handleAsString(String.valueOf(object));
        } else if (object instanceof List) {
            this.handleAsList((List)object);
        } else if (object instanceof Map) {
            this.handleAsMap((Map)object);
        } else if (object instanceof Font) {
            super.setValueInternal(object);
        } else {
            throw this.illegalValue(object, Font.class);
        }
    }

    protected void handleAsString(String string) {
        if (GriffonNameUtils.isBlank((String)string)) {
            super.setValueInternal(null);
            return;
        }
        String[] stringArray = string.split("-");
        if (stringArray.length != 3) {
            throw this.illegalValue(string, Font.class);
        }
        String string2 = stringArray[0];
        int n = this.resolveStyle(string, stringArray[1]);
        int n2 = this.parseSize(string, stringArray[2]);
        super.setValueInternal((Object)new Font(string2, n, n2));
    }

    protected void handleAsList(List<?> list) {
        if (list.isEmpty()) {
            super.setValueInternal(null);
            return;
        }
        if (list.size() != 3) {
            throw this.illegalValue(list, Font.class);
        }
        String string = String.valueOf(list.get(0));
        int n = this.resolveStyle(list, String.valueOf(list.get(1)));
        int n2 = this.parseSize(list, String.valueOf(list.get(2)));
        super.setValueInternal((Object)new Font(string, n, n2));
    }

    protected void handleAsMap(Map<?, ?> map) {
        if (map.isEmpty()) {
            super.setValueInternal(null);
            return;
        }
        String string = this.getMapValue(map, "family", "");
        String string2 = this.getMapValue(map, "style", "");
        String string3 = this.getMapValue(map, "size", "");
        super.setValueInternal((Object)new Font(string, this.resolveStyle(map, string2), this.parseSize(map, string3)));
    }

    protected String getMapValue(Map<?, ?> map, String string, String string2) {
        Object obj = map.get(string);
        if (null == obj) {
            obj = map.get(String.valueOf(string.charAt(0)));
        }
        if (null == obj) {
            return string2;
        }
        if (obj instanceof CharSequence) {
            return String.valueOf(obj).trim();
        }
        throw this.illegalValue(map, Font.class);
    }

    protected int parseSize(Object object, String string) {
        int n;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw this.illegalValue(object, Font.class);
        }
        return n;
    }

    protected int resolveStyle(Object object, String string) {
        if ("PLAIN".equals(string.toUpperCase())) {
            return 0;
        }
        if ("BOLD".equals(string.toUpperCase())) {
            return 1;
        }
        if ("ITALIC".equals(string.toUpperCase())) {
            return 2;
        }
        if ("BOLDITALIC".equals(string.toUpperCase())) {
            return 3;
        }
        throw this.illegalValue(object, Font.class);
    }
}

