/*
 * Decompiled with CFR 0.152.
 */
package griffon.swing.editors;

import griffon.core.editors.AbstractPropertyEditor;
import griffon.swing.editors.ColorPropertyEditor;
import griffon.util.GriffonNameUtils;
import java.awt.Color;
import java.awt.GradientPaint;
import java.util.List;
import java.util.Map;

public class GradientPaintPropertyEditor
extends AbstractPropertyEditor {
    public String getAsText() {
        if (null == this.getValue()) {
            return null;
        }
        GradientPaint gradientPaint = (GradientPaint)this.getValue();
        return gradientPaint.getPoint1().getX() + ", " + gradientPaint.getPoint1().getY() + ", " + ColorPropertyEditor.format(gradientPaint.getColor1()) + ", " + gradientPaint.getPoint2().getX() + ", " + gradientPaint.getPoint2().getY() + ", " + ColorPropertyEditor.format(gradientPaint.getColor2()) + ", " + gradientPaint.isCyclic();
    }

    protected void setValueInternal(Object object) {
        if (null == object) {
            super.setValueInternal(null);
        } else if (object instanceof CharSequence) {
            this.handleAsString(String.valueOf(object));
        } else if (object instanceof List) {
            this.handleAsList((List)object);
        } else if (object instanceof Map) {
            this.handleAsMap((Map)object);
        } else if (object instanceof GradientPaint) {
            super.setValueInternal(object);
        } else {
            throw this.illegalValue(object, GradientPaint.class);
        }
    }

    protected void handleAsString(String string) {
        if (GriffonNameUtils.isBlank((String)string)) {
            super.setValueInternal(null);
            return;
        }
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        Color color = Color.WHITE;
        Color color2 = Color.BLACK;
        boolean bl = false;
        if (string.contains("|")) {
            String[] stringArray = string.split("\\|");
            switch (stringArray.length) {
                case 4: {
                    bl = this.parseBoolean(stringArray[3]);
                }
                case 3: {
                    ColorPropertyEditor colorPropertyEditor = new ColorPropertyEditor();
                    String[] stringArray2 = stringArray[0].split(",");
                    if (stringArray2.length != 2) {
                        throw this.illegalValue(string, GradientPaint.class);
                    }
                    f = this.parseValue(stringArray2[0]);
                    f2 = this.parseValue(stringArray2[1]);
                    String[] stringArray3 = stringArray[1].split(",");
                    if (stringArray3.length != 2) {
                        throw this.illegalValue(string, GradientPaint.class);
                    }
                    f3 = this.parseValue(stringArray3[0]);
                    f4 = this.parseValue(stringArray3[1]);
                    String[] stringArray4 = stringArray[2].split(",");
                    try {
                        colorPropertyEditor.setAsText(stringArray4[0]);
                        color = (Color)colorPropertyEditor.getValue();
                    }
                    catch (Exception exception) {
                        throw this.illegalValue(stringArray4[0], GradientPaint.class);
                    }
                    try {
                        colorPropertyEditor.setAsText(stringArray4[1]);
                        color2 = (Color)colorPropertyEditor.getValue();
                    }
                    catch (Exception exception) {
                        throw this.illegalValue(stringArray4[1], GradientPaint.class);
                    }
                    super.setValueInternal((Object)new GradientPaint(f, f2, color, f3, f4, color2, bl));
                    break;
                }
                default: {
                    throw this.illegalValue(string, GradientPaint.class);
                }
            }
        } else {
            String[] stringArray = string.split(",");
            switch (stringArray.length) {
                case 7: {
                    bl = this.parseBoolean(stringArray[6]);
                }
                case 6: {
                    ColorPropertyEditor colorPropertyEditor = new ColorPropertyEditor();
                    f = this.parseValue(stringArray[0]);
                    f2 = this.parseValue(stringArray[1]);
                    f3 = this.parseValue(stringArray[3]);
                    f4 = this.parseValue(stringArray[4]);
                    try {
                        colorPropertyEditor.setAsText(stringArray[2]);
                        color = (Color)colorPropertyEditor.getValue();
                    }
                    catch (Exception exception) {
                        throw this.illegalValue(stringArray[2], GradientPaint.class);
                    }
                    try {
                        colorPropertyEditor.setAsText(stringArray[5]);
                        color2 = (Color)colorPropertyEditor.getValue();
                    }
                    catch (Exception exception) {
                        throw this.illegalValue(stringArray[5], GradientPaint.class);
                    }
                    super.setValueInternal((Object)new GradientPaint(f, f2, color, f3, f4, color2, bl));
                    break;
                }
                default: {
                    throw this.illegalValue(string, GradientPaint.class);
                }
            }
        }
    }

    protected void handleAsList(List<?> list) {
        if (list.isEmpty()) {
            super.setValueInternal(null);
            return;
        }
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        Color color = Color.WHITE;
        Color color2 = Color.BLACK;
        boolean bl = false;
        switch (list.size()) {
            case 7: {
                bl = this.parseBoolean(String.valueOf(list.get(6)));
            }
            case 6: {
                ColorPropertyEditor colorPropertyEditor = new ColorPropertyEditor();
                f = this.parseValue(list.get(0));
                f2 = this.parseValue(list.get(1));
                f3 = this.parseValue(list.get(3));
                f4 = this.parseValue(list.get(4));
                try {
                    colorPropertyEditor.setValueInternal(list.get(2));
                    color = (Color)colorPropertyEditor.getValue();
                }
                catch (Exception exception) {
                    throw this.illegalValue(list.get(2), GradientPaint.class);
                }
                try {
                    colorPropertyEditor.setValueInternal(list.get(5));
                    color2 = (Color)colorPropertyEditor.getValue();
                }
                catch (Exception exception) {
                    throw this.illegalValue(list.get(5), GradientPaint.class);
                }
                super.setValueInternal((Object)new GradientPaint(f, f2, color, f3, f4, color2, bl));
                break;
            }
            default: {
                throw this.illegalValue(list, GradientPaint.class);
            }
        }
    }

    protected void handleAsMap(Map<?, ?> map) {
        if (map.isEmpty()) {
            super.setValueInternal(null);
            return;
        }
        float f = ((Float)this.getMapValue(map, "x1", Float.valueOf(0.0f))).floatValue();
        float f2 = ((Float)this.getMapValue(map, "y1", Float.valueOf(0.0f))).floatValue();
        float f3 = ((Float)this.getMapValue(map, "x2", Float.valueOf(0.0f))).floatValue();
        float f4 = ((Float)this.getMapValue(map, "y2", Float.valueOf(0.0f))).floatValue();
        Color color = Color.WHITE;
        Color color2 = Color.BLACK;
        boolean bl = false;
        ColorPropertyEditor colorPropertyEditor = new ColorPropertyEditor();
        Object obj = map.get("c1");
        try {
            if (null != obj) {
                colorPropertyEditor.setValueInternal(obj);
                color = (Color)colorPropertyEditor.getValue();
            } else {
                color = Color.WHITE;
            }
        }
        catch (Exception exception) {
            throw this.illegalValue(obj, GradientPaint.class);
        }
        obj = map.get("c2");
        try {
            if (null != obj) {
                colorPropertyEditor.setValueInternal(obj);
                color2 = (Color)colorPropertyEditor.getValue();
            } else {
                color2 = Color.BLACK;
            }
        }
        catch (Exception exception) {
            throw this.illegalValue(obj, GradientPaint.class);
        }
        Object obj2 = map.get("cyclic");
        if (null != obj2) {
            bl = this.parseBoolean(String.valueOf(obj2));
        }
        super.setValueInternal((Object)new GradientPaint(f, f2, color, f3, f4, color2, bl));
    }

    protected float parse(String string) {
        try {
            return Float.parseFloat(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw this.illegalValue(string, GradientPaint.class, numberFormatException);
        }
    }

    protected boolean parseBoolean(String string) {
        try {
            return Boolean.parseBoolean(string.trim());
        }
        catch (Exception exception) {
            throw this.illegalValue(string, GradientPaint.class, exception);
        }
    }

    protected float parseValue(Object object) {
        if (object instanceof CharSequence) {
            return this.parse(String.valueOf(object));
        }
        if (object instanceof Number) {
            return this.parse((Number)object);
        }
        throw this.illegalValue(object, GradientPaint.class);
    }

    protected float parse(Number number) {
        return number.floatValue();
    }

    protected Object getMapValue(Map<?, ?> map, String string, Object object) {
        Object obj = map.get(string);
        if (null == obj) {
            return object;
        }
        if (obj instanceof CharSequence) {
            return Float.valueOf(this.parse(String.valueOf(obj)));
        }
        if (obj instanceof Number) {
            return Float.valueOf(this.parse((Number)obj));
        }
        throw this.illegalValue(map, GradientPaint.class);
    }
}

