/*
 * Decompiled with CFR 0.152.
 */
package griffon.swing.editors;

import griffon.core.editors.AbstractPropertyEditor;
import griffon.util.GriffonNameUtils;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageInputStream;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class IconPropertyEditor
extends AbstractPropertyEditor {
    protected void setValueInternal(Object object) {
        if (null == object) {
            super.setValueInternal(null);
        } else if (object instanceof CharSequence) {
            this.handleAsString(String.valueOf(object));
        } else if (object instanceof File) {
            this.handleAsFile((File)object);
        } else if (object instanceof URL) {
            this.handleAsURL((URL)object);
        } else if (object instanceof URI) {
            this.handleAsURI((URI)object);
        } else if (object instanceof InputStream) {
            this.handleAsInputStream((InputStream)object);
        } else if (object instanceof ImageInputStream) {
            this.handleAsImageInputStream((ImageInputStream)object);
        } else if (object instanceof byte[]) {
            this.handleAsByteArray((byte[])object);
        } else if (object instanceof Image) {
            this.handleAsImage((Image)object);
        } else if (object instanceof Icon) {
            super.setValueInternal(object);
        } else {
            throw this.illegalValue(object, Icon.class);
        }
    }

    protected void handleAsString(String string) {
        if (GriffonNameUtils.isBlank((String)string)) {
            super.setValueInternal(null);
            return;
        }
        if (string.contains("|")) {
            this.handleAsClassWithArg(string);
        } else {
            this.handleAsURL(((Object)((Object)this)).getClass().getClassLoader().getResource(string));
        }
    }

    protected void handleAsClassWithArg(String string) {
        String[] stringArray = string.split("\\|");
        if (stringArray.length == 2) {
            Class<?> clazz = null;
            try {
                clazz = IconPropertyEditor.class.getClassLoader().loadClass(stringArray[0]);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw this.illegalValue(string, Icon.class, classNotFoundException);
            }
            Constructor<?> constructor = null;
            try {
                constructor = clazz.getConstructor(String.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw this.illegalValue(string, Icon.class, noSuchMethodException);
            }
            try {
                super.setValueInternal(constructor.newInstance(stringArray[1]));
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException reflectiveOperationException) {
                throw this.illegalValue(string, Icon.class, reflectiveOperationException);
            }
        }
        throw this.illegalValue(string, Icon.class);
    }

    protected void handleAsFile(File file) {
        try {
            this.handleAsImage(ImageIO.read(file));
        }
        catch (IOException iOException) {
            throw this.illegalValue(file, Icon.class, iOException);
        }
    }

    protected void handleAsURL(URL uRL) {
        try {
            this.handleAsImage(ImageIO.read(uRL));
        }
        catch (IOException iOException) {
            throw this.illegalValue(uRL, Icon.class, iOException);
        }
    }

    protected void handleAsURI(URI uRI) {
        try {
            this.handleAsURL(uRI.toURL());
        }
        catch (MalformedURLException malformedURLException) {
            throw this.illegalValue(uRI, Icon.class, malformedURLException);
        }
    }

    protected void handleAsInputStream(InputStream inputStream) {
        try {
            this.handleAsImage(ImageIO.read(inputStream));
        }
        catch (IOException iOException) {
            throw this.illegalValue(inputStream, Icon.class, iOException);
        }
    }

    protected void handleAsImageInputStream(ImageInputStream imageInputStream) {
        try {
            this.handleAsImage(ImageIO.read(imageInputStream));
        }
        catch (IOException iOException) {
            throw this.illegalValue(imageInputStream, Icon.class, iOException);
        }
    }

    protected void handleAsByteArray(byte[] byArray) {
        super.setValueInternal((Object)new ImageIcon(byArray));
    }

    protected void handleAsImage(Image image) {
        super.setValueInternal((Object)new ImageIcon(image));
    }
}

