/*
 * Decompiled with CFR 0.152.
 */
package griffon.swing.editors;

import griffon.core.editors.AbstractPropertyEditor;
import griffon.util.GriffonNameUtils;
import java.awt.Insets;
import java.util.List;
import java.util.Map;

public class InsetsPropertyEditor
extends AbstractPropertyEditor {
    public String getAsText() {
        if (null == this.getValue()) {
            return null;
        }
        Insets insets = (Insets)this.getValue();
        return insets.top + ", " + insets.left + ", " + insets.bottom + ", " + insets.right;
    }

    protected void setValueInternal(Object object) {
        if (null == object) {
            super.setValueInternal(null);
        } else if (object instanceof CharSequence) {
            this.handleAsString(String.valueOf(object));
        } else if (object instanceof List) {
            this.handleAsList((List)object);
        } else if (object instanceof Map) {
            this.handleAsMap((Map)object);
        } else if (object instanceof Number) {
            this.handleAsNumber((Number)object);
        } else if (object instanceof Insets) {
            super.setValueInternal(object);
        } else {
            throw this.illegalValue(object, Insets.class);
        }
    }

    protected void handleAsString(String string) {
        if (GriffonNameUtils.isBlank((String)string)) {
            super.setValueInternal(null);
            return;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        String[] stringArray = string.split(",");
        switch (stringArray.length) {
            case 4: {
                n4 = this.parseValue(stringArray[3]);
            }
            case 3: {
                n3 = this.parseValue(stringArray[2]);
            }
            case 2: {
                n2 = this.parseValue(stringArray[1]);
            }
            case 1: {
                n = this.parseValue(stringArray[0]);
                super.setValueInternal((Object)new Insets(n, n2, n3, n4));
                break;
            }
            default: {
                throw this.illegalValue(string, Insets.class);
            }
        }
    }

    protected void handleAsList(List<?> list) {
        if (list.isEmpty()) {
            super.setValueInternal(null);
            return;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        switch (list.size()) {
            case 4: {
                n4 = this.parseValue(list.get(3));
            }
            case 3: {
                n3 = this.parseValue(list.get(2));
            }
            case 2: {
                n2 = this.parseValue(list.get(1));
            }
            case 1: {
                n = this.parseValue(list.get(0));
                super.setValueInternal((Object)new Insets(n, n2, n3, n4));
                break;
            }
            default: {
                throw this.illegalValue(list, Insets.class);
            }
        }
    }

    protected void handleAsMap(Map<?, ?> map) {
        if (map.isEmpty()) {
            super.setValueInternal(null);
            return;
        }
        int n = this.getMapValue(map, "top", 0);
        int n2 = this.getMapValue(map, "left", 0);
        int n3 = this.getMapValue(map, "right", 0);
        int n4 = this.getMapValue(map, "bottom", 0);
        super.setValueInternal((Object)new Insets(n, n2, n3, n4));
    }

    protected int parseValue(Object object) {
        if (object instanceof CharSequence) {
            return this.parse(String.valueOf(object));
        }
        if (object instanceof Number) {
            return this.parse((Number)object);
        }
        throw this.illegalValue(object, Insets.class);
    }

    protected int parse(String string) {
        try {
            return Integer.parseInt(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw this.illegalValue(string, Insets.class, numberFormatException);
        }
    }

    protected int parse(Number number) {
        return number.intValue();
    }

    protected int getMapValue(Map<?, ?> map, String string, int n) {
        Object obj = map.get(string);
        if (null == obj) {
            obj = map.get(String.valueOf(string.charAt(0)));
        }
        if (null == obj) {
            return n;
        }
        if (obj instanceof CharSequence) {
            return this.parse(String.valueOf(obj));
        }
        if (obj instanceof Number) {
            return this.parse((Number)obj);
        }
        throw this.illegalValue(map, Insets.class);
    }

    protected void handleAsNumber(Number number) {
        int n = this.parse(number);
        super.setValueInternal((Object)new Insets(n, n, n, n));
    }
}

