/*
 * Decompiled with CFR 0.152.
 */
package griffon.swing.editors;

import griffon.core.editors.AbstractPropertyEditor;
import griffon.swing.editors.ColorPropertyEditor;
import griffon.util.GriffonNameUtils;
import java.awt.Color;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;

public class LinearGradientPaintPropertyEditor
extends AbstractPropertyEditor {
    public String getAsText() {
        if (null == this.getValue()) {
            return null;
        }
        LinearGradientPaint linearGradientPaint = (LinearGradientPaint)this.getValue();
        return linearGradientPaint.getStartPoint().getX() + ", " + linearGradientPaint.getStartPoint().getY() + ", " + linearGradientPaint.getEndPoint().getX() + ", " + linearGradientPaint.getEndPoint().getY() + ", " + this.formatFractions(linearGradientPaint.getFractions()) + ", " + this.formatColors(linearGradientPaint.getColors()) + ", " + linearGradientPaint.getCycleMethod().name();
    }

    protected String formatFractions(float[] fArray) {
        StringBuilder stringBuilder = new StringBuilder("[");
        boolean bl = true;
        for (float f : fArray) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(":");
            }
            stringBuilder.append(f);
        }
        return stringBuilder.append("]").toString();
    }

    protected String formatColors(Color[] colorArray) {
        StringBuilder stringBuilder = new StringBuilder("[");
        boolean bl = true;
        for (Color color : colorArray) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(":");
            }
            stringBuilder.append(ColorPropertyEditor.format(color));
        }
        return stringBuilder.append("]").toString();
    }

    protected void setValueInternal(Object object) {
        if (null == object) {
            super.setValueInternal(null);
        } else if (object instanceof CharSequence) {
            this.handleAsString(String.valueOf(object));
        } else if (object instanceof List) {
            this.handleAsList((List)object);
        } else if (object instanceof Map) {
            this.handleAsMap((Map)object);
        } else if (object instanceof LinearGradientPaint) {
            super.setValueInternal(object);
        } else {
            throw this.illegalValue(object, LinearGradientPaint.class);
        }
    }

    protected void handleAsString(String string) {
        if (GriffonNameUtils.isBlank((String)string)) {
            super.setValueInternal(null);
            return;
        }
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float[] fArray = null;
        Color[] colorArray = null;
        MultipleGradientPaint.CycleMethod cycleMethod = MultipleGradientPaint.CycleMethod.NO_CYCLE;
        String[] stringArray = string.split(",");
        switch (stringArray.length) {
            case 7: {
                cycleMethod = this.parseCyclicMethod(string, stringArray[6]);
            }
            case 6: {
                f = this.parseValue(stringArray[0]);
                f2 = this.parseValue(stringArray[1]);
                f3 = this.parseValue(stringArray[2]);
                f4 = this.parseValue(stringArray[3]);
                fArray = this.parseFractions((Object)string, stringArray[4].trim());
                colorArray = this.parseColors((Object)string, stringArray[5].trim());
                if (fArray.length != colorArray.length) {
                    throw this.illegalValue(string, LinearGradientPaint.class);
                }
                super.setValueInternal((Object)new LinearGradientPaint(f, f2, f3, f4, fArray, colorArray, cycleMethod));
                break;
            }
            default: {
                throw this.illegalValue(string, LinearGradientPaint.class);
            }
        }
    }

    protected void handleAsList(List<?> list) {
        if (list.isEmpty()) {
            super.setValueInternal(null);
            return;
        }
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float[] fArray = null;
        Color[] colorArray = null;
        MultipleGradientPaint.CycleMethod cycleMethod = MultipleGradientPaint.CycleMethod.NO_CYCLE;
        switch (list.size()) {
            case 7: {
                cycleMethod = this.parseCyclicMethod(list, String.valueOf(list.get(6)).trim());
            }
            case 6: {
                f = this.parseValue(list.get(0));
                f2 = this.parseValue(list.get(1));
                f3 = this.parseValue(list.get(2));
                f4 = this.parseValue(list.get(3));
                fArray = this.parseFractions(list, list.get(4));
                colorArray = this.parseColors(list, list.get(5));
                if (fArray.length != colorArray.length) {
                    throw this.illegalValue(list, LinearGradientPaint.class);
                }
                super.setValueInternal((Object)new LinearGradientPaint(f, f2, f3, f4, fArray, colorArray, cycleMethod));
                break;
            }
            default: {
                throw this.illegalValue(list, LinearGradientPaint.class);
            }
        }
    }

    protected void handleAsMap(Map<?, ?> map) {
        Color[] colorArray;
        if (map.isEmpty()) {
            super.setValueInternal(null);
            return;
        }
        float f = ((Float)this.getMapValue(map, "x1", Float.valueOf(0.0f))).floatValue();
        float f2 = ((Float)this.getMapValue(map, "y1", Float.valueOf(0.0f))).floatValue();
        float f3 = ((Float)this.getMapValue(map, "x2", Float.valueOf(0.0f))).floatValue();
        float f4 = ((Float)this.getMapValue(map, "y2", Float.valueOf(0.0f))).floatValue();
        MultipleGradientPaint.CycleMethod cycleMethod = MultipleGradientPaint.CycleMethod.NO_CYCLE;
        float[] fArray = this.parseFractions(map, map.get("fractions"));
        if (fArray.length != (colorArray = this.parseColors(map, map.get("colors"))).length) {
            throw this.illegalValue(map, LinearGradientPaint.class);
        }
        Object obj = map.get("cycle");
        if (null != obj) {
            cycleMethod = this.parseCyclicMethod(map, String.valueOf(obj));
        }
        super.setValueInternal((Object)new LinearGradientPaint(f, f2, f3, f4, fArray, colorArray, cycleMethod));
    }

    protected float[] parseFractions(Object object, Object object2) {
        if (object2 instanceof CharSequence) {
            return this.parseFractions(object, String.valueOf(object2).trim());
        }
        if (object2 instanceof List) {
            return this.parseFractions(object, (List)object2);
        }
        throw this.illegalValue(object, LinearGradientPaint.class);
    }

    protected float[] parseFractions(Object object, String string) {
        if (!string.startsWith("[") || !string.endsWith("]")) {
            throw this.illegalValue(object, LinearGradientPaint.class);
        }
        String[] stringArray = string.substring(1, string.length() - 1).split(":");
        float[] fArray = new float[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            fArray[i] = this.parseValue(stringArray[i]);
        }
        return fArray;
    }

    protected float[] parseFractions(Object object, List<?> list) {
        float[] fArray = new float[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            fArray[i] = this.parseValue(list.get(i));
        }
        return fArray;
    }

    protected Color[] parseColors(Object object, Object object2) {
        if (object2 instanceof CharSequence) {
            return this.parseColors(object, String.valueOf(object2).trim());
        }
        if (object2 instanceof List) {
            return this.parseColors(object, (List)object2);
        }
        throw this.illegalValue(object, LinearGradientPaint.class);
    }

    protected Color[] parseColors(Object object, String string) {
        if (!string.startsWith("[") || !string.endsWith("]")) {
            throw this.illegalValue(object, LinearGradientPaint.class);
        }
        String[] stringArray = string.substring(1, string.length() - 1).split(":");
        Color[] colorArray = new Color[stringArray.length];
        ColorPropertyEditor colorPropertyEditor = new ColorPropertyEditor();
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                colorPropertyEditor.setValueInternal(stringArray[i]);
                colorArray[i] = (Color)colorPropertyEditor.getValue();
                continue;
            }
            catch (Exception exception) {
                throw this.illegalValue(stringArray[i], LinearGradientPaint.class);
            }
        }
        return colorArray;
    }

    protected Color[] parseColors(Object object, List<?> list) {
        Color[] colorArray = new Color[list.size()];
        ColorPropertyEditor colorPropertyEditor = new ColorPropertyEditor();
        for (int i = 0; i < list.size(); ++i) {
            try {
                colorPropertyEditor.setValueInternal(list.get(i));
                colorArray[i] = (Color)colorPropertyEditor.getValue();
                continue;
            }
            catch (Exception exception) {
                throw this.illegalValue(list.get(i), LinearGradientPaint.class, exception);
            }
        }
        return colorArray;
    }

    protected MultipleGradientPaint.CycleMethod parseCyclicMethod(Object object, String string) {
        try {
            Field field = MultipleGradientPaint.CycleMethod.class.getDeclaredField(string.toUpperCase().trim());
            return (MultipleGradientPaint.CycleMethod)((Object)field.get(null));
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            throw this.illegalValue(object, LinearGradientPaint.class, reflectiveOperationException);
        }
    }

    protected float parse(String string) {
        try {
            return Float.parseFloat(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw this.illegalValue(string, LinearGradientPaint.class, numberFormatException);
        }
    }

    protected float parseValue(Object object) {
        if (object instanceof CharSequence) {
            return this.parse(String.valueOf(object));
        }
        if (object instanceof Number) {
            return this.parse((Number)object);
        }
        throw this.illegalValue(object, LinearGradientPaint.class);
    }

    protected float parse(Number number) {
        return number.floatValue();
    }

    protected Object getMapValue(Map<?, ?> map, String string, Object object) {
        Object obj = map.get(string);
        if (null == obj) {
            return object;
        }
        if (obj instanceof CharSequence) {
            return Float.valueOf(this.parse(String.valueOf(obj)));
        }
        if (obj instanceof Number) {
            return Float.valueOf(this.parse((Number)obj));
        }
        throw this.illegalValue(map, LinearGradientPaint.class);
    }
}

