/*
 * Decompiled with CFR 0.152.
 */
package griffon.swing.editors;

import griffon.core.editors.AbstractPropertyEditor;
import griffon.util.GriffonNameUtils;
import java.awt.geom.Point2D;
import java.util.List;
import java.util.Map;

public class Point2DPropertyEditor
extends AbstractPropertyEditor {
    public String getAsText() {
        if (null == this.getValue()) {
            return null;
        }
        Point2D point2D = (Point2D)this.getValue();
        return point2D.getX() + ", " + point2D.getY();
    }

    protected void setValueInternal(Object object) {
        if (null == object) {
            super.setValueInternal(null);
        } else if (object instanceof CharSequence) {
            this.handleAsString(String.valueOf(object));
        } else if (object instanceof List) {
            this.handleAsList((List)object);
        } else if (object instanceof Map) {
            this.handleAsMap((Map)object);
        } else if (object instanceof Number) {
            this.handleAsNumber((Number)object);
        } else if (object instanceof Point2D) {
            super.setValueInternal(object);
        } else {
            throw this.illegalValue(object, Point2D.class);
        }
    }

    protected void handleAsString(String string) {
        if (GriffonNameUtils.isBlank((String)string)) {
            super.setValueInternal(null);
            return;
        }
        String[] stringArray = string.split(",");
        switch (stringArray.length) {
            case 1: {
                double d = this.parseValue(stringArray[0]);
                super.setValueInternal((Object)new Point2D.Double(d, d));
                break;
            }
            case 2: {
                double d = this.parseValue(stringArray[0]);
                double d2 = this.parseValue(stringArray[1]);
                super.setValueInternal((Object)new Point2D.Double(d, d2));
                break;
            }
            default: {
                throw this.illegalValue(string, Point2D.class);
            }
        }
    }

    protected void handleAsList(List<?> list) {
        if (list.isEmpty()) {
            super.setValueInternal(null);
            return;
        }
        switch (list.size()) {
            case 1: {
                double d = this.parseValue(list.get(0));
                super.setValueInternal((Object)new Point2D.Double(d, d));
                break;
            }
            case 2: {
                double d = this.parseValue(list.get(0));
                double d2 = this.parseValue(list.get(1));
                super.setValueInternal((Object)new Point2D.Double(d, d2));
                break;
            }
            default: {
                throw this.illegalValue(list, Point2D.class);
            }
        }
    }

    protected void handleAsMap(Map<?, ?> map) {
        if (map.isEmpty()) {
            super.setValueInternal(null);
            return;
        }
        double d = this.getMapValue(map, "x", 0);
        double d2 = this.getMapValue(map, "y", 0);
        super.setValueInternal((Object)new Point2D.Double(d, d2));
    }

    protected double parseValue(Object object) {
        if (object instanceof CharSequence) {
            return this.parse(String.valueOf(object));
        }
        if (object instanceof Number) {
            return this.parse((Number)object);
        }
        throw this.illegalValue(object, Point2D.class);
    }

    protected double parse(String string) {
        try {
            return Double.parseDouble(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw this.illegalValue(string, Point2D.class, numberFormatException);
        }
    }

    protected double parse(Number number) {
        return number.doubleValue();
    }

    protected double getMapValue(Map<?, ?> map, String string, int n) {
        Object obj = map.get(string);
        if (null == obj) {
            return n;
        }
        if (obj instanceof CharSequence) {
            return this.parse(String.valueOf(obj));
        }
        if (obj instanceof Number) {
            return this.parse((Number)obj);
        }
        throw this.illegalValue(map, Point2D.class);
    }

    protected void handleAsNumber(Number number) {
        double d = this.parse(number);
        super.setValueInternal((Object)new Point2D.Double(d, d));
    }
}

