/*
 * Decompiled with CFR 0.152.
 */
package griffon.swing.editors;

import griffon.core.editors.AbstractPropertyEditor;
import griffon.util.GriffonNameUtils;
import java.awt.Point;
import java.util.List;
import java.util.Map;

public class PointPropertyEditor
extends AbstractPropertyEditor {
    public String getAsText() {
        if (null == this.getValue()) {
            return null;
        }
        Point point = (Point)this.getValue();
        return point.getX() + ", " + point.getY();
    }

    protected void setValueInternal(Object object) {
        if (null == object) {
            super.setValueInternal(null);
        } else if (object instanceof CharSequence) {
            this.handleAsString(String.valueOf(object));
        } else if (object instanceof List) {
            this.handleAsList((List)object);
        } else if (object instanceof Map) {
            this.handleAsMap((Map)object);
        } else if (object instanceof Number) {
            this.handleAsNumber((Number)object);
        } else if (object instanceof Point) {
            super.setValueInternal(object);
        } else {
            throw this.illegalValue(object, Point.class);
        }
    }

    protected void handleAsString(String string) {
        if (GriffonNameUtils.isBlank((String)string)) {
            super.setValueInternal(null);
            return;
        }
        String[] stringArray = string.split(",");
        switch (stringArray.length) {
            case 1: {
                int n = this.parseValue(stringArray[0]);
                super.setValueInternal((Object)new Point(n, n));
                break;
            }
            case 2: {
                int n = this.parseValue(stringArray[0]);
                int n2 = this.parseValue(stringArray[1]);
                super.setValueInternal((Object)new Point(n, n2));
                break;
            }
            default: {
                throw this.illegalValue(string, Point.class);
            }
        }
    }

    protected void handleAsList(List<?> list) {
        if (list.isEmpty()) {
            super.setValueInternal(null);
            return;
        }
        switch (list.size()) {
            case 1: {
                int n = this.parseValue(list.get(0));
                super.setValueInternal((Object)new Point(n, n));
                break;
            }
            case 2: {
                int n = this.parseValue(list.get(0));
                int n2 = this.parseValue(list.get(1));
                super.setValueInternal((Object)new Point(n, n2));
                break;
            }
            default: {
                throw this.illegalValue(list, Point.class);
            }
        }
    }

    protected void handleAsMap(Map<?, ?> map) {
        if (map.isEmpty()) {
            super.setValueInternal(null);
            return;
        }
        int n = this.getMapValue(map, "x", 0);
        int n2 = this.getMapValue(map, "y", 0);
        super.setValueInternal((Object)new Point(n, n2));
    }

    protected int parseValue(Object object) {
        if (object instanceof CharSequence) {
            return this.parse(String.valueOf(object));
        }
        if (object instanceof Number) {
            return this.parse((Number)object);
        }
        throw this.illegalValue(object, Point.class);
    }

    protected int parse(String string) {
        try {
            return Integer.parseInt(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw this.illegalValue(string, Point.class, numberFormatException);
        }
    }

    protected int parse(Number number) {
        return number.intValue();
    }

    protected int getMapValue(Map<?, ?> map, String string, int n) {
        Object obj = map.get(string);
        if (null == obj) {
            return n;
        }
        if (obj instanceof CharSequence) {
            return this.parse(String.valueOf(obj));
        }
        if (obj instanceof Number) {
            return this.parse((Number)obj);
        }
        throw this.illegalValue(map, Point.class);
    }

    protected void handleAsNumber(Number number) {
        int n = this.parse(number);
        super.setValueInternal((Object)new Point(n, n));
    }
}

